/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetApplicationResponse extends QBusinessResponse implements
        ToCopyableBuilder<GetApplicationResponse.Builder, GetApplicationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationArn").getter(getter(GetApplicationResponse::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()).build();

    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(GetApplicationResponse::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<AppliedAttachmentsConfiguration> ATTACHMENTS_CONFIGURATION_FIELD = SdkField
            .<AppliedAttachmentsConfiguration> builder(MarshallingType.SDK_POJO).memberName("attachmentsConfiguration")
            .getter(getter(GetApplicationResponse::attachmentsConfiguration)).setter(setter(Builder::attachmentsConfiguration))
            .constructor(AppliedAttachmentsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentsConfiguration").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetApplicationResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetApplicationResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(GetApplicationResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<EncryptionConfiguration> builder(MarshallingType.SDK_POJO).memberName("encryptionConfiguration")
            .getter(getter(GetApplicationResponse::encryptionConfiguration)).setter(setter(Builder::encryptionConfiguration))
            .constructor(EncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build())
            .build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(GetApplicationResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetApplicationResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetApplicationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetApplicationResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_ID_FIELD, ATTACHMENTS_CONFIGURATION_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD,
            ENCRYPTION_CONFIGURATION_FIELD, ERROR_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));

    private final String applicationArn;

    private final String applicationId;

    private final AppliedAttachmentsConfiguration attachmentsConfiguration;

    private final Instant createdAt;

    private final String description;

    private final String displayName;

    private final EncryptionConfiguration encryptionConfiguration;

    private final ErrorDetail error;

    private final String roleArn;

    private final String status;

    private final Instant updatedAt;

    private GetApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationArn = builder.applicationArn;
        this.applicationId = builder.applicationId;
        this.attachmentsConfiguration = builder.attachmentsConfiguration;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.error = builder.error;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q application.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q application.
     * </p>
     * 
     * @return The identifier of the Amazon Q application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * Settings for whether end users can upload files directly during chat.
     * </p>
     * 
     * @return Settings for whether end users can upload files directly during chat.
     */
    public final AppliedAttachmentsConfiguration attachmentsConfiguration() {
        return attachmentsConfiguration;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q application was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q application was last updated.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * A description for the Amazon Q application.
     * </p>
     * 
     * @return A description for the Amazon Q application.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the Amazon Q application.
     * </p>
     * 
     * @return The name of the Amazon Q application.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services KMS key that is used to encrypt your data. Amazon Q doesn't support
     * asymmetric keys.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services KMS key that is used to encrypt your data. Amazon Q doesn't
     *         support asymmetric keys.
     */
    public final EncryptionConfiguration encryptionConfiguration() {
        return encryptionConfiguration;
    }

    /**
     * <p>
     * If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field contains a
     * description of the error that caused the synchronization to fail.
     * </p>
     * 
     * @return If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field
     *         contains a description of the error that caused the synchronization to fail.
     */
    public final ErrorDetail error() {
        return error;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM with permissions to access your CloudWatch logs and metrics.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM with permissions to access your CloudWatch logs and metrics.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the Amazon Q application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Q application.
     * @see ApplicationStatus
     */
    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon Q application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Q application.
     * @see ApplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Unix timestamp when the Amazon Q application was last updated.
     * </p>
     * 
     * @return The Unix timestamp when the Amazon Q application was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationResponse)) {
            return false;
        }
        GetApplicationResponse other = (GetApplicationResponse) obj;
        return Objects.equals(applicationArn(), other.applicationArn()) && Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(attachmentsConfiguration(), other.attachmentsConfiguration())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(encryptionConfiguration(), other.encryptionConfiguration())
                && Objects.equals(error(), other.error()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetApplicationResponse").add("ApplicationArn", applicationArn())
                .add("ApplicationId", applicationId()).add("AttachmentsConfiguration", attachmentsConfiguration())
                .add("CreatedAt", createdAt()).add("Description", description()).add("DisplayName", displayName())
                .add("EncryptionConfiguration", encryptionConfiguration()).add("Error", error()).add("RoleArn", roleArn())
                .add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "attachmentsConfiguration":
            return Optional.ofNullable(clazz.cast(attachmentsConfiguration()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "encryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationResponse, T> g) {
        return obj -> g.apply((GetApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetApplicationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q application.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) of the Amazon Q application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The identifier of the Amazon Q application.
         * </p>
         * 
         * @param applicationId
         *        The identifier of the Amazon Q application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * Settings for whether end users can upload files directly during chat.
         * </p>
         * 
         * @param attachmentsConfiguration
         *        Settings for whether end users can upload files directly during chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentsConfiguration(AppliedAttachmentsConfiguration attachmentsConfiguration);

        /**
         * <p>
         * Settings for whether end users can upload files directly during chat.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppliedAttachmentsConfiguration.Builder}
         * avoiding the need to create one manually via {@link AppliedAttachmentsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppliedAttachmentsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #attachmentsConfiguration(AppliedAttachmentsConfiguration)}.
         * 
         * @param attachmentsConfiguration
         *        a consumer that will call methods on {@link AppliedAttachmentsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachmentsConfiguration(AppliedAttachmentsConfiguration)
         */
        default Builder attachmentsConfiguration(Consumer<AppliedAttachmentsConfiguration.Builder> attachmentsConfiguration) {
            return attachmentsConfiguration(AppliedAttachmentsConfiguration.builder().applyMutation(attachmentsConfiguration)
                    .build());
        }

        /**
         * <p>
         * The Unix timestamp when the Amazon Q application was last updated.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp when the Amazon Q application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * A description for the Amazon Q application.
         * </p>
         * 
         * @param description
         *        A description for the Amazon Q application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the Amazon Q application.
         * </p>
         * 
         * @param displayName
         *        The name of the Amazon Q application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The identifier of the Amazon Web Services KMS key that is used to encrypt your data. Amazon Q doesn't support
         * asymmetric keys.
         * </p>
         * 
         * @param encryptionConfiguration
         *        The identifier of the Amazon Web Services KMS key that is used to encrypt your data. Amazon Q doesn't
         *        support asymmetric keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration);

        /**
         * <p>
         * The identifier of the Amazon Web Services KMS key that is used to encrypt your data. Amazon Q doesn't support
         * asymmetric keys.
         * </p>
         * This is a convenience method that creates an instance of the {@link EncryptionConfiguration.Builder} avoiding
         * the need to create one manually via {@link EncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #encryptionConfiguration(EncryptionConfiguration)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on {@link EncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(EncryptionConfiguration)
         */
        default Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return encryptionConfiguration(EncryptionConfiguration.builder().applyMutation(encryptionConfiguration).build());
        }

        /**
         * <p>
         * If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field contains a
         * description of the error that caused the synchronization to fail.
         * </p>
         * 
         * @param error
         *        If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field
         *        contains a description of the error that caused the synchronization to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * If the <code>Status</code> field is set to <code>ERROR</code>, the <code>ErrorMessage</code> field contains a
         * description of the error that caused the synchronization to fail.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM with permissions to access your CloudWatch logs and metrics.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM with permissions to access your CloudWatch logs and metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the Amazon Q application.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Q application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon Q application.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Q application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(ApplicationStatus status);

        /**
         * <p>
         * The Unix timestamp when the Amazon Q application was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp when the Amazon Q application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String applicationArn;

        private String applicationId;

        private AppliedAttachmentsConfiguration attachmentsConfiguration;

        private Instant createdAt;

        private String description;

        private String displayName;

        private EncryptionConfiguration encryptionConfiguration;

        private ErrorDetail error;

        private String roleArn;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationResponse model) {
            super(model);
            applicationArn(model.applicationArn);
            applicationId(model.applicationId);
            attachmentsConfiguration(model.attachmentsConfiguration);
            createdAt(model.createdAt);
            description(model.description);
            displayName(model.displayName);
            encryptionConfiguration(model.encryptionConfiguration);
            error(model.error);
            roleArn(model.roleArn);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final AppliedAttachmentsConfiguration.Builder getAttachmentsConfiguration() {
            return attachmentsConfiguration != null ? attachmentsConfiguration.toBuilder() : null;
        }

        public final void setAttachmentsConfiguration(AppliedAttachmentsConfiguration.BuilderImpl attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration != null ? attachmentsConfiguration.build() : null;
        }

        @Override
        public final Builder attachmentsConfiguration(AppliedAttachmentsConfiguration attachmentsConfiguration) {
            this.attachmentsConfiguration = attachmentsConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetApplicationResponse build() {
            return new GetApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
