/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWebExperiencesResponse extends QBusinessResponse implements
        ToCopyableBuilder<ListWebExperiencesResponse.Builder, ListWebExperiencesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWebExperiencesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<WebExperience>> WEB_EXPERIENCES_FIELD = SdkField
            .<List<WebExperience>> builder(MarshallingType.LIST)
            .memberName("webExperiences")
            .getter(getter(ListWebExperiencesResponse::webExperiences))
            .setter(setter(Builder::webExperiences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webExperiences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WebExperience> builder(MarshallingType.SDK_POJO)
                                            .constructor(WebExperience::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WEB_EXPERIENCES_FIELD));

    private final String nextToken;

    private final List<WebExperience> webExperiences;

    private ListWebExperiencesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.webExperiences = builder.webExperiences;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Q returns this token, which you can use in a later request to list the next
     * set of messages.
     * </p>
     * 
     * @return If the response is truncated, Amazon Q returns this token, which you can use in a later request to list
     *         the next set of messages.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WebExperiences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWebExperiences() {
        return webExperiences != null && !(webExperiences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of summary information for one or more Amazon Q experiences.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWebExperiences} method.
     * </p>
     * 
     * @return An array of summary information for one or more Amazon Q experiences.
     */
    public final List<WebExperience> webExperiences() {
        return webExperiences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWebExperiences() ? webExperiences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebExperiencesResponse)) {
            return false;
        }
        ListWebExperiencesResponse other = (ListWebExperiencesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWebExperiences() == other.hasWebExperiences()
                && Objects.equals(webExperiences(), other.webExperiences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWebExperiencesResponse").add("NextToken", nextToken())
                .add("WebExperiences", hasWebExperiences() ? webExperiences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "webExperiences":
            return Optional.ofNullable(clazz.cast(webExperiences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWebExperiencesResponse, T> g) {
        return obj -> g.apply((ListWebExperiencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWebExperiencesResponse> {
        /**
         * <p>
         * If the response is truncated, Amazon Q returns this token, which you can use in a later request to list the
         * next set of messages.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Q returns this token, which you can use in a later request to
         *        list the next set of messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of summary information for one or more Amazon Q experiences.
         * </p>
         * 
         * @param webExperiences
         *        An array of summary information for one or more Amazon Q experiences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webExperiences(Collection<WebExperience> webExperiences);

        /**
         * <p>
         * An array of summary information for one or more Amazon Q experiences.
         * </p>
         * 
         * @param webExperiences
         *        An array of summary information for one or more Amazon Q experiences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webExperiences(WebExperience... webExperiences);

        /**
         * <p>
         * An array of summary information for one or more Amazon Q experiences.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qbusiness.model.WebExperience.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qbusiness.model.WebExperience#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qbusiness.model.WebExperience.Builder#build()} is called immediately
         * and its result is passed to {@link #webExperiences(List<WebExperience>)}.
         * 
         * @param webExperiences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qbusiness.model.WebExperience.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webExperiences(java.util.Collection<WebExperience>)
         */
        Builder webExperiences(Consumer<WebExperience.Builder>... webExperiences);
    }

    static final class BuilderImpl extends QBusinessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<WebExperience> webExperiences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebExperiencesResponse model) {
            super(model);
            nextToken(model.nextToken);
            webExperiences(model.webExperiences);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WebExperience.Builder> getWebExperiences() {
            List<WebExperience.Builder> result = WebExperiencesCopier.copyToBuilder(this.webExperiences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebExperiences(Collection<WebExperience.BuilderImpl> webExperiences) {
            this.webExperiences = WebExperiencesCopier.copyFromBuilder(webExperiences);
        }

        @Override
        public final Builder webExperiences(Collection<WebExperience> webExperiences) {
            this.webExperiences = WebExperiencesCopier.copy(webExperiences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webExperiences(WebExperience... webExperiences) {
            webExperiences(Arrays.asList(webExperiences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webExperiences(Consumer<WebExperience.Builder>... webExperiences) {
            webExperiences(Stream.of(webExperiences).map(c -> WebExperience.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWebExperiencesResponse build() {
            return new ListWebExperiencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
