/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qbusiness.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRetrieverRequest extends QBusinessRequest implements
        ToCopyableBuilder<UpdateRetrieverRequest.Builder, UpdateRetrieverRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(UpdateRetrieverRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<RetrieverConfiguration> CONFIGURATION_FIELD = SdkField
            .<RetrieverConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateRetrieverRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(RetrieverConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateRetrieverRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> RETRIEVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retrieverId").getter(getter(UpdateRetrieverRequest::retrieverId)).setter(setter(Builder::retrieverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("retrieverId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdateRetrieverRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            CONFIGURATION_FIELD, DISPLAY_NAME_FIELD, RETRIEVER_ID_FIELD, ROLE_ARN_FIELD));

    private final String applicationId;

    private final RetrieverConfiguration configuration;

    private final String displayName;

    private final String retrieverId;

    private final String roleArn;

    private UpdateRetrieverRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.configuration = builder.configuration;
        this.displayName = builder.displayName;
        this.retrieverId = builder.retrieverId;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The identifier of your Amazon Q application.
     * </p>
     * 
     * @return The identifier of your Amazon Q application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * Returns the value of the Configuration property for this object.
     * 
     * @return The value of the Configuration property for this object.
     */
    public final RetrieverConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The name of your retriever.
     * </p>
     * 
     * @return The name of your retriever.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The identifier of your retriever.
     * </p>
     * 
     * @return The identifier of your retriever.
     */
    public final String retrieverId() {
        return retrieverId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role with permission to access the retriever and required resources.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role with permission to access the retriever and required
     *         resources.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(retrieverId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRetrieverRequest)) {
            return false;
        }
        UpdateRetrieverRequest other = (UpdateRetrieverRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(retrieverId(), other.retrieverId())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRetrieverRequest").add("ApplicationId", applicationId())
                .add("Configuration", configuration()).add("DisplayName", displayName()).add("RetrieverId", retrieverId())
                .add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "retrieverId":
            return Optional.ofNullable(clazz.cast(retrieverId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRetrieverRequest, T> g) {
        return obj -> g.apply((UpdateRetrieverRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QBusinessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRetrieverRequest> {
        /**
         * <p>
         * The identifier of your Amazon Q application.
         * </p>
         * 
         * @param applicationId
         *        The identifier of your Amazon Q application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * Sets the value of the Configuration property for this object.
         *
         * @param configuration
         *        The new value for the Configuration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(RetrieverConfiguration configuration);

        /**
         * Sets the value of the Configuration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RetrieverConfiguration.Builder} avoiding
         * the need to create one manually via {@link RetrieverConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrieverConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(RetrieverConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link RetrieverConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(RetrieverConfiguration)
         */
        default Builder configuration(Consumer<RetrieverConfiguration.Builder> configuration) {
            return configuration(RetrieverConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The name of your retriever.
         * </p>
         * 
         * @param displayName
         *        The name of your retriever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The identifier of your retriever.
         * </p>
         * 
         * @param retrieverId
         *        The identifier of your retriever.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieverId(String retrieverId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role with permission to access the retriever and required resources.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role with permission to access the retriever and required
         *        resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QBusinessRequest.BuilderImpl implements Builder {
        private String applicationId;

        private RetrieverConfiguration configuration;

        private String displayName;

        private String retrieverId;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRetrieverRequest model) {
            super(model);
            applicationId(model.applicationId);
            configuration(model.configuration);
            displayName(model.displayName);
            retrieverId(model.retrieverId);
            roleArn(model.roleArn);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final RetrieverConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(RetrieverConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RetrieverConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getRetrieverId() {
            return retrieverId;
        }

        public final void setRetrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
        }

        @Override
        public final Builder retrieverId(String retrieverId) {
            this.retrieverId = retrieverId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRetrieverRequest build() {
            return new UpdateRetrieverRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
