/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssistantAssociationsResponse extends QConnectResponse implements
        ToCopyableBuilder<ListAssistantAssociationsResponse.Builder, ListAssistantAssociationsResponse> {
    private static final SdkField<List<AssistantAssociationSummary>> ASSISTANT_ASSOCIATION_SUMMARIES_FIELD = SdkField
            .<List<AssistantAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("assistantAssociationSummaries")
            .getter(getter(ListAssistantAssociationsResponse::assistantAssociationSummaries))
            .setter(setter(Builder::assistantAssociationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantAssociationSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssistantAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssistantAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAssistantAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSISTANT_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<AssistantAssociationSummary> assistantAssociationSummaries;

    private final String nextToken;

    private ListAssistantAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.assistantAssociationSummaries = builder.assistantAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssistantAssociationSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssistantAssociationSummaries() {
        return assistantAssociationSummaries != null && !(assistantAssociationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about assistant associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssistantAssociationSummaries} method.
     * </p>
     * 
     * @return Summary information about assistant associations.
     */
    public final List<AssistantAssociationSummary> assistantAssociationSummaries() {
        return assistantAssociationSummaries;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssistantAssociationSummaries() ? assistantAssociationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssistantAssociationsResponse)) {
            return false;
        }
        ListAssistantAssociationsResponse other = (ListAssistantAssociationsResponse) obj;
        return hasAssistantAssociationSummaries() == other.hasAssistantAssociationSummaries()
                && Objects.equals(assistantAssociationSummaries(), other.assistantAssociationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListAssistantAssociationsResponse")
                .add("AssistantAssociationSummaries", hasAssistantAssociationSummaries() ? assistantAssociationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantAssociationSummaries":
            return Optional.ofNullable(clazz.cast(assistantAssociationSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAssistantAssociationsResponse, T> g) {
        return obj -> g.apply((ListAssistantAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAssistantAssociationsResponse> {
        /**
         * <p>
         * Summary information about assistant associations.
         * </p>
         * 
         * @param assistantAssociationSummaries
         *        Summary information about assistant associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantAssociationSummaries(Collection<AssistantAssociationSummary> assistantAssociationSummaries);

        /**
         * <p>
         * Summary information about assistant associations.
         * </p>
         * 
         * @param assistantAssociationSummaries
         *        Summary information about assistant associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantAssociationSummaries(AssistantAssociationSummary... assistantAssociationSummaries);

        /**
         * <p>
         * Summary information about assistant associations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.AssistantAssociationSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.AssistantAssociationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.AssistantAssociationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #assistantAssociationSummaries(List<AssistantAssociationSummary>)}.
         * 
         * @param assistantAssociationSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.AssistantAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assistantAssociationSummaries(java.util.Collection<AssistantAssociationSummary>)
         */
        Builder assistantAssociationSummaries(Consumer<AssistantAssociationSummary.Builder>... assistantAssociationSummaries);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private List<AssistantAssociationSummary> assistantAssociationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssistantAssociationsResponse model) {
            super(model);
            assistantAssociationSummaries(model.assistantAssociationSummaries);
            nextToken(model.nextToken);
        }

        public final List<AssistantAssociationSummary.Builder> getAssistantAssociationSummaries() {
            List<AssistantAssociationSummary.Builder> result = AssistantAssociationSummaryListCopier
                    .copyToBuilder(this.assistantAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssistantAssociationSummaries(
                Collection<AssistantAssociationSummary.BuilderImpl> assistantAssociationSummaries) {
            this.assistantAssociationSummaries = AssistantAssociationSummaryListCopier
                    .copyFromBuilder(assistantAssociationSummaries);
        }

        @Override
        public final Builder assistantAssociationSummaries(Collection<AssistantAssociationSummary> assistantAssociationSummaries) {
            this.assistantAssociationSummaries = AssistantAssociationSummaryListCopier.copy(assistantAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assistantAssociationSummaries(AssistantAssociationSummary... assistantAssociationSummaries) {
            assistantAssociationSummaries(Arrays.asList(assistantAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assistantAssociationSummaries(
                Consumer<AssistantAssociationSummary.Builder>... assistantAssociationSummaries) {
            assistantAssociationSummaries(Stream.of(assistantAssociationSummaries)
                    .map(c -> AssistantAssociationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssistantAssociationsResponse build() {
            return new ListAssistantAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
