/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.RankingData;
import software.amazon.awssdk.services.qconnect.model.SourceContentType;
import software.amazon.awssdk.services.qconnect.model.TextData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceContentDataDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceContentDataDetails> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(SourceContentDataDetails.getter(SourceContentDataDetails::id)).setter(SourceContentDataDetails.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<RankingData> RANKING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rankingData").getter(SourceContentDataDetails.getter(SourceContentDataDetails::rankingData)).setter(SourceContentDataDetails.setter(Builder::rankingData)).constructor(RankingData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rankingData").build()}).build();
    private static final SdkField<TextData> TEXT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("textData").getter(SourceContentDataDetails.getter(SourceContentDataDetails::textData)).setter(SourceContentDataDetails.setter(Builder::textData)).constructor(TextData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textData").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SourceContentDataDetails.getter(SourceContentDataDetails::typeAsString)).setter(SourceContentDataDetails.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RANKING_DATA_FIELD, TEXT_DATA_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final RankingData rankingData;
    private final TextData textData;
    private final String type;

    private SourceContentDataDetails(BuilderImpl builder) {
        this.id = builder.id;
        this.rankingData = builder.rankingData;
        this.textData = builder.textData;
        this.type = builder.type;
    }

    public final String id() {
        return this.id;
    }

    public final RankingData rankingData() {
        return this.rankingData;
    }

    public final TextData textData() {
        return this.textData;
    }

    public final SourceContentType type() {
        return SourceContentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.rankingData());
        hashCode = 31 * hashCode + Objects.hashCode(this.textData());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceContentDataDetails)) {
            return false;
        }
        SourceContentDataDetails other = (SourceContentDataDetails)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.rankingData(), other.rankingData()) && Objects.equals(this.textData(), other.textData()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SourceContentDataDetails").add("Id", (Object)this.id()).add("RankingData", (Object)this.rankingData()).add("TextData", (Object)this.textData()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "rankingData": {
                return Optional.ofNullable(clazz.cast(this.rankingData()));
            }
            case "textData": {
                return Optional.ofNullable(clazz.cast(this.textData()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceContentDataDetails, T> g) {
        return obj -> g.apply((SourceContentDataDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private RankingData rankingData;
        private TextData textData;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceContentDataDetails model) {
            this.id(model.id);
            this.rankingData(model.rankingData);
            this.textData(model.textData);
            this.type(model.type);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final RankingData.Builder getRankingData() {
            return this.rankingData != null ? this.rankingData.toBuilder() : null;
        }

        public final void setRankingData(RankingData.BuilderImpl rankingData) {
            this.rankingData = rankingData != null ? rankingData.build() : null;
        }

        @Override
        public final Builder rankingData(RankingData rankingData) {
            this.rankingData = rankingData;
            return this;
        }

        public final TextData.Builder getTextData() {
            return this.textData != null ? this.textData.toBuilder() : null;
        }

        public final void setTextData(TextData.BuilderImpl textData) {
            this.textData = textData != null ? textData.build() : null;
        }

        @Override
        public final Builder textData(TextData textData) {
            this.textData = textData;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceContentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public SourceContentDataDetails build() {
            return new SourceContentDataDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceContentDataDetails> {
        public Builder id(String var1);

        public Builder rankingData(RankingData var1);

        default public Builder rankingData(Consumer<RankingData.Builder> rankingData) {
            return this.rankingData((RankingData)((RankingData.Builder)RankingData.builder().applyMutation(rankingData)).build());
        }

        public Builder textData(TextData var1);

        default public Builder textData(Consumer<TextData.Builder> textData) {
            return this.textData((TextData)((TextData.Builder)TextData.builder().applyMutation(textData)).build());
        }

        public Builder type(String var1);

        public Builder type(SourceContentType var1);
    }
}

