/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImportJobsResponse extends QConnectResponse implements
        ToCopyableBuilder<ListImportJobsResponse.Builder, ListImportJobsResponse> {
    private static final SdkField<List<ImportJobSummary>> IMPORT_JOB_SUMMARIES_FIELD = SdkField
            .<List<ImportJobSummary>> builder(MarshallingType.LIST)
            .memberName("importJobSummaries")
            .getter(getter(ListImportJobsResponse::importJobSummaries))
            .setter(setter(Builder::importJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListImportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_JOB_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ImportJobSummary> importJobSummaries;

    private final String nextToken;

    private ListImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.importJobSummaries = builder.importJobSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportJobSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImportJobSummaries() {
        return importJobSummaries != null && !(importJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information about the import jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportJobSummaries} method.
     * </p>
     * 
     * @return Summary information about the import jobs.
     */
    public final List<ImportJobSummary> importJobSummaries() {
        return importJobSummaries;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImportJobSummaries() ? importJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportJobsResponse)) {
            return false;
        }
        ListImportJobsResponse other = (ListImportJobsResponse) obj;
        return hasImportJobSummaries() == other.hasImportJobSummaries()
                && Objects.equals(importJobSummaries(), other.importJobSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImportJobsResponse")
                .add("ImportJobSummaries", hasImportJobSummaries() ? importJobSummaries() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importJobSummaries":
            return Optional.ofNullable(clazz.cast(importJobSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImportJobsResponse, T> g) {
        return obj -> g.apply((ListImportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListImportJobsResponse> {
        /**
         * <p>
         * Summary information about the import jobs.
         * </p>
         * 
         * @param importJobSummaries
         *        Summary information about the import jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobSummaries(Collection<ImportJobSummary> importJobSummaries);

        /**
         * <p>
         * Summary information about the import jobs.
         * </p>
         * 
         * @param importJobSummaries
         *        Summary information about the import jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobSummaries(ImportJobSummary... importJobSummaries);

        /**
         * <p>
         * Summary information about the import jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.ImportJobSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qconnect.model.ImportJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.ImportJobSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #importJobSummaries(List<ImportJobSummary>)}.
         * 
         * @param importJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.ImportJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importJobSummaries(java.util.Collection<ImportJobSummary>)
         */
        Builder importJobSummaries(Consumer<ImportJobSummary.Builder>... importJobSummaries);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private List<ImportJobSummary> importJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportJobsResponse model) {
            super(model);
            importJobSummaries(model.importJobSummaries);
            nextToken(model.nextToken);
        }

        public final List<ImportJobSummary.Builder> getImportJobSummaries() {
            List<ImportJobSummary.Builder> result = ImportJobListCopier.copyToBuilder(this.importJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportJobSummaries(Collection<ImportJobSummary.BuilderImpl> importJobSummaries) {
            this.importJobSummaries = ImportJobListCopier.copyFromBuilder(importJobSummaries);
        }

        @Override
        public final Builder importJobSummaries(Collection<ImportJobSummary> importJobSummaries) {
            this.importJobSummaries = ImportJobListCopier.copy(importJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobSummaries(ImportJobSummary... importJobSummaries) {
            importJobSummaries(Arrays.asList(importJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importJobSummaries(Consumer<ImportJobSummary.Builder>... importJobSummaries) {
            importJobSummaries(Stream.of(importJobSummaries).map(c -> ImportJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImportJobsResponse build() {
            return new ListImportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
