/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A union type containing information related to the trigger.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationTriggerData implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationTriggerData.Builder, RecommendationTriggerData> {
    private static final SdkField<QueryRecommendationTriggerData> QUERY_FIELD = SdkField
            .<QueryRecommendationTriggerData> builder(MarshallingType.SDK_POJO).memberName("query")
            .getter(getter(RecommendationTriggerData::query)).setter(setter(Builder::query))
            .constructor(QueryRecommendationTriggerData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("query").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final QueryRecommendationTriggerData query;

    private final Type type;

    private RecommendationTriggerData(BuilderImpl builder) {
        this.query = builder.query;
        this.type = builder.type;
    }

    /**
     * <p>
     * Data associated with the QUERY RecommendationTriggerType.
     * </p>
     * 
     * @return Data associated with the QUERY RecommendationTriggerType.
     */
    public final QueryRecommendationTriggerData query() {
        return query;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(query());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationTriggerData)) {
            return false;
        }
        RecommendationTriggerData other = (RecommendationTriggerData) obj;
        return Objects.equals(query(), other.query());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationTriggerData").add("Query", query()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "query":
            return Optional.ofNullable(clazz.cast(query()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #query()} initialized to the given value.
     *
     * <p>
     * Data associated with the QUERY RecommendationTriggerType.
     * </p>
     * 
     * @param query
     *        Data associated with the QUERY RecommendationTriggerType.
     */
    public static RecommendationTriggerData fromQuery(QueryRecommendationTriggerData query) {
        return builder().query(query).build();
    }

    /**
     * Create an instance of this class with {@link #query()} initialized to the given value.
     *
     * <p>
     * Data associated with the QUERY RecommendationTriggerType.
     * </p>
     * 
     * @param query
     *        Data associated with the QUERY RecommendationTriggerType.
     */
    public static RecommendationTriggerData fromQuery(Consumer<QueryRecommendationTriggerData.Builder> query) {
        QueryRecommendationTriggerData.Builder builder = QueryRecommendationTriggerData.builder();
        query.accept(builder);
        return fromQuery(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationTriggerData, T> g) {
        return obj -> g.apply((RecommendationTriggerData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationTriggerData> {
        /**
         * <p>
         * Data associated with the QUERY RecommendationTriggerType.
         * </p>
         * 
         * @param query
         *        Data associated with the QUERY RecommendationTriggerType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder query(QueryRecommendationTriggerData query);

        /**
         * <p>
         * Data associated with the QUERY RecommendationTriggerType.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryRecommendationTriggerData.Builder}
         * avoiding the need to create one manually via {@link QueryRecommendationTriggerData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryRecommendationTriggerData.Builder#build()} is called
         * immediately and its result is passed to {@link #query(QueryRecommendationTriggerData)}.
         * 
         * @param query
         *        a consumer that will call methods on {@link QueryRecommendationTriggerData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #query(QueryRecommendationTriggerData)
         */
        default Builder query(Consumer<QueryRecommendationTriggerData.Builder> query) {
            return query(QueryRecommendationTriggerData.builder().applyMutation(query).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private QueryRecommendationTriggerData query;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationTriggerData model) {
            query(model.query);
        }

        public final QueryRecommendationTriggerData.Builder getQuery() {
            return query != null ? query.toBuilder() : null;
        }

        public final void setQuery(QueryRecommendationTriggerData.BuilderImpl query) {
            Object oldValue = this.query;
            this.query = query != null ? query.build() : null;
            handleUnionValueChange(Type.QUERY, oldValue, this.query);
        }

        @Override
        public final Builder query(QueryRecommendationTriggerData query) {
            Object oldValue = this.query;
            this.query = query;
            handleUnionValueChange(Type.QUERY, oldValue, this.query);
            return this;
        }

        @Override
        public RecommendationTriggerData build() {
            return new RecommendationTriggerData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RecommendationTriggerData#type()
     */
    public enum Type {
        QUERY,

        UNKNOWN_TO_SDK_VERSION
    }
}
