/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3ObjectEncryptionType {
    SSE_KMS("SSE_KMS"),
    SSE_S3("SSE_S3"),
    NO_ENCRYPTION("NO_ENCRYPTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3ObjectEncryptionType> VALUE_MAP;
    private final String value;

    private S3ObjectEncryptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3ObjectEncryptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3ObjectEncryptionType> knownValues() {
        EnumSet<S3ObjectEncryptionType> knownValues = EnumSet.allOf(S3ObjectEncryptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3ObjectEncryptionType.class, S3ObjectEncryptionType::toString);
    }
}

