/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBlueGreenDeploymentRequest extends RdsRequest implements
        ToCopyableBuilder<CreateBlueGreenDeploymentRequest.Builder, CreateBlueGreenDeploymentRequest> {
    private static final SdkField<String> BLUE_GREEN_DEPLOYMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BlueGreenDeploymentName").getter(getter(CreateBlueGreenDeploymentRequest::blueGreenDeploymentName))
            .setter(setter(Builder::blueGreenDeploymentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenDeploymentName").build())
            .build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(CreateBlueGreenDeploymentRequest::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> TARGET_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetEngineVersion").getter(getter(CreateBlueGreenDeploymentRequest::targetEngineVersion))
            .setter(setter(Builder::targetEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEngineVersion").build())
            .build();

    private static final SdkField<String> TARGET_DB_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetDBParameterGroupName")
            .getter(getter(CreateBlueGreenDeploymentRequest::targetDBParameterGroupName))
            .setter(setter(Builder::targetDBParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBParameterGroupName").build())
            .build();

    private static final SdkField<String> TARGET_DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetDBClusterParameterGroupName")
            .getter(getter(CreateBlueGreenDeploymentRequest::targetDBClusterParameterGroupName))
            .setter(setter(Builder::targetDBClusterParameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBClusterParameterGroupName")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateBlueGreenDeploymentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> TARGET_DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetDBInstanceClass").getter(getter(CreateBlueGreenDeploymentRequest::targetDBInstanceClass))
            .setter(setter(Builder::targetDBInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDBInstanceClass").build())
            .build();

    private static final SdkField<Boolean> UPGRADE_TARGET_STORAGE_CONFIG_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UpgradeTargetStorageConfig")
            .getter(getter(CreateBlueGreenDeploymentRequest::upgradeTargetStorageConfig))
            .setter(setter(Builder::upgradeTargetStorageConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeTargetStorageConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BLUE_GREEN_DEPLOYMENT_NAME_FIELD, SOURCE_FIELD, TARGET_ENGINE_VERSION_FIELD, TARGET_DB_PARAMETER_GROUP_NAME_FIELD,
            TARGET_DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, TAGS_FIELD, TARGET_DB_INSTANCE_CLASS_FIELD,
            UPGRADE_TARGET_STORAGE_CONFIG_FIELD));

    private final String blueGreenDeploymentName;

    private final String source;

    private final String targetEngineVersion;

    private final String targetDBParameterGroupName;

    private final String targetDBClusterParameterGroupName;

    private final List<Tag> tags;

    private final String targetDBInstanceClass;

    private final Boolean upgradeTargetStorageConfig;

    private CreateBlueGreenDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.blueGreenDeploymentName = builder.blueGreenDeploymentName;
        this.source = builder.source;
        this.targetEngineVersion = builder.targetEngineVersion;
        this.targetDBParameterGroupName = builder.targetDBParameterGroupName;
        this.targetDBClusterParameterGroupName = builder.targetDBClusterParameterGroupName;
        this.tags = builder.tags;
        this.targetDBInstanceClass = builder.targetDBInstanceClass;
        this.upgradeTargetStorageConfig = builder.upgradeTargetStorageConfig;
    }

    /**
     * <p>
     * The name of the blue/green deployment.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be the same as an existing blue/green deployment name in the same account and Amazon Web Services Region.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the blue/green deployment.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be the same as an existing blue/green deployment name in the same account and Amazon Web Services
     *         Region.
     *         </p>
     *         </li>
     */
    public final String blueGreenDeploymentName() {
        return blueGreenDeploymentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source production database.
     * </p>
     * <p>
     * Specify the database that you want to clone. The blue/green deployment creates this database in the green
     * environment. You can make updates to the database in the green environment, such as an engine version upgrade.
     * When you are ready, you can switch the database in the green environment to be the production database.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source production database.</p>
     *         <p>
     *         Specify the database that you want to clone. The blue/green deployment creates this database in the green
     *         environment. You can make updates to the database in the green environment, such as an engine version
     *         upgrade. When you are ready, you can switch the database in the green environment to be the production
     *         database.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The engine version of the database in the green environment.
     * </p>
     * <p>
     * Specify the engine version to upgrade to in the green environment.
     * </p>
     * 
     * @return The engine version of the database in the green environment.</p>
     *         <p>
     *         Specify the engine version to upgrade to in the green environment.
     */
    public final String targetEngineVersion() {
        return targetEngineVersion;
    }

    /**
     * <p>
     * The DB parameter group associated with the DB instance in the green environment.
     * </p>
     * <p>
     * To test parameter changes, specify a DB parameter group that is different from the one associated with the source
     * DB instance.
     * </p>
     * 
     * @return The DB parameter group associated with the DB instance in the green environment.</p>
     *         <p>
     *         To test parameter changes, specify a DB parameter group that is different from the one associated with
     *         the source DB instance.
     */
    public final String targetDBParameterGroupName() {
        return targetDBParameterGroupName;
    }

    /**
     * <p>
     * The DB cluster parameter group associated with the Aurora DB cluster in the green environment.
     * </p>
     * <p>
     * To test parameter changes, specify a DB cluster parameter group that is different from the one associated with
     * the source DB cluster.
     * </p>
     * 
     * @return The DB cluster parameter group associated with the Aurora DB cluster in the green environment.</p>
     *         <p>
     *         To test parameter changes, specify a DB cluster parameter group that is different from the one associated
     *         with the source DB cluster.
     */
    public final String targetDBClusterParameterGroupName() {
        return targetDBClusterParameterGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to assign to the blue/green deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to assign to the blue/green deployment.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specify the DB instance class for the databases in the green environment.
     * </p>
     * 
     * @return Specify the DB instance class for the databases in the green environment.
     */
    public final String targetDBInstanceClass() {
        return targetDBInstanceClass;
    }

    /**
     * <p>
     * Whether to upgrade the storage file system configuration on the green database. This option migrates the green DB
     * instance from the older 32-bit file system to the preferred configuration. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.UpgradeFileSystem"
     * >Upgrading the storage file system for a DB instance</a>.
     * </p>
     * 
     * @return Whether to upgrade the storage file system configuration on the green database. This option migrates the
     *         green DB instance from the older 32-bit file system to the preferred configuration. For more information,
     *         see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.UpgradeFileSystem"
     *         >Upgrading the storage file system for a DB instance</a>.
     */
    public final Boolean upgradeTargetStorageConfig() {
        return upgradeTargetStorageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenDeploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(targetEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(targetDBParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(targetDBClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetDBInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(upgradeTargetStorageConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBlueGreenDeploymentRequest)) {
            return false;
        }
        CreateBlueGreenDeploymentRequest other = (CreateBlueGreenDeploymentRequest) obj;
        return Objects.equals(blueGreenDeploymentName(), other.blueGreenDeploymentName())
                && Objects.equals(source(), other.source()) && Objects.equals(targetEngineVersion(), other.targetEngineVersion())
                && Objects.equals(targetDBParameterGroupName(), other.targetDBParameterGroupName())
                && Objects.equals(targetDBClusterParameterGroupName(), other.targetDBClusterParameterGroupName())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(targetDBInstanceClass(), other.targetDBInstanceClass())
                && Objects.equals(upgradeTargetStorageConfig(), other.upgradeTargetStorageConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBlueGreenDeploymentRequest").add("BlueGreenDeploymentName", blueGreenDeploymentName())
                .add("Source", source()).add("TargetEngineVersion", targetEngineVersion())
                .add("TargetDBParameterGroupName", targetDBParameterGroupName())
                .add("TargetDBClusterParameterGroupName", targetDBClusterParameterGroupName())
                .add("Tags", hasTags() ? tags() : null).add("TargetDBInstanceClass", targetDBInstanceClass())
                .add("UpgradeTargetStorageConfig", upgradeTargetStorageConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueGreenDeploymentName":
            return Optional.ofNullable(clazz.cast(blueGreenDeploymentName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "TargetEngineVersion":
            return Optional.ofNullable(clazz.cast(targetEngineVersion()));
        case "TargetDBParameterGroupName":
            return Optional.ofNullable(clazz.cast(targetDBParameterGroupName()));
        case "TargetDBClusterParameterGroupName":
            return Optional.ofNullable(clazz.cast(targetDBClusterParameterGroupName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TargetDBInstanceClass":
            return Optional.ofNullable(clazz.cast(targetDBInstanceClass()));
        case "UpgradeTargetStorageConfig":
            return Optional.ofNullable(clazz.cast(upgradeTargetStorageConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBlueGreenDeploymentRequest, T> g) {
        return obj -> g.apply((CreateBlueGreenDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBlueGreenDeploymentRequest> {
        /**
         * <p>
         * The name of the blue/green deployment.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be the same as an existing blue/green deployment name in the same account and Amazon Web Services
         * Region.
         * </p>
         * </li>
         * </ul>
         * 
         * @param blueGreenDeploymentName
         *        The name of the blue/green deployment.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be the same as an existing blue/green deployment name in the same account and Amazon Web
         *        Services Region.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenDeploymentName(String blueGreenDeploymentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source production database.
         * </p>
         * <p>
         * Specify the database that you want to clone. The blue/green deployment creates this database in the green
         * environment. You can make updates to the database in the green environment, such as an engine version
         * upgrade. When you are ready, you can switch the database in the green environment to be the production
         * database.
         * </p>
         * 
         * @param source
         *        The Amazon Resource Name (ARN) of the source production database.</p>
         *        <p>
         *        Specify the database that you want to clone. The blue/green deployment creates this database in the
         *        green environment. You can make updates to the database in the green environment, such as an engine
         *        version upgrade. When you are ready, you can switch the database in the green environment to be the
         *        production database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The engine version of the database in the green environment.
         * </p>
         * <p>
         * Specify the engine version to upgrade to in the green environment.
         * </p>
         * 
         * @param targetEngineVersion
         *        The engine version of the database in the green environment.</p>
         *        <p>
         *        Specify the engine version to upgrade to in the green environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEngineVersion(String targetEngineVersion);

        /**
         * <p>
         * The DB parameter group associated with the DB instance in the green environment.
         * </p>
         * <p>
         * To test parameter changes, specify a DB parameter group that is different from the one associated with the
         * source DB instance.
         * </p>
         * 
         * @param targetDBParameterGroupName
         *        The DB parameter group associated with the DB instance in the green environment.</p>
         *        <p>
         *        To test parameter changes, specify a DB parameter group that is different from the one associated with
         *        the source DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDBParameterGroupName(String targetDBParameterGroupName);

        /**
         * <p>
         * The DB cluster parameter group associated with the Aurora DB cluster in the green environment.
         * </p>
         * <p>
         * To test parameter changes, specify a DB cluster parameter group that is different from the one associated
         * with the source DB cluster.
         * </p>
         * 
         * @param targetDBClusterParameterGroupName
         *        The DB cluster parameter group associated with the Aurora DB cluster in the green environment.</p>
         *        <p>
         *        To test parameter changes, specify a DB cluster parameter group that is different from the one
         *        associated with the source DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDBClusterParameterGroupName(String targetDBClusterParameterGroupName);

        /**
         * <p>
         * Tags to assign to the blue/green deployment.
         * </p>
         * 
         * @param tags
         *        Tags to assign to the blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to assign to the blue/green deployment.
         * </p>
         * 
         * @param tags
         *        Tags to assign to the blue/green deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to assign to the blue/green deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specify the DB instance class for the databases in the green environment.
         * </p>
         * 
         * @param targetDBInstanceClass
         *        Specify the DB instance class for the databases in the green environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDBInstanceClass(String targetDBInstanceClass);

        /**
         * <p>
         * Whether to upgrade the storage file system configuration on the green database. This option migrates the
         * green DB instance from the older 32-bit file system to the preferred configuration. For more information, see
         * <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.UpgradeFileSystem"
         * >Upgrading the storage file system for a DB instance</a>.
         * </p>
         * 
         * @param upgradeTargetStorageConfig
         *        Whether to upgrade the storage file system configuration on the green database. This option migrates
         *        the green DB instance from the older 32-bit file system to the preferred configuration. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.UpgradeFileSystem"
         *        >Upgrading the storage file system for a DB instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upgradeTargetStorageConfig(Boolean upgradeTargetStorageConfig);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String blueGreenDeploymentName;

        private String source;

        private String targetEngineVersion;

        private String targetDBParameterGroupName;

        private String targetDBClusterParameterGroupName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String targetDBInstanceClass;

        private Boolean upgradeTargetStorageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBlueGreenDeploymentRequest model) {
            super(model);
            blueGreenDeploymentName(model.blueGreenDeploymentName);
            source(model.source);
            targetEngineVersion(model.targetEngineVersion);
            targetDBParameterGroupName(model.targetDBParameterGroupName);
            targetDBClusterParameterGroupName(model.targetDBClusterParameterGroupName);
            tags(model.tags);
            targetDBInstanceClass(model.targetDBInstanceClass);
            upgradeTargetStorageConfig(model.upgradeTargetStorageConfig);
        }

        public final String getBlueGreenDeploymentName() {
            return blueGreenDeploymentName;
        }

        public final void setBlueGreenDeploymentName(String blueGreenDeploymentName) {
            this.blueGreenDeploymentName = blueGreenDeploymentName;
        }

        @Override
        public final Builder blueGreenDeploymentName(String blueGreenDeploymentName) {
            this.blueGreenDeploymentName = blueGreenDeploymentName;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTargetEngineVersion() {
            return targetEngineVersion;
        }

        public final void setTargetEngineVersion(String targetEngineVersion) {
            this.targetEngineVersion = targetEngineVersion;
        }

        @Override
        public final Builder targetEngineVersion(String targetEngineVersion) {
            this.targetEngineVersion = targetEngineVersion;
            return this;
        }

        public final String getTargetDBParameterGroupName() {
            return targetDBParameterGroupName;
        }

        public final void setTargetDBParameterGroupName(String targetDBParameterGroupName) {
            this.targetDBParameterGroupName = targetDBParameterGroupName;
        }

        @Override
        public final Builder targetDBParameterGroupName(String targetDBParameterGroupName) {
            this.targetDBParameterGroupName = targetDBParameterGroupName;
            return this;
        }

        public final String getTargetDBClusterParameterGroupName() {
            return targetDBClusterParameterGroupName;
        }

        public final void setTargetDBClusterParameterGroupName(String targetDBClusterParameterGroupName) {
            this.targetDBClusterParameterGroupName = targetDBClusterParameterGroupName;
        }

        @Override
        public final Builder targetDBClusterParameterGroupName(String targetDBClusterParameterGroupName) {
            this.targetDBClusterParameterGroupName = targetDBClusterParameterGroupName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTargetDBInstanceClass() {
            return targetDBInstanceClass;
        }

        public final void setTargetDBInstanceClass(String targetDBInstanceClass) {
            this.targetDBInstanceClass = targetDBInstanceClass;
        }

        @Override
        public final Builder targetDBInstanceClass(String targetDBInstanceClass) {
            this.targetDBInstanceClass = targetDBInstanceClass;
            return this;
        }

        public final Boolean getUpgradeTargetStorageConfig() {
            return upgradeTargetStorageConfig;
        }

        public final void setUpgradeTargetStorageConfig(Boolean upgradeTargetStorageConfig) {
            this.upgradeTargetStorageConfig = upgradeTargetStorageConfig;
        }

        @Override
        public final Builder upgradeTargetStorageConfig(Boolean upgradeTargetStorageConfig) {
            this.upgradeTargetStorageConfig = upgradeTargetStorageConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBlueGreenDeploymentRequest build() {
            return new CreateBlueGreenDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
