/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDbSecurityGroupResponse extends RdsResponse implements
        ToCopyableBuilder<CreateDbSecurityGroupResponse.Builder, CreateDbSecurityGroupResponse> {
    private static final SdkField<DBSecurityGroup> DB_SECURITY_GROUP_FIELD = SdkField
            .<DBSecurityGroup> builder(MarshallingType.SDK_POJO).memberName("DBSecurityGroup")
            .getter(getter(CreateDbSecurityGroupResponse::dbSecurityGroup)).setter(setter(Builder::dbSecurityGroup))
            .constructor(DBSecurityGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SECURITY_GROUP_FIELD));

    private final DBSecurityGroup dbSecurityGroup;

    private CreateDbSecurityGroupResponse(BuilderImpl builder) {
        super(builder);
        this.dbSecurityGroup = builder.dbSecurityGroup;
    }

    /**
     * Returns the value of the DBSecurityGroup property for this object.
     * 
     * @return The value of the DBSecurityGroup property for this object.
     */
    public final DBSecurityGroup dbSecurityGroup() {
        return dbSecurityGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbSecurityGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbSecurityGroupResponse)) {
            return false;
        }
        CreateDbSecurityGroupResponse other = (CreateDbSecurityGroupResponse) obj;
        return Objects.equals(dbSecurityGroup(), other.dbSecurityGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDbSecurityGroupResponse").add("DBSecurityGroup", dbSecurityGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSecurityGroup":
            return Optional.ofNullable(clazz.cast(dbSecurityGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbSecurityGroupResponse, T> g) {
        return obj -> g.apply((CreateDbSecurityGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDbSecurityGroupResponse> {
        /**
         * Sets the value of the DBSecurityGroup property for this object.
         *
         * @param dbSecurityGroup
         *        The new value for the DBSecurityGroup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroup(DBSecurityGroup dbSecurityGroup);

        /**
         * Sets the value of the DBSecurityGroup property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DBSecurityGroup.Builder} avoiding the
         * need to create one manually via {@link DBSecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DBSecurityGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #dbSecurityGroup(DBSecurityGroup)}.
         * 
         * @param dbSecurityGroup
         *        a consumer that will call methods on {@link DBSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSecurityGroup(DBSecurityGroup)
         */
        default Builder dbSecurityGroup(Consumer<DBSecurityGroup.Builder> dbSecurityGroup) {
            return dbSecurityGroup(DBSecurityGroup.builder().applyMutation(dbSecurityGroup).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private DBSecurityGroup dbSecurityGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbSecurityGroupResponse model) {
            super(model);
            dbSecurityGroup(model.dbSecurityGroup);
        }

        public final DBSecurityGroup.Builder getDbSecurityGroup() {
            return dbSecurityGroup != null ? dbSecurityGroup.toBuilder() : null;
        }

        public final void setDbSecurityGroup(DBSecurityGroup.BuilderImpl dbSecurityGroup) {
            this.dbSecurityGroup = dbSecurityGroup != null ? dbSecurityGroup.build() : null;
        }

        @Override
        public final Builder dbSecurityGroup(DBSecurityGroup dbSecurityGroup) {
            this.dbSecurityGroup = dbSecurityGroup;
            return this;
        }

        @Override
        public CreateDbSecurityGroupResponse build() {
            return new CreateDbSecurityGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
