/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the scaling configuration of an Aurora Serverless v1 DB cluster.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora
 * Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ScalingConfiguration.Builder, ScalingConfiguration> {
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinCapacity").getter(getter(ScalingConfiguration::minCapacity)).setter(setter(Builder::minCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCapacity").getter(getter(ScalingConfiguration::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<Boolean> AUTO_PAUSE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoPause").getter(getter(ScalingConfiguration::autoPause)).setter(setter(Builder::autoPause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPause").build()).build();

    private static final SdkField<Integer> SECONDS_UNTIL_AUTO_PAUSE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondsUntilAutoPause").getter(getter(ScalingConfiguration::secondsUntilAutoPause))
            .setter(setter(Builder::secondsUntilAutoPause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsUntilAutoPause").build())
            .build();

    private static final SdkField<String> TIMEOUT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeoutAction").getter(getter(ScalingConfiguration::timeoutAction))
            .setter(setter(Builder::timeoutAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutAction").build()).build();

    private static final SdkField<Integer> SECONDS_BEFORE_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondsBeforeTimeout").getter(getter(ScalingConfiguration::secondsBeforeTimeout))
            .setter(setter(Builder::secondsBeforeTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsBeforeTimeout").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD,
            MAX_CAPACITY_FIELD, AUTO_PAUSE_FIELD, SECONDS_UNTIL_AUTO_PAUSE_FIELD, TIMEOUT_ACTION_FIELD,
            SECONDS_BEFORE_TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer minCapacity;

    private final Integer maxCapacity;

    private final Boolean autoPause;

    private final Integer secondsUntilAutoPause;

    private final String timeoutAction;

    private final Integer secondsBeforeTimeout;

    private ScalingConfiguration(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.autoPause = builder.autoPause;
        this.secondsUntilAutoPause = builder.secondsUntilAutoPause;
        this.timeoutAction = builder.timeoutAction;
        this.secondsBeforeTimeout = builder.secondsBeforeTimeout;
    }

    /**
     * <p>
     * The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
     * </p>
     * <p>
     * For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>,
     * <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.
     * </p>
     * <p>
     * For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>,
     * <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
     * </p>
     * <p>
     * The minimum capacity must be less than or equal to the maximum capacity.
     * </p>
     * 
     * @return The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
     *         <p>
     *         For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>,
     *         <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>
     *         .
     *         </p>
     *         <p>
     *         For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
     *         <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
     *         </p>
     *         <p>
     *         The minimum capacity must be less than or equal to the maximum capacity.
     */
    public final Integer minCapacity() {
        return minCapacity;
    }

    /**
     * <p>
     * The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
     * </p>
     * <p>
     * For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>,
     * <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.
     * </p>
     * <p>
     * For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>,
     * <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
     * </p>
     * <p>
     * The maximum capacity must be greater than or equal to the minimum capacity.
     * </p>
     * 
     * @return The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
     *         <p>
     *         For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>,
     *         <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>
     *         .
     *         </p>
     *         <p>
     *         For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
     *         <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
     *         </p>
     *         <p>
     *         The maximum capacity must be greater than or equal to the minimum capacity.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in <code>serverless</code> DB
     * engine mode. A DB cluster can be paused only when it's idle (it has no connections).
     * </p>
     * <note>
     * <p>
     * If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this
     * case, the DB cluster is restored when there is a request to connect to it.
     * </p>
     * </note>
     * 
     * @return Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in
     *         <code>serverless</code> DB engine mode. A DB cluster can be paused only when it's idle (it has no
     *         connections).</p> <note>
     *         <p>
     *         If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In
     *         this case, the DB cluster is restored when there is a request to connect to it.
     *         </p>
     */
    public final Boolean autoPause() {
        return autoPause;
    }

    /**
     * <p>
     * The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.
     * </p>
     * <p>
     * Specify a value between 300 and 86,400 seconds.
     * </p>
     * 
     * @return The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.</p>
     *         <p>
     *         Specify a value between 300 and 86,400 seconds.
     */
    public final Integer secondsUntilAutoPause() {
        return secondsUntilAutoPause;
    }

    /**
     * <p>
     * The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
     * <code>RollbackCapacityChange</code>.
     * </p>
     * <p>
     * <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.
     * </p>
     * <p>
     * <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't found in
     * the timeout period.
     * </p>
     * <important>
     * <p>
     * If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless v1 from finding
     * a scaling point might be dropped.
     * </p>
     * </important>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
     * > Autoscaling for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * 
     * @return The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
     *         <code>RollbackCapacityChange</code>.</p>
     *         <p>
     *         <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.
     *         </p>
     *         <p>
     *         <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't
     *         found in the timeout period.
     *         </p>
     *         <important>
     *         <p>
     *         If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless v1 from
     *         finding a scaling point might be dropped.
     *         </p>
     *         </important>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
     *         > Autoscaling for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     */
    public final String timeoutAction() {
        return timeoutAction;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless
     * scaling before enforcing the timeout action. The default is 300.
     * </p>
     * <p>
     * Specify a value between 60 and 600 seconds.
     * </p>
     * 
     * @return The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform
     *         seamless scaling before enforcing the timeout action. The default is 300.</p>
     *         <p>
     *         Specify a value between 60 and 600 seconds.
     */
    public final Integer secondsBeforeTimeout() {
        return secondsBeforeTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(autoPause());
        hashCode = 31 * hashCode + Objects.hashCode(secondsUntilAutoPause());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutAction());
        hashCode = 31 * hashCode + Objects.hashCode(secondsBeforeTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfiguration)) {
            return false;
        }
        ScalingConfiguration other = (ScalingConfiguration) obj;
        return Objects.equals(minCapacity(), other.minCapacity()) && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(autoPause(), other.autoPause())
                && Objects.equals(secondsUntilAutoPause(), other.secondsUntilAutoPause())
                && Objects.equals(timeoutAction(), other.timeoutAction())
                && Objects.equals(secondsBeforeTimeout(), other.secondsBeforeTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingConfiguration").add("MinCapacity", minCapacity()).add("MaxCapacity", maxCapacity())
                .add("AutoPause", autoPause()).add("SecondsUntilAutoPause", secondsUntilAutoPause())
                .add("TimeoutAction", timeoutAction()).add("SecondsBeforeTimeout", secondsBeforeTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinCapacity":
            return Optional.ofNullable(clazz.cast(minCapacity()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "AutoPause":
            return Optional.ofNullable(clazz.cast(autoPause()));
        case "SecondsUntilAutoPause":
            return Optional.ofNullable(clazz.cast(secondsUntilAutoPause()));
        case "TimeoutAction":
            return Optional.ofNullable(clazz.cast(timeoutAction()));
        case "SecondsBeforeTimeout":
            return Optional.ofNullable(clazz.cast(secondsBeforeTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingConfiguration, T> g) {
        return obj -> g.apply((ScalingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingConfiguration> {
        /**
         * <p>
         * The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
         * </p>
         * <p>
         * For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>,
         * <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.
         * </p>
         * <p>
         * For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
         * <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
         * </p>
         * <p>
         * The minimum capacity must be less than or equal to the maximum capacity.
         * </p>
         * 
         * @param minCapacity
         *        The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
         *        <p>
         *        For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>,
         *        <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and
         *        <code>256</code>.
         *        </p>
         *        <p>
         *        For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
         *        <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
         *        </p>
         *        <p>
         *        The minimum capacity must be less than or equal to the maximum capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacity(Integer minCapacity);

        /**
         * <p>
         * The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.
         * </p>
         * <p>
         * For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>,
         * <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.
         * </p>
         * <p>
         * For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
         * <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
         * </p>
         * <p>
         * The maximum capacity must be greater than or equal to the minimum capacity.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
         *        <p>
         *        For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>,
         *        <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and
         *        <code>256</code>.
         *        </p>
         *        <p>
         *        For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>,
         *        <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.
         *        </p>
         *        <p>
         *        The maximum capacity must be greater than or equal to the minimum capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in <code>serverless</code> DB
         * engine mode. A DB cluster can be paused only when it's idle (it has no connections).
         * </p>
         * <note>
         * <p>
         * If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In
         * this case, the DB cluster is restored when there is a request to connect to it.
         * </p>
         * </note>
         * 
         * @param autoPause
         *        Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in
         *        <code>serverless</code> DB engine mode. A DB cluster can be paused only when it's idle (it has no
         *        connections).</p> <note>
         *        <p>
         *        If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot.
         *        In this case, the DB cluster is restored when there is a request to connect to it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoPause(Boolean autoPause);

        /**
         * <p>
         * The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.
         * </p>
         * <p>
         * Specify a value between 300 and 86,400 seconds.
         * </p>
         * 
         * @param secondsUntilAutoPause
         *        The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.</p>
         *        <p>
         *        Specify a value between 300 and 86,400 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondsUntilAutoPause(Integer secondsUntilAutoPause);

        /**
         * <p>
         * The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
         * <code>RollbackCapacityChange</code>.
         * </p>
         * <p>
         * <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.
         * </p>
         * <p>
         * <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't found
         * in the timeout period.
         * </p>
         * <important>
         * <p>
         * If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless v1 from
         * finding a scaling point might be dropped.
         * </p>
         * </important>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
         * > Autoscaling for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param timeoutAction
         *        The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or
         *        <code>RollbackCapacityChange</code>.</p>
         *        <p>
         *        <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.
         *        </p>
         *        <p>
         *        <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't
         *        found in the timeout period.
         *        </p>
         *        <important>
         *        <p>
         *        If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless v1
         *        from finding a scaling point might be dropped.
         *        </p>
         *        </important>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
         *        > Autoscaling for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutAction(String timeoutAction);

        /**
         * <p>
         * The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless
         * scaling before enforcing the timeout action. The default is 300.
         * </p>
         * <p>
         * Specify a value between 60 and 600 seconds.
         * </p>
         * 
         * @param secondsBeforeTimeout
         *        The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform
         *        seamless scaling before enforcing the timeout action. The default is 300.</p>
         *        <p>
         *        Specify a value between 60 and 600 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondsBeforeTimeout(Integer secondsBeforeTimeout);
    }

    static final class BuilderImpl implements Builder {
        private Integer minCapacity;

        private Integer maxCapacity;

        private Boolean autoPause;

        private Integer secondsUntilAutoPause;

        private String timeoutAction;

        private Integer secondsBeforeTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConfiguration model) {
            minCapacity(model.minCapacity);
            maxCapacity(model.maxCapacity);
            autoPause(model.autoPause);
            secondsUntilAutoPause(model.secondsUntilAutoPause);
            timeoutAction(model.timeoutAction);
            secondsBeforeTimeout(model.secondsBeforeTimeout);
        }

        public final Integer getMinCapacity() {
            return minCapacity;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Boolean getAutoPause() {
            return autoPause;
        }

        public final void setAutoPause(Boolean autoPause) {
            this.autoPause = autoPause;
        }

        @Override
        public final Builder autoPause(Boolean autoPause) {
            this.autoPause = autoPause;
            return this;
        }

        public final Integer getSecondsUntilAutoPause() {
            return secondsUntilAutoPause;
        }

        public final void setSecondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
        }

        @Override
        public final Builder secondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
            return this;
        }

        public final String getTimeoutAction() {
            return timeoutAction;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        public final Integer getSecondsBeforeTimeout() {
            return secondsBeforeTimeout;
        }

        public final void setSecondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
        }

        @Override
        public final Builder secondsBeforeTimeout(Integer secondsBeforeTimeout) {
            this.secondsBeforeTimeout = secondsBeforeTimeout;
            return this;
        }

        @Override
        public ScalingConfiguration build() {
            return new ScalingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
