/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a cluster version, including the parameter group family and description of the version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterVersion implements SdkPojo, Serializable, ToCopyableBuilder<ClusterVersion.Builder, ClusterVersion> {
    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterVersion").getter(getter(ClusterVersion::clusterVersion)).setter(setter(Builder::clusterVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()).build();

    private static final SdkField<String> CLUSTER_PARAMETER_GROUP_FAMILY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClusterParameterGroupFamily")
            .getter(getter(ClusterVersion::clusterParameterGroupFamily))
            .setter(setter(Builder::clusterParameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroupFamily")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ClusterVersion::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_VERSION_FIELD,
            CLUSTER_PARAMETER_GROUP_FAMILY_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterVersion;

    private final String clusterParameterGroupFamily;

    private final String description;

    private ClusterVersion(BuilderImpl builder) {
        this.clusterVersion = builder.clusterVersion;
        this.clusterParameterGroupFamily = builder.clusterParameterGroupFamily;
        this.description = builder.description;
    }

    /**
     * <p>
     * The version number used by the cluster.
     * </p>
     * 
     * @return The version number used by the cluster.
     */
    public final String clusterVersion() {
        return clusterVersion;
    }

    /**
     * <p>
     * The name of the cluster parameter group family for the cluster.
     * </p>
     * 
     * @return The name of the cluster parameter group family for the cluster.
     */
    public final String clusterParameterGroupFamily() {
        return clusterParameterGroupFamily;
    }

    /**
     * <p>
     * The description of the cluster version.
     * </p>
     * 
     * @return The description of the cluster version.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clusterParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterVersion)) {
            return false;
        }
        ClusterVersion other = (ClusterVersion) obj;
        return Objects.equals(clusterVersion(), other.clusterVersion())
                && Objects.equals(clusterParameterGroupFamily(), other.clusterParameterGroupFamily())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterVersion").add("ClusterVersion", clusterVersion())
                .add("ClusterParameterGroupFamily", clusterParameterGroupFamily()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterVersion":
            return Optional.ofNullable(clazz.cast(clusterVersion()));
        case "ClusterParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(clusterParameterGroupFamily()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterVersion, T> g) {
        return obj -> g.apply((ClusterVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterVersion> {
        /**
         * <p>
         * The version number used by the cluster.
         * </p>
         * 
         * @param clusterVersion
         *        The version number used by the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterVersion(String clusterVersion);

        /**
         * <p>
         * The name of the cluster parameter group family for the cluster.
         * </p>
         * 
         * @param clusterParameterGroupFamily
         *        The name of the cluster parameter group family for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterGroupFamily(String clusterParameterGroupFamily);

        /**
         * <p>
         * The description of the cluster version.
         * </p>
         * 
         * @param description
         *        The description of the cluster version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String clusterVersion;

        private String clusterParameterGroupFamily;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterVersion model) {
            clusterVersion(model.clusterVersion);
            clusterParameterGroupFamily(model.clusterParameterGroupFamily);
            description(model.description);
        }

        public final String getClusterVersion() {
            return clusterVersion;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final String getClusterParameterGroupFamily() {
            return clusterParameterGroupFamily;
        }

        public final void setClusterParameterGroupFamily(String clusterParameterGroupFamily) {
            this.clusterParameterGroupFamily = clusterParameterGroupFamily;
        }

        @Override
        public final Builder clusterParameterGroupFamily(String clusterParameterGroupFamily) {
            this.clusterParameterGroupFamily = clusterParameterGroupFamily;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ClusterVersion build() {
            return new ClusterVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
