/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConvertRecoveryPointToSnapshotRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<ConvertRecoveryPointToSnapshotRequest.Builder, ConvertRecoveryPointToSnapshotRequest> {
    private static final SdkField<String> RECOVERY_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryPointId").getter(getter(ConvertRecoveryPointToSnapshotRequest::recoveryPointId))
            .setter(setter(Builder::recoveryPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPointId").build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retentionPeriod").getter(getter(ConvertRecoveryPointToSnapshotRequest::retentionPeriod))
            .setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotName").getter(getter(ConvertRecoveryPointToSnapshotRequest::snapshotName))
            .setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ID_FIELD,
            RETENTION_PERIOD_FIELD, SNAPSHOT_NAME_FIELD));

    private final String recoveryPointId;

    private final Integer retentionPeriod;

    private final String snapshotName;

    private ConvertRecoveryPointToSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.recoveryPointId = builder.recoveryPointId;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotName = builder.snapshotName;
    }

    /**
     * <p>
     * The unique identifier of the recovery point.
     * </p>
     * 
     * @return The unique identifier of the recovery point.
     */
    public final String recoveryPointId() {
        return recoveryPointId;
    }

    /**
     * <p>
     * How long to retain the snapshot.
     * </p>
     * 
     * @return How long to retain the snapshot.
     */
    public final Integer retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * The name of the snapshot.
     * </p>
     * 
     * @return The name of the snapshot.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointId());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConvertRecoveryPointToSnapshotRequest)) {
            return false;
        }
        ConvertRecoveryPointToSnapshotRequest other = (ConvertRecoveryPointToSnapshotRequest) obj;
        return Objects.equals(recoveryPointId(), other.recoveryPointId())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(snapshotName(), other.snapshotName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConvertRecoveryPointToSnapshotRequest").add("RecoveryPointId", recoveryPointId())
                .add("RetentionPeriod", retentionPeriod()).add("SnapshotName", snapshotName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recoveryPointId":
            return Optional.ofNullable(clazz.cast(recoveryPointId()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "snapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConvertRecoveryPointToSnapshotRequest, T> g) {
        return obj -> g.apply((ConvertRecoveryPointToSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ConvertRecoveryPointToSnapshotRequest> {
        /**
         * <p>
         * The unique identifier of the recovery point.
         * </p>
         * 
         * @param recoveryPointId
         *        The unique identifier of the recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointId(String recoveryPointId);

        /**
         * <p>
         * How long to retain the snapshot.
         * </p>
         * 
         * @param retentionPeriod
         *        How long to retain the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(Integer retentionPeriod);

        /**
         * <p>
         * The name of the snapshot.
         * </p>
         * 
         * @param snapshotName
         *        The name of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private String recoveryPointId;

        private Integer retentionPeriod;

        private String snapshotName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConvertRecoveryPointToSnapshotRequest model) {
            super(model);
            recoveryPointId(model.recoveryPointId);
            retentionPeriod(model.retentionPeriod);
            snapshotName(model.snapshotName);
        }

        public final String getRecoveryPointId() {
            return recoveryPointId;
        }

        public final void setRecoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
        }

        @Override
        public final Builder recoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConvertRecoveryPointToSnapshotRequest build() {
            return new ConvertRecoveryPointToSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
