/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUsageLimitRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<UpdateUsageLimitRequest.Builder, UpdateUsageLimitRequest> {
    private static final SdkField<Long> AMOUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("amount")
            .getter(getter(UpdateUsageLimitRequest::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()).build();

    private static final SdkField<String> BREACH_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("breachAction").getter(getter(UpdateUsageLimitRequest::breachActionAsString))
            .setter(setter(Builder::breachAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("breachAction").build()).build();

    private static final SdkField<String> USAGE_LIMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageLimitId").getter(getter(UpdateUsageLimitRequest::usageLimitId))
            .setter(setter(Builder::usageLimitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageLimitId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD,
            BREACH_ACTION_FIELD, USAGE_LIMIT_ID_FIELD));

    private final Long amount;

    private final String breachAction;

    private final String usageLimitId;

    private UpdateUsageLimitRequest(BuilderImpl builder) {
        super(builder);
        this.amount = builder.amount;
        this.breachAction = builder.breachAction;
        this.usageLimitId = builder.usageLimitId;
    }

    /**
     * <p>
     * The new limit amount. For more information about this parameter.
     * </p>
     * 
     * @return The new limit amount. For more information about this parameter.
     */
    public final Long amount() {
        return amount;
    }

    /**
     * <p>
     * The new action that Amazon Redshift Serverless takes when the limit is reached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #breachAction} will
     * return {@link UsageLimitBreachAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #breachActionAsString}.
     * </p>
     * 
     * @return The new action that Amazon Redshift Serverless takes when the limit is reached.
     * @see UsageLimitBreachAction
     */
    public final UsageLimitBreachAction breachAction() {
        return UsageLimitBreachAction.fromValue(breachAction);
    }

    /**
     * <p>
     * The new action that Amazon Redshift Serverless takes when the limit is reached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #breachAction} will
     * return {@link UsageLimitBreachAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #breachActionAsString}.
     * </p>
     * 
     * @return The new action that Amazon Redshift Serverless takes when the limit is reached.
     * @see UsageLimitBreachAction
     */
    public final String breachActionAsString() {
        return breachAction;
    }

    /**
     * <p>
     * The identifier of the usage limit to update.
     * </p>
     * 
     * @return The identifier of the usage limit to update.
     */
    public final String usageLimitId() {
        return usageLimitId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(breachActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(usageLimitId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUsageLimitRequest)) {
            return false;
        }
        UpdateUsageLimitRequest other = (UpdateUsageLimitRequest) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(breachActionAsString(), other.breachActionAsString())
                && Objects.equals(usageLimitId(), other.usageLimitId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUsageLimitRequest").add("Amount", amount()).add("BreachAction", breachActionAsString())
                .add("UsageLimitId", usageLimitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "breachAction":
            return Optional.ofNullable(clazz.cast(breachActionAsString()));
        case "usageLimitId":
            return Optional.ofNullable(clazz.cast(usageLimitId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUsageLimitRequest, T> g) {
        return obj -> g.apply((UpdateUsageLimitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateUsageLimitRequest> {
        /**
         * <p>
         * The new limit amount. For more information about this parameter.
         * </p>
         * 
         * @param amount
         *        The new limit amount. For more information about this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Long amount);

        /**
         * <p>
         * The new action that Amazon Redshift Serverless takes when the limit is reached.
         * </p>
         * 
         * @param breachAction
         *        The new action that Amazon Redshift Serverless takes when the limit is reached.
         * @see UsageLimitBreachAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitBreachAction
         */
        Builder breachAction(String breachAction);

        /**
         * <p>
         * The new action that Amazon Redshift Serverless takes when the limit is reached.
         * </p>
         * 
         * @param breachAction
         *        The new action that Amazon Redshift Serverless takes when the limit is reached.
         * @see UsageLimitBreachAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitBreachAction
         */
        Builder breachAction(UsageLimitBreachAction breachAction);

        /**
         * <p>
         * The identifier of the usage limit to update.
         * </p>
         * 
         * @param usageLimitId
         *        The identifier of the usage limit to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageLimitId(String usageLimitId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private Long amount;

        private String breachAction;

        private String usageLimitId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUsageLimitRequest model) {
            super(model);
            amount(model.amount);
            breachAction(model.breachAction);
            usageLimitId(model.usageLimitId);
        }

        public final Long getAmount() {
            return amount;
        }

        public final void setAmount(Long amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public final String getBreachAction() {
            return breachAction;
        }

        public final void setBreachAction(String breachAction) {
            this.breachAction = breachAction;
        }

        @Override
        public final Builder breachAction(String breachAction) {
            this.breachAction = breachAction;
            return this;
        }

        @Override
        public final Builder breachAction(UsageLimitBreachAction breachAction) {
            this.breachAction(breachAction == null ? null : breachAction.toString());
            return this;
        }

        public final String getUsageLimitId() {
            return usageLimitId;
        }

        public final void setUsageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
        }

        @Override
        public final Builder usageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUsageLimitRequest build() {
            return new UpdateUsageLimitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
