/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters that you can use to configure a <a
 * href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html">scheduled
 * action</a> to create a snapshot. For more information about creating a scheduled action, see <a
 * href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html"
 * >CreateScheduledAction</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSnapshotScheduleActionParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateSnapshotScheduleActionParameters.Builder, CreateSnapshotScheduleActionParameters> {
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(CreateSnapshotScheduleActionParameters::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("retentionPeriod").getter(getter(CreateSnapshotScheduleActionParameters::retentionPeriod))
            .setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotNamePrefix").getter(getter(CreateSnapshotScheduleActionParameters::snapshotNamePrefix))
            .setter(setter(Builder::snapshotNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotNamePrefix").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateSnapshotScheduleActionParameters::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_NAME_FIELD,
            RETENTION_PERIOD_FIELD, SNAPSHOT_NAME_PREFIX_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String namespaceName;

    private final Integer retentionPeriod;

    private final String snapshotNamePrefix;

    private final List<Tag> tags;

    private CreateSnapshotScheduleActionParameters(BuilderImpl builder) {
        this.namespaceName = builder.namespaceName;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotNamePrefix = builder.snapshotNamePrefix;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the namespace for which you want to configure a scheduled action to create a snapshot.
     * </p>
     * 
     * @return The name of the namespace for which you want to configure a scheduled action to create a snapshot.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The retention period of the snapshot created by the scheduled action.
     * </p>
     * 
     * @return The retention period of the snapshot created by the scheduled action.
     */
    public final Integer retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * A string prefix that is attached to the name of the snapshot created by the scheduled action. The final name of
     * the snapshot is the string prefix appended by the date and time of when the snapshot was created.
     * </p>
     * 
     * @return A string prefix that is attached to the name of the snapshot created by the scheduled action. The final
     *         name of the snapshot is the string prefix appended by the date and time of when the snapshot was created.
     */
    public final String snapshotNamePrefix() {
        return snapshotNamePrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
     * objects</a> to associate with the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of <a
     *         href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag objects</a>
     *         to associate with the snapshot.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotScheduleActionParameters)) {
            return false;
        }
        CreateSnapshotScheduleActionParameters other = (CreateSnapshotScheduleActionParameters) obj;
        return Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(snapshotNamePrefix(), other.snapshotNamePrefix()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSnapshotScheduleActionParameters").add("NamespaceName", namespaceName())
                .add("RetentionPeriod", retentionPeriod()).add("SnapshotNamePrefix", snapshotNamePrefix())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "snapshotNamePrefix":
            return Optional.ofNullable(clazz.cast(snapshotNamePrefix()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotScheduleActionParameters, T> g) {
        return obj -> g.apply((CreateSnapshotScheduleActionParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateSnapshotScheduleActionParameters> {
        /**
         * <p>
         * The name of the namespace for which you want to configure a scheduled action to create a snapshot.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace for which you want to configure a scheduled action to create a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The retention period of the snapshot created by the scheduled action.
         * </p>
         * 
         * @param retentionPeriod
         *        The retention period of the snapshot created by the scheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(Integer retentionPeriod);

        /**
         * <p>
         * A string prefix that is attached to the name of the snapshot created by the scheduled action. The final name
         * of the snapshot is the string prefix appended by the date and time of when the snapshot was created.
         * </p>
         * 
         * @param snapshotNamePrefix
         *        A string prefix that is attached to the name of the snapshot created by the scheduled action. The
         *        final name of the snapshot is the string prefix appended by the date and time of when the snapshot was
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotNamePrefix(String snapshotNamePrefix);

        /**
         * <p>
         * An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
         * objects</a> to associate with the snapshot.
         * </p>
         * 
         * @param tags
         *        An array of <a
         *        href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
         *        objects</a> to associate with the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
         * objects</a> to associate with the snapshot.
         * </p>
         * 
         * @param tags
         *        An array of <a
         *        href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
         *        objects</a> to associate with the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag
         * objects</a> to associate with the snapshot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftserverless.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.redshiftserverless.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftserverless.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftserverless.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String namespaceName;

        private Integer retentionPeriod;

        private String snapshotNamePrefix;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotScheduleActionParameters model) {
            namespaceName(model.namespaceName);
            retentionPeriod(model.retentionPeriod);
            snapshotNamePrefix(model.snapshotNamePrefix);
            tags(model.tags);
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getSnapshotNamePrefix() {
            return snapshotNamePrefix;
        }

        public final void setSnapshotNamePrefix(String snapshotNamePrefix) {
            this.snapshotNamePrefix = snapshotNamePrefix;
        }

        @Override
        public final Builder snapshotNamePrefix(String snapshotNamePrefix) {
            this.snapshotNamePrefix = snapshotNamePrefix;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateSnapshotScheduleActionParameters build() {
            return new CreateSnapshotScheduleActionParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
