/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecoveryPointsRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<ListRecoveryPointsRequest.Builder, ListRecoveryPointsRequest> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(ListRecoveryPointsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRecoveryPointsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceArn").getter(getter(ListRecoveryPointsRequest::namespaceArn))
            .setter(setter(Builder::namespaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(ListRecoveryPointsRequest::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRecoveryPointsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ListRecoveryPointsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            MAX_RESULTS_FIELD, NAMESPACE_ARN_FIELD, NAMESPACE_NAME_FIELD, NEXT_TOKEN_FIELD, START_TIME_FIELD));

    private final Instant endTime;

    private final Integer maxResults;

    private final String namespaceArn;

    private final String namespaceName;

    private final String nextToken;

    private final Instant startTime;

    private ListRecoveryPointsRequest(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.nextToken = builder.nextToken;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The time when creation of the recovery point finished.
     * </p>
     * 
     * @return The time when creation of the recovery point finished.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code>
     * to display the next page of results.
     * </p>
     * 
     * @return An optional parameter that specifies the maximum number of results to return. You can use
     *         <code>nextToken</code> to display the next page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the namespace from which to list recovery points.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the namespace from which to list recovery points.
     */
    public final String namespaceArn() {
        return namespaceArn;
    }

    /**
     * <p>
     * The name of the namespace to list recovery points for.
     * </p>
     * 
     * @return The name of the namespace to list recovery points for.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * If your initial <code>ListRecoveryPoints</code> operation returns a <code>nextToken</code>, you can include the
     * returned <code>nextToken</code> in following <code>ListRecoveryPoints</code> operations, which returns results in
     * the next page.
     * </p>
     * 
     * @return If your initial <code>ListRecoveryPoints</code> operation returns a <code>nextToken</code>, you can
     *         include the returned <code>nextToken</code> in following <code>ListRecoveryPoints</code> operations,
     *         which returns results in the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The time when the recovery point's creation was initiated.
     * </p>
     * 
     * @return The time when the recovery point's creation was initiated.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecoveryPointsRequest)) {
            return false;
        }
        ListRecoveryPointsRequest other = (ListRecoveryPointsRequest) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(namespaceArn(), other.namespaceArn()) && Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecoveryPointsRequest").add("EndTime", endTime()).add("MaxResults", maxResults())
                .add("NamespaceArn", namespaceArn()).add("NamespaceName", namespaceName()).add("NextToken", nextToken())
                .add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "namespaceArn":
            return Optional.ofNullable(clazz.cast(namespaceArn()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecoveryPointsRequest, T> g) {
        return obj -> g.apply((ListRecoveryPointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRecoveryPointsRequest> {
        /**
         * <p>
         * The time when creation of the recovery point finished.
         * </p>
         * 
         * @param endTime
         *        The time when creation of the recovery point finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * An optional parameter that specifies the maximum number of results to return. You can use
         * <code>nextToken</code> to display the next page of results.
         * </p>
         * 
         * @param maxResults
         *        An optional parameter that specifies the maximum number of results to return. You can use
         *        <code>nextToken</code> to display the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the namespace from which to list recovery points.
         * </p>
         * 
         * @param namespaceArn
         *        The Amazon Resource Name (ARN) of the namespace from which to list recovery points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceArn(String namespaceArn);

        /**
         * <p>
         * The name of the namespace to list recovery points for.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace to list recovery points for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * If your initial <code>ListRecoveryPoints</code> operation returns a <code>nextToken</code>, you can include
         * the returned <code>nextToken</code> in following <code>ListRecoveryPoints</code> operations, which returns
         * results in the next page.
         * </p>
         * 
         * @param nextToken
         *        If your initial <code>ListRecoveryPoints</code> operation returns a <code>nextToken</code>, you can
         *        include the returned <code>nextToken</code> in following <code>ListRecoveryPoints</code> operations,
         *        which returns results in the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The time when the recovery point's creation was initiated.
         * </p>
         * 
         * @param startTime
         *        The time when the recovery point's creation was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private Instant endTime;

        private Integer maxResults;

        private String namespaceArn;

        private String namespaceName;

        private String nextToken;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecoveryPointsRequest model) {
            super(model);
            endTime(model.endTime);
            maxResults(model.maxResults);
            namespaceArn(model.namespaceArn);
            namespaceName(model.namespaceName);
            nextToken(model.nextToken);
            startTime(model.startTime);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNamespaceArn() {
            return namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecoveryPointsRequest build() {
            return new ListRecoveryPointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
