/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTableFromRecoveryPointResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<RestoreTableFromRecoveryPointResponse.Builder, RestoreTableFromRecoveryPointResponse> {
    private static final SdkField<TableRestoreStatus> TABLE_RESTORE_STATUS_FIELD = SdkField
            .<TableRestoreStatus> builder(MarshallingType.SDK_POJO).memberName("tableRestoreStatus")
            .getter(getter(RestoreTableFromRecoveryPointResponse::tableRestoreStatus))
            .setter(setter(Builder::tableRestoreStatus)).constructor(TableRestoreStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableRestoreStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_RESTORE_STATUS_FIELD));

    private final TableRestoreStatus tableRestoreStatus;

    private RestoreTableFromRecoveryPointResponse(BuilderImpl builder) {
        super(builder);
        this.tableRestoreStatus = builder.tableRestoreStatus;
    }

    /**
     * Returns the value of the TableRestoreStatus property for this object.
     * 
     * @return The value of the TableRestoreStatus property for this object.
     */
    public final TableRestoreStatus tableRestoreStatus() {
        return tableRestoreStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableRestoreStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromRecoveryPointResponse)) {
            return false;
        }
        RestoreTableFromRecoveryPointResponse other = (RestoreTableFromRecoveryPointResponse) obj;
        return Objects.equals(tableRestoreStatus(), other.tableRestoreStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTableFromRecoveryPointResponse").add("TableRestoreStatus", tableRestoreStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tableRestoreStatus":
            return Optional.ofNullable(clazz.cast(tableRestoreStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableFromRecoveryPointResponse, T> g) {
        return obj -> g.apply((RestoreTableFromRecoveryPointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreTableFromRecoveryPointResponse> {
        /**
         * Sets the value of the TableRestoreStatus property for this object.
         *
         * @param tableRestoreStatus
         *        The new value for the TableRestoreStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableRestoreStatus(TableRestoreStatus tableRestoreStatus);

        /**
         * Sets the value of the TableRestoreStatus property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TableRestoreStatus.Builder} avoiding the
         * need to create one manually via {@link TableRestoreStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableRestoreStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #tableRestoreStatus(TableRestoreStatus)}.
         * 
         * @param tableRestoreStatus
         *        a consumer that will call methods on {@link TableRestoreStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableRestoreStatus(TableRestoreStatus)
         */
        default Builder tableRestoreStatus(Consumer<TableRestoreStatus.Builder> tableRestoreStatus) {
            return tableRestoreStatus(TableRestoreStatus.builder().applyMutation(tableRestoreStatus).build());
        }
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private TableRestoreStatus tableRestoreStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromRecoveryPointResponse model) {
            super(model);
            tableRestoreStatus(model.tableRestoreStatus);
        }

        public final TableRestoreStatus.Builder getTableRestoreStatus() {
            return tableRestoreStatus != null ? tableRestoreStatus.toBuilder() : null;
        }

        public final void setTableRestoreStatus(TableRestoreStatus.BuilderImpl tableRestoreStatus) {
            this.tableRestoreStatus = tableRestoreStatus != null ? tableRestoreStatus.build() : null;
        }

        @Override
        public final Builder tableRestoreStatus(TableRestoreStatus tableRestoreStatus) {
            this.tableRestoreStatus = tableRestoreStatus;
            return this;
        }

        @Override
        public RestoreTableFromRecoveryPointResponse build() {
            return new RestoreTableFromRecoveryPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
