/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.repostspace.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains some information about a private re:Post in the account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpaceData implements SdkPojo, Serializable, ToCopyableBuilder<SpaceData.Builder, SpaceData> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SpaceData::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CONFIGURATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationStatus").getter(getter(SpaceData::configurationStatusAsString))
            .setter(setter(Builder::configurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationStatus").build())
            .build();

    private static final SdkField<Long> CONTENT_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("contentSize").getter(getter(SpaceData::contentSize)).setter(setter(Builder::contentSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentSize").build()).build();

    private static final SdkField<Instant> CREATE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createDateTime")
            .getter(getter(SpaceData::createDateTime))
            .setter(setter(Builder::createDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createDateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> DELETE_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("deleteDateTime")
            .getter(getter(SpaceData::deleteDateTime))
            .setter(setter(Builder::deleteDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteDateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SpaceData::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SpaceData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RANDOM_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("randomDomain").getter(getter(SpaceData::randomDomain)).setter(setter(Builder::randomDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("randomDomain").build()).build();

    private static final SdkField<String> SPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spaceId").getter(getter(SpaceData::spaceId)).setter(setter(Builder::spaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spaceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SpaceData::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Long> STORAGE_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("storageLimit").getter(getter(SpaceData::storageLimit)).setter(setter(Builder::storageLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLimit").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("tier")
            .getter(getter(SpaceData::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()).build();

    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("userCount").getter(getter(SpaceData::userCount)).setter(setter(Builder::userCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userCount").build()).build();

    private static final SdkField<String> USER_KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userKMSKey").getter(getter(SpaceData::userKMSKey)).setter(setter(Builder::userKMSKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userKMSKey").build()).build();

    private static final SdkField<String> VANITY_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vanityDomain").getter(getter(SpaceData::vanityDomain)).setter(setter(Builder::vanityDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vanityDomain").build()).build();

    private static final SdkField<String> VANITY_DOMAIN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vanityDomainStatus").getter(getter(SpaceData::vanityDomainStatusAsString))
            .setter(setter(Builder::vanityDomainStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vanityDomainStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONFIGURATION_STATUS_FIELD, CONTENT_SIZE_FIELD, CREATE_DATE_TIME_FIELD, DELETE_DATE_TIME_FIELD, DESCRIPTION_FIELD,
            NAME_FIELD, RANDOM_DOMAIN_FIELD, SPACE_ID_FIELD, STATUS_FIELD, STORAGE_LIMIT_FIELD, TIER_FIELD, USER_COUNT_FIELD,
            USER_KMS_KEY_FIELD, VANITY_DOMAIN_FIELD, VANITY_DOMAIN_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String configurationStatus;

    private final Long contentSize;

    private final Instant createDateTime;

    private final Instant deleteDateTime;

    private final String description;

    private final String name;

    private final String randomDomain;

    private final String spaceId;

    private final String status;

    private final Long storageLimit;

    private final String tier;

    private final Integer userCount;

    private final String userKMSKey;

    private final String vanityDomain;

    private final String vanityDomainStatus;

    private SpaceData(BuilderImpl builder) {
        this.arn = builder.arn;
        this.configurationStatus = builder.configurationStatus;
        this.contentSize = builder.contentSize;
        this.createDateTime = builder.createDateTime;
        this.deleteDateTime = builder.deleteDateTime;
        this.description = builder.description;
        this.name = builder.name;
        this.randomDomain = builder.randomDomain;
        this.spaceId = builder.spaceId;
        this.status = builder.status;
        this.storageLimit = builder.storageLimit;
        this.tier = builder.tier;
        this.userCount = builder.userCount;
        this.userKMSKey = builder.userKMSKey;
        this.vanityDomain = builder.vanityDomain;
        this.vanityDomainStatus = builder.vanityDomainStatus;
    }

    /**
     * <p>
     * The ARN of the private re:Post.
     * </p>
     * 
     * @return The ARN of the private re:Post.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The configuration status of the private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationStatus} will return {@link ConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationStatusAsString}.
     * </p>
     * 
     * @return The configuration status of the private re:Post.
     * @see ConfigurationStatus
     */
    public final ConfigurationStatus configurationStatus() {
        return ConfigurationStatus.fromValue(configurationStatus);
    }

    /**
     * <p>
     * The configuration status of the private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationStatus} will return {@link ConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationStatusAsString}.
     * </p>
     * 
     * @return The configuration status of the private re:Post.
     * @see ConfigurationStatus
     */
    public final String configurationStatusAsString() {
        return configurationStatus;
    }

    /**
     * <p>
     * The content size of the private re:Post.
     * </p>
     * 
     * @return The content size of the private re:Post.
     */
    public final Long contentSize() {
        return contentSize;
    }

    /**
     * <p>
     * The date when the private re:Post was created.
     * </p>
     * 
     * @return The date when the private re:Post was created.
     */
    public final Instant createDateTime() {
        return createDateTime;
    }

    /**
     * <p>
     * The date when the private re:Post was deleted.
     * </p>
     * 
     * @return The date when the private re:Post was deleted.
     */
    public final Instant deleteDateTime() {
        return deleteDateTime;
    }

    /**
     * <p>
     * The description for the private re:Post. This is used only to help you identify this private re:Post.
     * </p>
     * 
     * @return The description for the private re:Post. This is used only to help you identify this private re:Post.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name for the private re:Post.
     * </p>
     * 
     * @return The name for the private re:Post.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The AWS generated subdomain of the private re:Post.
     * </p>
     * 
     * @return The AWS generated subdomain of the private re:Post.
     */
    public final String randomDomain() {
        return randomDomain;
    }

    /**
     * <p>
     * The unique ID of the private re:Post.
     * </p>
     * 
     * @return The unique ID of the private re:Post.
     */
    public final String spaceId() {
        return spaceId;
    }

    /**
     * <p>
     * The creation/deletion status of the private re:Post.
     * </p>
     * 
     * @return The creation/deletion status of the private re:Post.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The storage limit of the private re:Post.
     * </p>
     * 
     * @return The storage limit of the private re:Post.
     */
    public final Long storageLimit() {
        return storageLimit;
    }

    /**
     * <p>
     * The pricing tier of the private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link TierLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The pricing tier of the private re:Post.
     * @see TierLevel
     */
    public final TierLevel tier() {
        return TierLevel.fromValue(tier);
    }

    /**
     * <p>
     * The pricing tier of the private re:Post.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link TierLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The pricing tier of the private re:Post.
     * @see TierLevel
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * The number of onboarded users to the private re:Post.
     * </p>
     * 
     * @return The number of onboarded users to the private re:Post.
     */
    public final Integer userCount() {
        return userCount;
    }

    /**
     * <p>
     * The custom AWS KMS key ARN that’s used for the AWS KMS encryption.
     * </p>
     * 
     * @return The custom AWS KMS key ARN that’s used for the AWS KMS encryption.
     */
    public final String userKMSKey() {
        return userKMSKey;
    }

    /**
     * <p>
     * This custom subdomain that you use to access your private re:Post. All custom subdomains must be approved by AWS
     * before use.
     * </p>
     * 
     * @return This custom subdomain that you use to access your private re:Post. All custom subdomains must be approved
     *         by AWS before use.
     */
    public final String vanityDomain() {
        return vanityDomain;
    }

    /**
     * <p>
     * This approval status of the custom subdomain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vanityDomainStatus} will return {@link VanityDomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #vanityDomainStatusAsString}.
     * </p>
     * 
     * @return This approval status of the custom subdomain.
     * @see VanityDomainStatus
     */
    public final VanityDomainStatus vanityDomainStatus() {
        return VanityDomainStatus.fromValue(vanityDomainStatus);
    }

    /**
     * <p>
     * This approval status of the custom subdomain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #vanityDomainStatus} will return {@link VanityDomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #vanityDomainStatusAsString}.
     * </p>
     * 
     * @return This approval status of the custom subdomain.
     * @see VanityDomainStatus
     */
    public final String vanityDomainStatusAsString() {
        return vanityDomainStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(configurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contentSize());
        hashCode = 31 * hashCode + Objects.hashCode(createDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(deleteDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(randomDomain());
        hashCode = 31 * hashCode + Objects.hashCode(spaceId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(storageLimit());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userCount());
        hashCode = 31 * hashCode + Objects.hashCode(userKMSKey());
        hashCode = 31 * hashCode + Objects.hashCode(vanityDomain());
        hashCode = 31 * hashCode + Objects.hashCode(vanityDomainStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceData)) {
            return false;
        }
        SpaceData other = (SpaceData) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(configurationStatusAsString(), other.configurationStatusAsString())
                && Objects.equals(contentSize(), other.contentSize()) && Objects.equals(createDateTime(), other.createDateTime())
                && Objects.equals(deleteDateTime(), other.deleteDateTime()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name()) && Objects.equals(randomDomain(), other.randomDomain())
                && Objects.equals(spaceId(), other.spaceId()) && Objects.equals(status(), other.status())
                && Objects.equals(storageLimit(), other.storageLimit()) && Objects.equals(tierAsString(), other.tierAsString())
                && Objects.equals(userCount(), other.userCount()) && Objects.equals(userKMSKey(), other.userKMSKey())
                && Objects.equals(vanityDomain(), other.vanityDomain())
                && Objects.equals(vanityDomainStatusAsString(), other.vanityDomainStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpaceData").add("Arn", arn()).add("ConfigurationStatus", configurationStatusAsString())
                .add("ContentSize", contentSize()).add("CreateDateTime", createDateTime())
                .add("DeleteDateTime", deleteDateTime())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("RandomDomain", randomDomain())
                .add("SpaceId", spaceId()).add("Status", status()).add("StorageLimit", storageLimit())
                .add("Tier", tierAsString()).add("UserCount", userCount()).add("UserKMSKey", userKMSKey())
                .add("VanityDomain", vanityDomain()).add("VanityDomainStatus", vanityDomainStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "configurationStatus":
            return Optional.ofNullable(clazz.cast(configurationStatusAsString()));
        case "contentSize":
            return Optional.ofNullable(clazz.cast(contentSize()));
        case "createDateTime":
            return Optional.ofNullable(clazz.cast(createDateTime()));
        case "deleteDateTime":
            return Optional.ofNullable(clazz.cast(deleteDateTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "randomDomain":
            return Optional.ofNullable(clazz.cast(randomDomain()));
        case "spaceId":
            return Optional.ofNullable(clazz.cast(spaceId()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "storageLimit":
            return Optional.ofNullable(clazz.cast(storageLimit()));
        case "tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "userCount":
            return Optional.ofNullable(clazz.cast(userCount()));
        case "userKMSKey":
            return Optional.ofNullable(clazz.cast(userKMSKey()));
        case "vanityDomain":
            return Optional.ofNullable(clazz.cast(vanityDomain()));
        case "vanityDomainStatus":
            return Optional.ofNullable(clazz.cast(vanityDomainStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpaceData, T> g) {
        return obj -> g.apply((SpaceData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpaceData> {
        /**
         * <p>
         * The ARN of the private re:Post.
         * </p>
         * 
         * @param arn
         *        The ARN of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The configuration status of the private re:Post.
         * </p>
         * 
         * @param configurationStatus
         *        The configuration status of the private re:Post.
         * @see ConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationStatus
         */
        Builder configurationStatus(String configurationStatus);

        /**
         * <p>
         * The configuration status of the private re:Post.
         * </p>
         * 
         * @param configurationStatus
         *        The configuration status of the private re:Post.
         * @see ConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationStatus
         */
        Builder configurationStatus(ConfigurationStatus configurationStatus);

        /**
         * <p>
         * The content size of the private re:Post.
         * </p>
         * 
         * @param contentSize
         *        The content size of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentSize(Long contentSize);

        /**
         * <p>
         * The date when the private re:Post was created.
         * </p>
         * 
         * @param createDateTime
         *        The date when the private re:Post was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDateTime(Instant createDateTime);

        /**
         * <p>
         * The date when the private re:Post was deleted.
         * </p>
         * 
         * @param deleteDateTime
         *        The date when the private re:Post was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteDateTime(Instant deleteDateTime);

        /**
         * <p>
         * The description for the private re:Post. This is used only to help you identify this private re:Post.
         * </p>
         * 
         * @param description
         *        The description for the private re:Post. This is used only to help you identify this private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name for the private re:Post.
         * </p>
         * 
         * @param name
         *        The name for the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The AWS generated subdomain of the private re:Post.
         * </p>
         * 
         * @param randomDomain
         *        The AWS generated subdomain of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder randomDomain(String randomDomain);

        /**
         * <p>
         * The unique ID of the private re:Post.
         * </p>
         * 
         * @param spaceId
         *        The unique ID of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceId(String spaceId);

        /**
         * <p>
         * The creation/deletion status of the private re:Post.
         * </p>
         * 
         * @param status
         *        The creation/deletion status of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The storage limit of the private re:Post.
         * </p>
         * 
         * @param storageLimit
         *        The storage limit of the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLimit(Long storageLimit);

        /**
         * <p>
         * The pricing tier of the private re:Post.
         * </p>
         * 
         * @param tier
         *        The pricing tier of the private re:Post.
         * @see TierLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TierLevel
         */
        Builder tier(String tier);

        /**
         * <p>
         * The pricing tier of the private re:Post.
         * </p>
         * 
         * @param tier
         *        The pricing tier of the private re:Post.
         * @see TierLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TierLevel
         */
        Builder tier(TierLevel tier);

        /**
         * <p>
         * The number of onboarded users to the private re:Post.
         * </p>
         * 
         * @param userCount
         *        The number of onboarded users to the private re:Post.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCount(Integer userCount);

        /**
         * <p>
         * The custom AWS KMS key ARN that’s used for the AWS KMS encryption.
         * </p>
         * 
         * @param userKMSKey
         *        The custom AWS KMS key ARN that’s used for the AWS KMS encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userKMSKey(String userKMSKey);

        /**
         * <p>
         * This custom subdomain that you use to access your private re:Post. All custom subdomains must be approved by
         * AWS before use.
         * </p>
         * 
         * @param vanityDomain
         *        This custom subdomain that you use to access your private re:Post. All custom subdomains must be
         *        approved by AWS before use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vanityDomain(String vanityDomain);

        /**
         * <p>
         * This approval status of the custom subdomain.
         * </p>
         * 
         * @param vanityDomainStatus
         *        This approval status of the custom subdomain.
         * @see VanityDomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VanityDomainStatus
         */
        Builder vanityDomainStatus(String vanityDomainStatus);

        /**
         * <p>
         * This approval status of the custom subdomain.
         * </p>
         * 
         * @param vanityDomainStatus
         *        This approval status of the custom subdomain.
         * @see VanityDomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VanityDomainStatus
         */
        Builder vanityDomainStatus(VanityDomainStatus vanityDomainStatus);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String configurationStatus;

        private Long contentSize;

        private Instant createDateTime;

        private Instant deleteDateTime;

        private String description;

        private String name;

        private String randomDomain;

        private String spaceId;

        private String status;

        private Long storageLimit;

        private String tier;

        private Integer userCount;

        private String userKMSKey;

        private String vanityDomain;

        private String vanityDomainStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceData model) {
            arn(model.arn);
            configurationStatus(model.configurationStatus);
            contentSize(model.contentSize);
            createDateTime(model.createDateTime);
            deleteDateTime(model.deleteDateTime);
            description(model.description);
            name(model.name);
            randomDomain(model.randomDomain);
            spaceId(model.spaceId);
            status(model.status);
            storageLimit(model.storageLimit);
            tier(model.tier);
            userCount(model.userCount);
            userKMSKey(model.userKMSKey);
            vanityDomain(model.vanityDomain);
            vanityDomainStatus(model.vanityDomainStatus);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getConfigurationStatus() {
            return configurationStatus;
        }

        public final void setConfigurationStatus(String configurationStatus) {
            this.configurationStatus = configurationStatus;
        }

        @Override
        public final Builder configurationStatus(String configurationStatus) {
            this.configurationStatus = configurationStatus;
            return this;
        }

        @Override
        public final Builder configurationStatus(ConfigurationStatus configurationStatus) {
            this.configurationStatus(configurationStatus == null ? null : configurationStatus.toString());
            return this;
        }

        public final Long getContentSize() {
            return contentSize;
        }

        public final void setContentSize(Long contentSize) {
            this.contentSize = contentSize;
        }

        @Override
        public final Builder contentSize(Long contentSize) {
            this.contentSize = contentSize;
            return this;
        }

        public final Instant getCreateDateTime() {
            return createDateTime;
        }

        public final void setCreateDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
        }

        @Override
        public final Builder createDateTime(Instant createDateTime) {
            this.createDateTime = createDateTime;
            return this;
        }

        public final Instant getDeleteDateTime() {
            return deleteDateTime;
        }

        public final void setDeleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
        }

        @Override
        public final Builder deleteDateTime(Instant deleteDateTime) {
            this.deleteDateTime = deleteDateTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRandomDomain() {
            return randomDomain;
        }

        public final void setRandomDomain(String randomDomain) {
            this.randomDomain = randomDomain;
        }

        @Override
        public final Builder randomDomain(String randomDomain) {
            this.randomDomain = randomDomain;
            return this;
        }

        public final String getSpaceId() {
            return spaceId;
        }

        public final void setSpaceId(String spaceId) {
            this.spaceId = spaceId;
        }

        @Override
        public final Builder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Long getStorageLimit() {
            return storageLimit;
        }

        public final void setStorageLimit(Long storageLimit) {
            this.storageLimit = storageLimit;
        }

        @Override
        public final Builder storageLimit(Long storageLimit) {
            this.storageLimit = storageLimit;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(TierLevel tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Integer getUserCount() {
            return userCount;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final String getUserKMSKey() {
            return userKMSKey;
        }

        public final void setUserKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
        }

        @Override
        public final Builder userKMSKey(String userKMSKey) {
            this.userKMSKey = userKMSKey;
            return this;
        }

        public final String getVanityDomain() {
            return vanityDomain;
        }

        public final void setVanityDomain(String vanityDomain) {
            this.vanityDomain = vanityDomain;
        }

        @Override
        public final Builder vanityDomain(String vanityDomain) {
            this.vanityDomain = vanityDomain;
            return this;
        }

        public final String getVanityDomainStatus() {
            return vanityDomainStatus;
        }

        public final void setVanityDomainStatus(String vanityDomainStatus) {
            this.vanityDomainStatus = vanityDomainStatus;
        }

        @Override
        public final Builder vanityDomainStatus(String vanityDomainStatus) {
            this.vanityDomainStatus = vanityDomainStatus;
            return this;
        }

        @Override
        public final Builder vanityDomainStatus(VanityDomainStatus vanityDomainStatus) {
            this.vanityDomainStatus(vanityDomainStatus == null ? null : vanityDomainStatus.toString());
            return this;
        }

        @Override
        public SpaceData build() {
            return new SpaceData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
