/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes a resource type supported by Amazon Web Services Resource Explorer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupportedResourceType implements SdkPojo, Serializable,
        ToCopyableBuilder<SupportedResourceType.Builder, SupportedResourceType> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(SupportedResourceType::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(SupportedResourceType::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD,
            SERVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceType;

    private final String service;

    private SupportedResourceType(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.service = builder.service;
    }

    /**
     * <p>
     * The unique identifier of the resource type.
     * </p>
     * 
     * @return The unique identifier of the resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The Amazon Web Service that is associated with the resource type. This is the primary service that lets you
     * create and interact with resources of this type.
     * </p>
     * 
     * @return The Amazon Web Service that is associated with the resource type. This is the primary service that lets
     *         you create and interact with resources of this type.
     */
    public final String service() {
        return service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedResourceType)) {
            return false;
        }
        SupportedResourceType other = (SupportedResourceType) obj;
        return Objects.equals(resourceType(), other.resourceType()) && Objects.equals(service(), other.service());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupportedResourceType").add("ResourceType", resourceType()).add("Service", service()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SupportedResourceType, T> g) {
        return obj -> g.apply((SupportedResourceType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupportedResourceType> {
        /**
         * <p>
         * The unique identifier of the resource type.
         * </p>
         * 
         * @param resourceType
         *        The unique identifier of the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The Amazon Web Service that is associated with the resource type. This is the primary service that lets you
         * create and interact with resources of this type.
         * </p>
         * 
         * @param service
         *        The Amazon Web Service that is associated with the resource type. This is the primary service that
         *        lets you create and interact with resources of this type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);
    }

    static final class BuilderImpl implements Builder {
        private String resourceType;

        private String service;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedResourceType model) {
            resourceType(model.resourceType);
            service(model.service);
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        public SupportedResourceType build() {
            return new SupportedResourceType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
