/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.resourceexplorer2.internal.ResourceExplorer2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.resourceexplorer2.model.AccessDeniedException;
import software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.AssociateDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.BatchGetViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ConflictException;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.CreateViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DeleteViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.DisassociateDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.DisassociateDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetAccountLevelServiceConfigurationRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetAccountLevelServiceConfigurationResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetDefaultViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetIndexRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetIndexResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.GetViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.GetViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.InternalServerException;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListSupportedResourceTypesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceExplorer2Exception;
import software.amazon.awssdk.services.resourceexplorer2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.resourceexplorer2.model.TagResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.TagResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ThrottlingException;
import software.amazon.awssdk.services.resourceexplorer2.model.UnauthorizedException;
import software.amazon.awssdk.services.resourceexplorer2.model.UntagResourceRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UntagResourceResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateIndexTypeResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.UpdateViewResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.ValidationException;
import software.amazon.awssdk.services.resourceexplorer2.transform.AssociateDefaultViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.BatchGetViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.CreateIndexRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.CreateViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.DeleteIndexRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.DeleteViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.DisassociateDefaultViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.GetAccountLevelServiceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.GetDefaultViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.GetIndexRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.GetViewRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.ListIndexesForMembersRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.ListIndexesRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.ListSupportedResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.ListViewsRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.SearchRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.UpdateIndexTypeRequestMarshaller;
import software.amazon.awssdk.services.resourceexplorer2.transform.UpdateViewRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ResourceExplorer2Client}.
 *
 * @see ResourceExplorer2Client#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultResourceExplorer2Client implements ResourceExplorer2Client {
    private static final Logger log = Logger.loggerFor(DefaultResourceExplorer2Client.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultResourceExplorer2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Sets the specified view as the default for the Amazon Web Services Region in which you call this operation. When
     * a user performs a <a>Search</a> that doesn't explicitly specify which view to use, then Amazon Web Services
     * Resource Explorer automatically chooses this default view for searches performed in this Amazon Web Services
     * Region.
     * </p>
     * <p>
     * If an Amazon Web Services Region doesn't have a default view configured, then users must explicitly specify a
     * view with every <code>Search</code> operation performed in that Region.
     * </p>
     *
     * @param associateDefaultViewRequest
     * @return Result of the AssociateDefaultView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.AssociateDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/AssociateDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateDefaultViewResponse associateDefaultView(AssociateDefaultViewRequest associateDefaultViewRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateDefaultViewResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateDefaultViewResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateDefaultViewRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateDefaultViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateDefaultView");

            return clientHandler.execute(new ClientExecutionParams<AssociateDefaultViewRequest, AssociateDefaultViewResponse>()
                    .withOperationName("AssociateDefaultView").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateDefaultViewRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateDefaultViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details about a list of views.
     * </p>
     *
     * @param batchGetViewRequest
     * @return Result of the BatchGetView operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.BatchGetView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/BatchGetView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetViewResponse batchGetView(BatchGetViewRequest batchGetViewRequest) throws InternalServerException,
            ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetViewResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetView");

            return clientHandler.execute(new ClientExecutionParams<BatchGetViewRequest, BatchGetViewResponse>()
                    .withOperationName("BatchGetView").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetViewRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Turns on Amazon Web Services Resource Explorer in the Amazon Web Services Region in which you called this
     * operation by creating an index. Resource Explorer begins discovering the resources in this Region and stores the
     * details about the resources in the index so that they can be queried by using the <a>Search</a> operation. You
     * can create only one index in a Region.
     * </p>
     * <note>
     * <p>
     * This operation creates only a <i>local</i> index. To promote the local index in one Amazon Web Services Region
     * into the aggregator index for the Amazon Web Services account, use the <a>UpdateIndexType</a> operation. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a> in the <i>Amazon Web Services Resource Explorer User
     * Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more details about what happens when you turn on Resource Explorer in an Amazon Web Services Region, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-service-activate.html">Turn on
     * Resource Explorer to index your resources in an Amazon Web Services Region</a> in the <i>Amazon Web Services
     * Resource Explorer User Guide</i>.
     * </p>
     * <p>
     * If this is the first Amazon Web Services Region in which you've created an index for Resource Explorer, then this
     * operation also <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html"
     * >creates a service-linked role</a> in your Amazon Web Services account that allows Resource Explorer to enumerate
     * your resources to populate the index.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Action</b>: <code>resource-explorer-2:CreateIndex</code>
     * </p>
     * <p>
     * <b>Resource</b>: The ARN of the index (as it will exist after the operation completes) in the Amazon Web Services
     * Region and account in which you're trying to create the index. Use the wildcard character (<code>*</code>) at the
     * end of the string to match the eventual UUID. For example, the following <code>Resource</code> element restricts
     * the role or user to creating an index in only the <code>us-east-2</code> Region of the specified account.
     * </p>
     * <p>
     * <code>"Resource": "arn:aws:resource-explorer-2:us-west-2:<i>&lt;account-id&gt;</i>:index/*"</code>
     * </p>
     * <p>
     * Alternatively, you can use <code>"Resource": "*"</code> to allow the role or user to create an index in any
     * Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Action</b>: <code>iam:CreateServiceLinkedRole</code>
     * </p>
     * <p>
     * <b>Resource</b>: No specific resource (*).
     * </p>
     * <p>
     * This permission is required only the first time you create an index to turn on Resource Explorer in the account.
     * Resource Explorer uses this to create the <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/security_iam_service-linked-roles.html"
     * >service-linked role needed to index the resources in your account</a>. Resource Explorer uses the same
     * service-linked role for all additional indexes you create afterwards.
     * </p>
     * </li>
     * </ul>
     *
     * @param createIndexRequest
     * @return Result of the CreateIndex operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         If you attempted to create a view, then the request failed because either you specified parameters that
     *         didn’t match the original request, or you attempted to create a view with a name that already exists in
     *         this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateIndex"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws InternalServerException,
            ValidationException, ConflictException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIndexResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIndex");

            return clientHandler.execute(new ClientExecutionParams<CreateIndexRequest, CreateIndexResponse>()
                    .withOperationName("CreateIndex").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createIndexRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIndexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a view that users can query by using the <a>Search</a> operation. Results from queries that you make
     * using this view include only resources that match the view's <code>Filters</code>. For more information about
     * Amazon Web Services Resource Explorer views, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views.html">Managing views</a> in the
     * <i>Amazon Web Services Resource Explorer User Guide</i>.
     * </p>
     * <p>
     * Only the principals with an IAM identity-based policy that grants <code>Allow</code> to the <code>Search</code>
     * action on a <code>Resource</code> with the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name (ARN)</a>
     * of this view can <a>Search</a> using views you create with this operation.
     * </p>
     *
     * @param createViewRequest
     * @return Result of the CreateView operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         If you attempted to create a view, then the request failed because either you specified parameters that
     *         didn’t match the original request, or you attempted to create a view with a name that already exists in
     *         this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.
     * @throws ServiceQuotaExceededException
     *         The request failed because it exceeds a service quota.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.CreateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/CreateView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateViewResponse createView(CreateViewRequest createViewRequest) throws InternalServerException,
            ValidationException, ConflictException, ServiceQuotaExceededException, UnauthorizedException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateViewResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateView");

            return clientHandler.execute(new ClientExecutionParams<CreateViewRequest, CreateViewResponse>()
                    .withOperationName("CreateView").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createViewRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified index and turns off Amazon Web Services Resource Explorer in the specified Amazon Web
     * Services Region. When you delete an index, Resource Explorer stops discovering and indexing resources in that
     * Region. Resource Explorer also deletes all views in that Region. These actions occur as asynchronous background
     * tasks. You can check to see when the actions are complete by using the <a>GetIndex</a> operation and checking the
     * <code>Status</code> response value.
     * </p>
     * <note>
     * <p>
     * If the index you delete is the aggregator index for the Amazon Web Services account, you must wait 24 hours
     * before you can promote another local index to be the aggregator index for the account. Users can't perform
     * account-wide searches using Resource Explorer until another aggregator index is configured.
     * </p>
     * </note>
     *
     * @param deleteIndexRequest
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteIndex"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIndexResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIndex");

            return clientHandler.execute(new ClientExecutionParams<DeleteIndexRequest, DeleteIndexResponse>()
                    .withOperationName("DeleteIndex").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteIndexRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIndexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified view.
     * </p>
     * <p>
     * If the specified view is the default view for its Amazon Web Services Region, then all <a>Search</a> operations
     * in that Region must explicitly specify the view to use until you configure a new default by calling the
     * <a>AssociateDefaultView</a> operation.
     * </p>
     *
     * @param deleteViewRequest
     * @return Result of the DeleteView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.DeleteView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DeleteView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteViewResponse deleteView(DeleteViewRequest deleteViewRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteViewResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteView");

            return clientHandler.execute(new ClientExecutionParams<DeleteViewRequest, DeleteViewResponse>()
                    .withOperationName("DeleteView").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteViewRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * After you call this operation, the affected Amazon Web Services Region no longer has a default view. All
     * <a>Search</a> operations in that Region must explicitly specify a view or the operation fails. You can configure
     * a new default by calling the <a>AssociateDefaultView</a> operation.
     * </p>
     * <p>
     * If an Amazon Web Services Region doesn't have a default view configured, then users must explicitly specify a
     * view with every <code>Search</code> operation performed in that Region.
     * </p>
     *
     * @param disassociateDefaultViewRequest
     * @return Result of the DisassociateDefaultView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.DisassociateDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/DisassociateDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateDefaultViewResponse disassociateDefaultView(DisassociateDefaultViewRequest disassociateDefaultViewRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateDefaultViewResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateDefaultViewResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateDefaultViewRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateDefaultViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateDefaultView");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateDefaultViewRequest, DisassociateDefaultViewResponse>()
                            .withOperationName("DisassociateDefaultView").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateDefaultViewRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateDefaultViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the status of your account's Amazon Web Services service access, and validates the service linked role
     * required to access the multi-account search feature. Only the management account or a delegated administrator
     * with service access enabled can invoke this API call.
     * </p>
     *
     * @param getAccountLevelServiceConfigurationRequest
     * @return Result of the GetAccountLevelServiceConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.GetAccountLevelServiceConfiguration
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetAccountLevelServiceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAccountLevelServiceConfigurationResponse getAccountLevelServiceConfiguration(
            GetAccountLevelServiceConfigurationRequest getAccountLevelServiceConfigurationRequest)
            throws ResourceNotFoundException, InternalServerException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAccountLevelServiceConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAccountLevelServiceConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccountLevelServiceConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAccountLevelServiceConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountLevelServiceConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAccountLevelServiceConfigurationRequest, GetAccountLevelServiceConfigurationResponse>()
                            .withOperationName("GetAccountLevelServiceConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getAccountLevelServiceConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAccountLevelServiceConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the Amazon Resource Name (ARN) of the view that is the default for the Amazon Web Services Region in
     * which you call this operation. You can then call <a>GetView</a> to retrieve the details of that view.
     * </p>
     *
     * @param getDefaultViewRequest
     * @return Result of the GetDefaultView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.GetDefaultView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetDefaultView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDefaultViewResponse getDefaultView(GetDefaultViewRequest getDefaultViewRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDefaultViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDefaultViewResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDefaultViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDefaultViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDefaultView");

            return clientHandler.execute(new ClientExecutionParams<GetDefaultViewRequest, GetDefaultViewResponse>()
                    .withOperationName("GetDefaultView").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDefaultViewRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDefaultViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details about the Amazon Web Services Resource Explorer index in the Amazon Web Services Region in
     * which you invoked the operation.
     * </p>
     *
     * @param getIndexRequest
     * @return Result of the GetIndex operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetIndex" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetIndexResponse getIndex(GetIndexRequest getIndexRequest) throws ResourceNotFoundException, InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetIndexResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIndex");

            return clientHandler.execute(new ClientExecutionParams<GetIndexRequest, GetIndexResponse>()
                    .withOperationName("GetIndex").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getIndexRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIndexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details of the specified view.
     * </p>
     *
     * @param getViewRequest
     * @return Result of the GetView operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.GetView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/GetView" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetViewResponse getView(GetViewRequest getViewRequest) throws ResourceNotFoundException, InternalServerException,
            ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetViewResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetView");

            return clientHandler.execute(new ClientExecutionParams<GetViewRequest, GetViewResponse>()
                    .withOperationName("GetView").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getViewRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of all of the indexes in Amazon Web Services Regions that are currently collecting resource
     * information for Amazon Web Services Resource Explorer.
     * </p>
     *
     * @param listIndexesRequest
     * @return Result of the ListIndexes operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIndexesResponse listIndexes(ListIndexesRequest listIndexesRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIndexesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIndexesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIndexesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIndexesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIndexes");

            return clientHandler.execute(new ClientExecutionParams<ListIndexesRequest, ListIndexesResponse>()
                    .withOperationName("ListIndexes").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listIndexesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIndexesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of a member's indexes in all Amazon Web Services Regions that are currently collecting resource
     * information for Amazon Web Services Resource Explorer. Only the management account or a delegated administrator
     * with service access enabled can invoke this API call.
     * </p>
     *
     * @param listIndexesForMembersRequest
     * @return Result of the ListIndexesForMembers operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListIndexesForMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListIndexesForMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIndexesForMembersResponse listIndexesForMembers(ListIndexesForMembersRequest listIndexesForMembersRequest)
            throws InternalServerException, ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIndexesForMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListIndexesForMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIndexesForMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIndexesForMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIndexesForMembers");

            return clientHandler.execute(new ClientExecutionParams<ListIndexesForMembersRequest, ListIndexesForMembersResponse>()
                    .withOperationName("ListIndexesForMembers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listIndexesForMembersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIndexesForMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of all resource types currently supported by Amazon Web Services Resource Explorer.
     * </p>
     *
     * @param listSupportedResourceTypesRequest
     * @return Result of the ListSupportedResourceTypes operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListSupportedResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListSupportedResourceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSupportedResourceTypesResponse listSupportedResourceTypes(
            ListSupportedResourceTypesRequest listSupportedResourceTypesRequest) throws InternalServerException,
            ValidationException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSupportedResourceTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSupportedResourceTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSupportedResourceTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSupportedResourceTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSupportedResourceTypes");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSupportedResourceTypesRequest, ListSupportedResourceTypesResponse>()
                            .withOperationName("ListSupportedResourceTypes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listSupportedResourceTypesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSupportedResourceTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, UnauthorizedException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     * names (ARNs)</a> of the views available in the Amazon Web Services Region in which you call this operation.
     * </p>
     * <note>
     * <p>
     * Always check the <code>NextToken</code> response parameter for a <code>null</code> value when calling a paginated
     * operation. These operations can occasionally return an empty set of results even when there are more results
     * available. The <code>NextToken</code> response parameter value is <code>null</code> <i>only</i> when there are no
     * more results to display.
     * </p>
     * </note>
     *
     * @param listViewsRequest
     * @return Result of the ListViews operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.ListViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/ListViews" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListViewsResponse listViews(ListViewsRequest listViewsRequest) throws InternalServerException, ValidationException,
            ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListViewsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListViewsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listViewsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listViewsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListViews");

            return clientHandler.execute(new ClientExecutionParams<ListViewsRequest, ListViewsResponse>()
                    .withOperationName("ListViews").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listViewsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListViewsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for resources and displays details about all resources that match the specified criteria. You must
     * specify a query string.
     * </p>
     * <p>
     * All search queries must use a view. If you don't explicitly specify a view, then Amazon Web Services Resource
     * Explorer uses the default view for the Amazon Web Services Region in which you call this operation. The results
     * are the logical intersection of the results that match both the <code>QueryString</code> parameter supplied to
     * this operation and the <code>SearchFilter</code> parameter attached to the view.
     * </p>
     * <p>
     * For the complete syntax supported by the <code>QueryString</code> parameter, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/APIReference/about-query-syntax.html">Search query
     * syntax reference for Resource Explorer</a>.
     * </p>
     * <p>
     * If your search results are empty, or are missing results that you think should be there, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/troubleshooting_search.html">Troubleshooting
     * Resource Explorer search</a>.
     * </p>
     *
     * @param searchRequest
     * @return Result of the Search operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.Search
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/Search" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchResponse search(SearchRequest searchRequest) throws ResourceNotFoundException, InternalServerException,
            ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException, AwsServiceException,
            SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "Search");

            return clientHandler.execute(new ClientExecutionParams<SearchRequest, SearchResponse>().withOperationName("Search")
                    .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(searchRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds one or more tag key and value pairs to an Amazon Web Services Resource Explorer view or index.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         If you attempted to create a view, then the request failed because either you specified parameters that
     *         didn’t match the original request, or you attempted to create a view with a name that already exists in
     *         this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ValidationException, ConflictException, UnauthorizedException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tag key and value pairs from an Amazon Web Services Resource Explorer view or index.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, UnauthorizedException, ThrottlingException, AccessDeniedException,
            AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the type of the index from one of the following types to the other. For more information about indexes
     * and the role they perform in Amazon Web Services Resource Explorer, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a> in the <i>Amazon Web Services Resource Explorer User
     * Guide</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>AGGREGATOR</code> index type</b>
     * </p>
     * <p>
     * The index contains information about resources from all Amazon Web Services Regions in the Amazon Web Services
     * account in which you've created a Resource Explorer index. Resource information from all other Regions is
     * replicated to this Region's index.
     * </p>
     * <p>
     * When you change the index type to <code>AGGREGATOR</code>, Resource Explorer turns on replication of all
     * discovered resource information from the other Amazon Web Services Regions in your account to this index. You can
     * then, from this Region only, perform resource search queries that span all Amazon Web Services Regions in the
     * Amazon Web Services account. Turning on replication from all other Regions is performed by asynchronous
     * background tasks. You can check the status of the asynchronous tasks by using the <a>GetIndex</a> operation. When
     * the asynchronous tasks complete, the <code>Status</code> response of that operation changes from
     * <code>UPDATING</code> to <code>ACTIVE</code>. After that, you can start to see results from other Amazon Web
     * Services Regions in query results. However, it can take several hours for replication from all other Regions to
     * complete.
     * </p>
     * <important>
     * <p>
     * You can have only one aggregator index per Amazon Web Services account. Before you can promote a different index
     * to be the aggregator index for the account, you must first demote the existing aggregator index to type
     * <code>LOCAL</code>.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b> <code>LOCAL</code> index type</b>
     * </p>
     * <p>
     * The index contains information about resources in only the Amazon Web Services Region in which the index exists.
     * If an aggregator index in another Region exists, then information in this local index is replicated to the
     * aggregator index.
     * </p>
     * <p>
     * When you change the index type to <code>LOCAL</code>, Resource Explorer turns off the replication of resource
     * information from all other Amazon Web Services Regions in the Amazon Web Services account to this Region. The
     * aggregator index remains in the <code>UPDATING</code> state until all replication with other Regions successfully
     * stops. You can check the status of the asynchronous task by using the <a>GetIndex</a> operation. When Resource
     * Explorer successfully stops all replication with other Regions, the <code>Status</code> response of that
     * operation changes from <code>UPDATING</code> to <code>ACTIVE</code>. Separately, the resource information from
     * other Regions that was previously stored in the index is deleted within 30 days by another background task. Until
     * that asynchronous task completes, some results from other Regions can continue to appear in search results.
     * </p>
     * <important>
     * <p>
     * After you demote an aggregator index to a local index, you must wait 24 hours before you can promote another
     * index to be the new aggregator index for the account.
     * </p>
     * </important></li>
     * </ul>
     *
     * @param updateIndexTypeRequest
     * @return Result of the UpdateIndexType operation returned by the service.
     * @throws ResourceNotFoundException
     *         You specified a resource that doesn't exist. Check the ID or ARN that you used to identity the resource,
     *         and try again.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ConflictException
     *         If you attempted to create a view, then the request failed because either you specified parameters that
     *         didn’t match the original request, or you attempted to create a view with a name that already exists in
     *         this Amazon Web Services Region.</p>
     *         <p>
     *         If you attempted to create an index, then the request failed because either you specified parameters that
     *         didn't match the original request, or an index already exists in the current Amazon Web Services Region.
     *         </p>
     *         <p>
     *         If you attempted to update an index type to <code>AGGREGATOR</code>, then the request failed because you
     *         already have an <code>AGGREGATOR</code> index in a different Amazon Web Services Region.
     * @throws ServiceQuotaExceededException
     *         The request failed because it exceeds a service quota.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.UpdateIndexType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateIndexType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateIndexTypeResponse updateIndexType(UpdateIndexTypeRequest updateIndexTypeRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ConflictException,
            ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException,
            ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIndexTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateIndexTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIndexTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIndexTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIndexType");

            return clientHandler.execute(new ClientExecutionParams<UpdateIndexTypeRequest, UpdateIndexTypeResponse>()
                    .withOperationName("UpdateIndexType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateIndexTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateIndexTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies some of the details of a view. You can change the filter string and the list of included properties. You
     * can't change the name of the view.
     * </p>
     *
     * @param updateViewRequest
     * @return Result of the UpdateView operation returned by the service.
     * @throws InternalServerException
     *         The request failed because of internal service error. Try your request again later.
     * @throws ValidationException
     *         You provided an invalid value for one of the operation's parameters. Check the syntax for the operation,
     *         and try again.
     * @throws ServiceQuotaExceededException
     *         The request failed because it exceeds a service quota.
     * @throws UnauthorizedException
     *         The principal making the request isn't permitted to perform the operation.
     * @throws ThrottlingException
     *         The request failed because you exceeded a rate limit for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/quotas.html">Quotas for Resource
     *         Explorer</a>.
     * @throws AccessDeniedException
     *         The credentials that you used to call this operation don't have the minimum required permissions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ResourceExplorer2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ResourceExplorer2Client.UpdateView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/resource-explorer-2-2022-07-28/UpdateView"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateViewResponse updateView(UpdateViewRequest updateViewRequest) throws InternalServerException,
            ValidationException, ServiceQuotaExceededException, UnauthorizedException, ThrottlingException,
            AccessDeniedException, AwsServiceException, SdkClientException, ResourceExplorer2Exception {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateViewResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateViewResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateViewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateViewRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Resource Explorer 2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateView");

            return clientHandler.execute(new ClientExecutionParams<UpdateViewRequest, UpdateViewResponse>()
                    .withOperationName("UpdateView").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateViewRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateViewRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ResourceExplorer2ServiceClientConfigurationBuilder serviceConfigBuilder = new ResourceExplorer2ServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ResourceExplorer2Exception::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build());
    }

    @Override
    public final ResourceExplorer2ServiceClientConfiguration serviceClientConfiguration() {
        return new ResourceExplorer2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
