/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSupportedResourceTypesResponse extends ResourceExplorer2Response implements
        ToCopyableBuilder<ListSupportedResourceTypesResponse.Builder, ListSupportedResourceTypesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSupportedResourceTypesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<SupportedResourceType>> RESOURCE_TYPES_FIELD = SdkField
            .<List<SupportedResourceType>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(ListSupportedResourceTypesResponse::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SupportedResourceType> builder(MarshallingType.SDK_POJO)
                                            .constructor(SupportedResourceType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESOURCE_TYPES_FIELD));

    private final String nextToken;

    private final List<SupportedResourceType> resourceTypes;

    private ListSupportedResourceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resourceTypes = builder.resourceTypes;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * The pagination tokens expire after 24 hours.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>. The pagination tokens expire after 24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resource types supported by Resource Explorer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The list of resource types supported by Resource Explorer.
     */
    public final List<SupportedResourceType> resourceTypes() {
        return resourceTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSupportedResourceTypesResponse)) {
            return false;
        }
        ListSupportedResourceTypesResponse other = (ListSupportedResourceTypesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasResourceTypes() == other.hasResourceTypes()
                && Objects.equals(resourceTypes(), other.resourceTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSupportedResourceTypesResponse").add("NextToken", nextToken())
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSupportedResourceTypesResponse, T> g) {
        return obj -> g.apply((ListSupportedResourceTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceExplorer2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSupportedResourceTypesResponse> {
        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>. The pagination tokens expire after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>. The pagination tokens expire after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of resource types supported by Resource Explorer.
         * </p>
         * 
         * @param resourceTypes
         *        The list of resource types supported by Resource Explorer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<SupportedResourceType> resourceTypes);

        /**
         * <p>
         * The list of resource types supported by Resource Explorer.
         * </p>
         * 
         * @param resourceTypes
         *        The list of resource types supported by Resource Explorer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(SupportedResourceType... resourceTypes);

        /**
         * <p>
         * The list of resource types supported by Resource Explorer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.SupportedResourceType.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.SupportedResourceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.SupportedResourceType.Builder#build()} is
         * called immediately and its result is passed to {@link #resourceTypes(List<SupportedResourceType>)}.
         * 
         * @param resourceTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourceexplorer2.model.SupportedResourceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTypes(java.util.Collection<SupportedResourceType>)
         */
        Builder resourceTypes(Consumer<SupportedResourceType.Builder>... resourceTypes);
    }

    static final class BuilderImpl extends ResourceExplorer2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<SupportedResourceType> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSupportedResourceTypesResponse model) {
            super(model);
            nextToken(model.nextToken);
            resourceTypes(model.resourceTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SupportedResourceType.Builder> getResourceTypes() {
            List<SupportedResourceType.Builder> result = ResourceTypeListCopier.copyToBuilder(this.resourceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTypes(Collection<SupportedResourceType.BuilderImpl> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copyFromBuilder(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<SupportedResourceType> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(SupportedResourceType... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(Consumer<SupportedResourceType.Builder>... resourceTypes) {
            resourceTypes(Stream.of(resourceTypes).map(c -> SupportedResourceType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSupportedResourceTypesResponse build() {
            return new ListSupportedResourceTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
