/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An index is the data store used by Amazon Web Services Resource Explorer to hold information about your Amazon Web
 * Services resources that the service discovers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberIndex implements SdkPojo, Serializable, ToCopyableBuilder<MemberIndex.Builder, MemberIndex> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(MemberIndex::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(MemberIndex::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(MemberIndex::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(MemberIndex::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ARN_FIELD,
            REGION_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String arn;

    private final String region;

    private final String type;

    private MemberIndex(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.arn = builder.arn;
        this.region = builder.region;
        this.type = builder.type;
    }

    /**
     * <p>
     * The account ID for the index.
     * </p>
     * 
     * @return The account ID for the index.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
     * (ARN)</a> of the index.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     *         name (ARN)</a> of the index.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Web Services Region in which the index exists.
     * </p>
     * 
     * @return The Amazon Web Services Region in which the index exists.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The type of index. It can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LOCAL</code> – The index contains information about resources from only the same Amazon Web Services
     * Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AGGREGATOR</code> – Resource Explorer replicates copies of the indexed information about resources in all
     * other Amazon Web Services Regions to the aggregator index. This lets search results in the Region with the
     * aggregator index to include resources from all Regions in the account where Resource Explorer is turned on.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IndexType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of index. It can be one of the following values: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LOCAL</code> – The index contains information about resources from only the same Amazon Web
     *         Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AGGREGATOR</code> – Resource Explorer replicates copies of the indexed information about resources
     *         in all other Amazon Web Services Regions to the aggregator index. This lets search results in the Region
     *         with the aggregator index to include resources from all Regions in the account where Resource Explorer is
     *         turned on.
     *         </p>
     *         </li>
     * @see IndexType
     */
    public final IndexType type() {
        return IndexType.fromValue(type);
    }

    /**
     * <p>
     * The type of index. It can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LOCAL</code> – The index contains information about resources from only the same Amazon Web Services
     * Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AGGREGATOR</code> – Resource Explorer replicates copies of the indexed information about resources in all
     * other Amazon Web Services Regions to the aggregator index. This lets search results in the Region with the
     * aggregator index to include resources from all Regions in the account where Resource Explorer is turned on.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IndexType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of index. It can be one of the following values: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LOCAL</code> – The index contains information about resources from only the same Amazon Web
     *         Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AGGREGATOR</code> – Resource Explorer replicates copies of the indexed information about resources
     *         in all other Amazon Web Services Regions to the aggregator index. This lets search results in the Region
     *         with the aggregator index to include resources from all Regions in the account where Resource Explorer is
     *         turned on.
     *         </p>
     *         </li>
     * @see IndexType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberIndex)) {
            return false;
        }
        MemberIndex other = (MemberIndex) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(region(), other.region()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberIndex").add("AccountId", accountId()).add("Arn", arn()).add("Region", region())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberIndex, T> g) {
        return obj -> g.apply((MemberIndex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberIndex> {
        /**
         * <p>
         * The account ID for the index.
         * </p>
         * 
         * @param accountId
         *        The account ID for the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
         * (ARN)</a> of the index.
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        resource name (ARN)</a> of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Web Services Region in which the index exists.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region in which the index exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The type of index. It can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LOCAL</code> – The index contains information about resources from only the same Amazon Web Services
         * Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AGGREGATOR</code> – Resource Explorer replicates copies of the indexed information about resources in
         * all other Amazon Web Services Regions to the aggregator index. This lets search results in the Region with
         * the aggregator index to include resources from all Regions in the account where Resource Explorer is turned
         * on.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of index. It can be one of the following values: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LOCAL</code> – The index contains information about resources from only the same Amazon Web
         *        Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AGGREGATOR</code> – Resource Explorer replicates copies of the indexed information about
         *        resources in all other Amazon Web Services Regions to the aggregator index. This lets search results
         *        in the Region with the aggregator index to include resources from all Regions in the account where
         *        Resource Explorer is turned on.
         *        </p>
         *        </li>
         * @see IndexType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of index. It can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LOCAL</code> – The index contains information about resources from only the same Amazon Web Services
         * Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AGGREGATOR</code> – Resource Explorer replicates copies of the indexed information about resources in
         * all other Amazon Web Services Regions to the aggregator index. This lets search results in the Region with
         * the aggregator index to include resources from all Regions in the account where Resource Explorer is turned
         * on.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of index. It can be one of the following values: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LOCAL</code> – The index contains information about resources from only the same Amazon Web
         *        Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AGGREGATOR</code> – Resource Explorer replicates copies of the indexed information about
         *        resources in all other Amazon Web Services Regions to the aggregator index. This lets search results
         *        in the Region with the aggregator index to include resources from all Regions in the account where
         *        Resource Explorer is turned on.
         *        </p>
         *        </li>
         * @see IndexType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexType
         */
        Builder type(IndexType type);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String arn;

        private String region;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberIndex model) {
            accountId(model.accountId);
            arn(model.arn);
            region(model.region);
            type(model.type);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IndexType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public MemberIndex build() {
            return new MemberIndex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
