/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is a structure that contains the status of Amazon Web Services service access, and whether you have a valid
 * service-linked role to enable multi-account search for your organization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrgConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OrgConfiguration.Builder, OrgConfiguration> {
    private static final SdkField<String> AWS_SERVICE_ACCESS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AWSServiceAccessStatus").getter(getter(OrgConfiguration::awsServiceAccessStatusAsString))
            .setter(setter(Builder::awsServiceAccessStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSServiceAccessStatus").build())
            .build();

    private static final SdkField<String> SERVICE_LINKED_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceLinkedRole").getter(getter(OrgConfiguration::serviceLinkedRole))
            .setter(setter(Builder::serviceLinkedRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkedRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AWS_SERVICE_ACCESS_STATUS_FIELD, SERVICE_LINKED_ROLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String awsServiceAccessStatus;

    private final String serviceLinkedRole;

    private OrgConfiguration(BuilderImpl builder) {
        this.awsServiceAccessStatus = builder.awsServiceAccessStatus;
        this.serviceLinkedRole = builder.serviceLinkedRole;
    }

    /**
     * <p>
     * This value displays whether your Amazon Web Services service access is <code>ENABLED</code> or
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #awsServiceAccessStatus} will return {@link AWSServiceAccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #awsServiceAccessStatusAsString}.
     * </p>
     * 
     * @return This value displays whether your Amazon Web Services service access is <code>ENABLED</code> or
     *         <code>DISABLED</code>.
     * @see AWSServiceAccessStatus
     */
    public final AWSServiceAccessStatus awsServiceAccessStatus() {
        return AWSServiceAccessStatus.fromValue(awsServiceAccessStatus);
    }

    /**
     * <p>
     * This value displays whether your Amazon Web Services service access is <code>ENABLED</code> or
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #awsServiceAccessStatus} will return {@link AWSServiceAccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #awsServiceAccessStatusAsString}.
     * </p>
     * 
     * @return This value displays whether your Amazon Web Services service access is <code>ENABLED</code> or
     *         <code>DISABLED</code>.
     * @see AWSServiceAccessStatus
     */
    public final String awsServiceAccessStatusAsString() {
        return awsServiceAccessStatus;
    }

    /**
     * <p>
     * This value shows whether or not you have a valid a service-linked role required to start the multi-account search
     * feature.
     * </p>
     * 
     * @return This value shows whether or not you have a valid a service-linked role required to start the
     *         multi-account search feature.
     */
    public final String serviceLinkedRole() {
        return serviceLinkedRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsServiceAccessStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceLinkedRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrgConfiguration)) {
            return false;
        }
        OrgConfiguration other = (OrgConfiguration) obj;
        return Objects.equals(awsServiceAccessStatusAsString(), other.awsServiceAccessStatusAsString())
                && Objects.equals(serviceLinkedRole(), other.serviceLinkedRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrgConfiguration").add("AWSServiceAccessStatus", awsServiceAccessStatusAsString())
                .add("ServiceLinkedRole", serviceLinkedRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AWSServiceAccessStatus":
            return Optional.ofNullable(clazz.cast(awsServiceAccessStatusAsString()));
        case "ServiceLinkedRole":
            return Optional.ofNullable(clazz.cast(serviceLinkedRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrgConfiguration, T> g) {
        return obj -> g.apply((OrgConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrgConfiguration> {
        /**
         * <p>
         * This value displays whether your Amazon Web Services service access is <code>ENABLED</code> or
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param awsServiceAccessStatus
         *        This value displays whether your Amazon Web Services service access is <code>ENABLED</code> or
         *        <code>DISABLED</code>.
         * @see AWSServiceAccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AWSServiceAccessStatus
         */
        Builder awsServiceAccessStatus(String awsServiceAccessStatus);

        /**
         * <p>
         * This value displays whether your Amazon Web Services service access is <code>ENABLED</code> or
         * <code>DISABLED</code>.
         * </p>
         * 
         * @param awsServiceAccessStatus
         *        This value displays whether your Amazon Web Services service access is <code>ENABLED</code> or
         *        <code>DISABLED</code>.
         * @see AWSServiceAccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AWSServiceAccessStatus
         */
        Builder awsServiceAccessStatus(AWSServiceAccessStatus awsServiceAccessStatus);

        /**
         * <p>
         * This value shows whether or not you have a valid a service-linked role required to start the multi-account
         * search feature.
         * </p>
         * 
         * @param serviceLinkedRole
         *        This value shows whether or not you have a valid a service-linked role required to start the
         *        multi-account search feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceLinkedRole(String serviceLinkedRole);
    }

    static final class BuilderImpl implements Builder {
        private String awsServiceAccessStatus;

        private String serviceLinkedRole;

        private BuilderImpl() {
        }

        private BuilderImpl(OrgConfiguration model) {
            awsServiceAccessStatus(model.awsServiceAccessStatus);
            serviceLinkedRole(model.serviceLinkedRole);
        }

        public final String getAwsServiceAccessStatus() {
            return awsServiceAccessStatus;
        }

        public final void setAwsServiceAccessStatus(String awsServiceAccessStatus) {
            this.awsServiceAccessStatus = awsServiceAccessStatus;
        }

        @Override
        public final Builder awsServiceAccessStatus(String awsServiceAccessStatus) {
            this.awsServiceAccessStatus = awsServiceAccessStatus;
            return this;
        }

        @Override
        public final Builder awsServiceAccessStatus(AWSServiceAccessStatus awsServiceAccessStatus) {
            this.awsServiceAccessStatus(awsServiceAccessStatus == null ? null : awsServiceAccessStatus.toString());
            return this;
        }

        public final String getServiceLinkedRole() {
            return serviceLinkedRole;
        }

        public final void setServiceLinkedRole(String serviceLinkedRole) {
            this.serviceLinkedRole = serviceLinkedRole;
        }

        @Override
        public final Builder serviceLinkedRole(String serviceLinkedRole) {
            this.serviceLinkedRole = serviceLinkedRole;
            return this;
        }

        @Override
        public OrgConfiguration build() {
            return new OrgConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
