/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIndexResponse extends ResourceExplorer2Response implements
        ToCopyableBuilder<GetIndexResponse.Builder, GetIndexResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetIndexResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(GetIndexResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt")
            .getter(getter(GetIndexResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<String>> REPLICATING_FROM_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReplicatingFrom")
            .getter(getter(GetIndexResponse::replicatingFrom))
            .setter(setter(Builder::replicatingFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicatingFrom").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REPLICATING_TO_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReplicatingTo")
            .getter(getter(GetIndexResponse::replicatingTo))
            .setter(setter(Builder::replicatingTo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicatingTo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(GetIndexResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetIndexResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetIndexResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD, REPLICATING_FROM_FIELD, REPLICATING_TO_FIELD, STATE_FIELD, TAGS_FIELD, TYPE_FIELD));

    private final String arn;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final List<String> replicatingFrom;

    private final List<String> replicatingTo;

    private final String state;

    private final Map<String, String> tags;

    private final String type;

    private GetIndexResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.replicatingFrom = builder.replicatingFrom;
        this.replicatingTo = builder.replicatingTo;
        this.state = builder.state;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
     * (ARN)</a> of the index.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     *         name (ARN)</a> of the index.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time when the index was originally created.
     * </p>
     * 
     * @return The date and time when the index was originally created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time when the index was last updated.
     * </p>
     * 
     * @return The date and time when the index was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicatingFrom property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicatingFrom() {
        return replicatingFrom != null && !(replicatingFrom instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This response value is present only if this index is <code>Type=AGGREGATOR</code>.
     * </p>
     * <p>
     * A list of the Amazon Web Services Regions that replicate their content to the index in this Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicatingFrom} method.
     * </p>
     * 
     * @return This response value is present only if this index is <code>Type=AGGREGATOR</code>.</p>
     *         <p>
     *         A list of the Amazon Web Services Regions that replicate their content to the index in this Region.
     */
    public final List<String> replicatingFrom() {
        return replicatingFrom;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicatingTo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicatingTo() {
        return replicatingTo != null && !(replicatingTo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This response value is present only if this index is <code>Type=LOCAL</code>.
     * </p>
     * <p>
     * The Amazon Web Services Region that contains the aggregator index, if one exists. If an aggregator index does
     * exist then the Region in which you called this operation replicates its index information to the Region specified
     * in this response value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicatingTo} method.
     * </p>
     * 
     * @return This response value is present only if this index is <code>Type=LOCAL</code>.</p>
     *         <p>
     *         The Amazon Web Services Region that contains the aggregator index, if one exists. If an aggregator index
     *         does exist then the Region in which you called this operation replicates its index information to the
     *         Region specified in this response value.
     */
    public final List<String> replicatingTo() {
        return replicatingTo;
    }

    /**
     * <p>
     * The current state of the index in this Amazon Web Services Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IndexState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the index in this Amazon Web Services Region.
     * @see IndexState
     */
    public final IndexState state() {
        return IndexState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the index in this Amazon Web Services Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link IndexState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the index in this Amazon Web Services Region.
     * @see IndexState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tag key and value pairs that are attached to the index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tag key and value pairs that are attached to the index.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of the index in this Region. For information about the aggregator index and how it differs from a local
     * index, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IndexType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the index in this Region. For information about the aggregator index and how it differs from
     *         a local index, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html"
     *         >Turning on cross-Region search by creating an aggregator index</a>.
     * @see IndexType
     */
    public final IndexType type() {
        return IndexType.fromValue(type);
    }

    /**
     * <p>
     * The type of the index in this Region. For information about the aggregator index and how it differs from a local
     * index, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning on
     * cross-Region search by creating an aggregator index</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IndexType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the index in this Region. For information about the aggregator index and how it differs from
     *         a local index, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html"
     *         >Turning on cross-Region search by creating an aggregator index</a>.
     * @see IndexType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicatingFrom() ? replicatingFrom() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicatingTo() ? replicatingTo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIndexResponse)) {
            return false;
        }
        GetIndexResponse other = (GetIndexResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && hasReplicatingFrom() == other.hasReplicatingFrom()
                && Objects.equals(replicatingFrom(), other.replicatingFrom()) && hasReplicatingTo() == other.hasReplicatingTo()
                && Objects.equals(replicatingTo(), other.replicatingTo())
                && Objects.equals(stateAsString(), other.stateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIndexResponse").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("ReplicatingFrom", hasReplicatingFrom() ? replicatingFrom() : null)
                .add("ReplicatingTo", hasReplicatingTo() ? replicatingTo() : null).add("State", stateAsString())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "ReplicatingFrom":
            return Optional.ofNullable(clazz.cast(replicatingFrom()));
        case "ReplicatingTo":
            return Optional.ofNullable(clazz.cast(replicatingTo()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIndexResponse, T> g) {
        return obj -> g.apply((GetIndexResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceExplorer2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetIndexResponse> {
        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
         * (ARN)</a> of the index.
         * </p>
         * 
         * @param arn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        resource name (ARN)</a> of the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time when the index was originally created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the index was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time when the index was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time when the index was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * This response value is present only if this index is <code>Type=AGGREGATOR</code>.
         * </p>
         * <p>
         * A list of the Amazon Web Services Regions that replicate their content to the index in this Region.
         * </p>
         * 
         * @param replicatingFrom
         *        This response value is present only if this index is <code>Type=AGGREGATOR</code>.</p>
         *        <p>
         *        A list of the Amazon Web Services Regions that replicate their content to the index in this Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatingFrom(Collection<String> replicatingFrom);

        /**
         * <p>
         * This response value is present only if this index is <code>Type=AGGREGATOR</code>.
         * </p>
         * <p>
         * A list of the Amazon Web Services Regions that replicate their content to the index in this Region.
         * </p>
         * 
         * @param replicatingFrom
         *        This response value is present only if this index is <code>Type=AGGREGATOR</code>.</p>
         *        <p>
         *        A list of the Amazon Web Services Regions that replicate their content to the index in this Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatingFrom(String... replicatingFrom);

        /**
         * <p>
         * This response value is present only if this index is <code>Type=LOCAL</code>.
         * </p>
         * <p>
         * The Amazon Web Services Region that contains the aggregator index, if one exists. If an aggregator index does
         * exist then the Region in which you called this operation replicates its index information to the Region
         * specified in this response value.
         * </p>
         * 
         * @param replicatingTo
         *        This response value is present only if this index is <code>Type=LOCAL</code>.</p>
         *        <p>
         *        The Amazon Web Services Region that contains the aggregator index, if one exists. If an aggregator
         *        index does exist then the Region in which you called this operation replicates its index information
         *        to the Region specified in this response value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatingTo(Collection<String> replicatingTo);

        /**
         * <p>
         * This response value is present only if this index is <code>Type=LOCAL</code>.
         * </p>
         * <p>
         * The Amazon Web Services Region that contains the aggregator index, if one exists. If an aggregator index does
         * exist then the Region in which you called this operation replicates its index information to the Region
         * specified in this response value.
         * </p>
         * 
         * @param replicatingTo
         *        This response value is present only if this index is <code>Type=LOCAL</code>.</p>
         *        <p>
         *        The Amazon Web Services Region that contains the aggregator index, if one exists. If an aggregator
         *        index does exist then the Region in which you called this operation replicates its index information
         *        to the Region specified in this response value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatingTo(String... replicatingTo);

        /**
         * <p>
         * The current state of the index in this Amazon Web Services Region.
         * </p>
         * 
         * @param state
         *        The current state of the index in this Amazon Web Services Region.
         * @see IndexState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the index in this Amazon Web Services Region.
         * </p>
         * 
         * @param state
         *        The current state of the index in this Amazon Web Services Region.
         * @see IndexState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexState
         */
        Builder state(IndexState state);

        /**
         * <p>
         * Tag key and value pairs that are attached to the index.
         * </p>
         * 
         * @param tags
         *        Tag key and value pairs that are attached to the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of the index in this Region. For information about the aggregator index and how it differs from a
         * local index, see <a
         * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning
         * on cross-Region search by creating an aggregator index</a>.
         * </p>
         * 
         * @param type
         *        The type of the index in this Region. For information about the aggregator index and how it differs
         *        from a local index, see <a
         *        href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html"
         *        >Turning on cross-Region search by creating an aggregator index</a>.
         * @see IndexType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the index in this Region. For information about the aggregator index and how it differs from a
         * local index, see <a
         * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html">Turning
         * on cross-Region search by creating an aggregator index</a>.
         * </p>
         * 
         * @param type
         *        The type of the index in this Region. For information about the aggregator index and how it differs
         *        from a local index, see <a
         *        href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html"
         *        >Turning on cross-Region search by creating an aggregator index</a>.
         * @see IndexType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexType
         */
        Builder type(IndexType type);
    }

    static final class BuilderImpl extends ResourceExplorer2Response.BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private List<String> replicatingFrom = DefaultSdkAutoConstructList.getInstance();

        private List<String> replicatingTo = DefaultSdkAutoConstructList.getInstance();

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIndexResponse model) {
            super(model);
            arn(model.arn);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            replicatingFrom(model.replicatingFrom);
            replicatingTo(model.replicatingTo);
            state(model.state);
            tags(model.tags);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Collection<String> getReplicatingFrom() {
            if (replicatingFrom instanceof SdkAutoConstructList) {
                return null;
            }
            return replicatingFrom;
        }

        public final void setReplicatingFrom(Collection<String> replicatingFrom) {
            this.replicatingFrom = RegionListCopier.copy(replicatingFrom);
        }

        @Override
        public final Builder replicatingFrom(Collection<String> replicatingFrom) {
            this.replicatingFrom = RegionListCopier.copy(replicatingFrom);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatingFrom(String... replicatingFrom) {
            replicatingFrom(Arrays.asList(replicatingFrom));
            return this;
        }

        public final Collection<String> getReplicatingTo() {
            if (replicatingTo instanceof SdkAutoConstructList) {
                return null;
            }
            return replicatingTo;
        }

        public final void setReplicatingTo(Collection<String> replicatingTo) {
            this.replicatingTo = RegionListCopier.copy(replicatingTo);
        }

        @Override
        public final Builder replicatingTo(Collection<String> replicatingTo) {
            this.replicatingTo = RegionListCopier.copy(replicatingTo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatingTo(String... replicatingTo) {
            replicatingTo(Arrays.asList(replicatingTo));
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IndexState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IndexType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetIndexResponse build() {
            return new GetIndexResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
