/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.ResourceGroupsTaggingApiClient;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetResourcesRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetResourcesResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceTagMapping;

public class GetResourcesIterable
implements SdkIterable<GetResourcesResponse> {
    private final ResourceGroupsTaggingApiClient client;
    private final GetResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetResourcesIterable(ResourceGroupsTaggingApiClient client, GetResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetResourcesResponseFetcher();
    }

    public Iterator<GetResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceTagMapping> resourceTagMappingList() {
        Function<GetResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceTagMappingList() != null) {
                return response.resourceTagMappingList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetResourcesResponseFetcher
    implements SyncPageFetcher<GetResourcesResponse> {
        private GetResourcesResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.paginationToken());
        }

        public GetResourcesResponse nextPage(GetResourcesResponse previousPage) {
            if (previousPage == null) {
                return GetResourcesIterable.this.client.getResources(GetResourcesIterable.this.firstRequest);
            }
            return GetResourcesIterable.this.client.getResources((GetResourcesRequest)((Object)GetResourcesIterable.this.firstRequest.toBuilder().paginationToken(previousPage.paginationToken()).build()));
        }
    }
}

