/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.ResourceGroupsTaggingApiClient;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagValuesRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagValuesResponse;

public class GetTagValuesIterable
implements SdkIterable<GetTagValuesResponse> {
    private final ResourceGroupsTaggingApiClient client;
    private final GetTagValuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTagValuesIterable(ResourceGroupsTaggingApiClient client, GetTagValuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTagValuesResponseFetcher();
    }

    public Iterator<GetTagValuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> tagValues() {
        Function<GetTagValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tagValues() != null) {
                return response.tagValues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetTagValuesResponseFetcher
    implements SyncPageFetcher<GetTagValuesResponse> {
        private GetTagValuesResponseFetcher() {
        }

        public boolean hasNextPage(GetTagValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.paginationToken());
        }

        public GetTagValuesResponse nextPage(GetTagValuesResponse previousPage) {
            if (previousPage == null) {
                return GetTagValuesIterable.this.client.getTagValues(GetTagValuesIterable.this.firstRequest);
            }
            return GetTagValuesIterable.this.client.getTagValues((GetTagValuesRequest)((Object)GetTagValuesIterable.this.firstRequest.toBuilder().paginationToken(previousPage.paginationToken()).build()));
        }
    }
}

