/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of resource ARNs and the tags (keys and values) that are associated with each.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceTagMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceTagMapping.Builder, ResourceTagMapping> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceARN").getter(getter(ResourceTagMapping::resourceARN)).setter(setter(Builder::resourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ResourceTagMapping::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ComplianceDetails> COMPLIANCE_DETAILS_FIELD = SdkField
            .<ComplianceDetails> builder(MarshallingType.SDK_POJO).memberName("ComplianceDetails")
            .getter(getter(ResourceTagMapping::complianceDetails)).setter(setter(Builder::complianceDetails))
            .constructor(ComplianceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            TAGS_FIELD, COMPLIANCE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceARN;

    private final List<Tag> tags;

    private final ComplianceDetails complianceDetails;

    private ResourceTagMapping(BuilderImpl builder) {
        this.resourceARN = builder.resourceARN;
        this.tags = builder.tags;
        this.complianceDetails = builder.complianceDetails;
    }

    /**
     * <p>
     * The ARN of the resource.
     * </p>
     * 
     * @return The ARN of the resource.
     */
    public final String resourceARN() {
        return resourceARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags that have been applied to one or more Amazon Web Services resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags that have been applied to one or more Amazon Web Services resources.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Information that shows whether a resource is compliant with the effective tag policy, including details on any
     * noncompliant tag keys.
     * </p>
     * 
     * @return Information that shows whether a resource is compliant with the effective tag policy, including details
     *         on any noncompliant tag keys.
     */
    public final ComplianceDetails complianceDetails() {
        return complianceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(complianceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTagMapping)) {
            return false;
        }
        ResourceTagMapping other = (ResourceTagMapping) obj;
        return Objects.equals(resourceARN(), other.resourceARN()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(complianceDetails(), other.complianceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceTagMapping").add("ResourceARN", resourceARN()).add("Tags", hasTags() ? tags() : null)
                .add("ComplianceDetails", complianceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceARN":
            return Optional.ofNullable(clazz.cast(resourceARN()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ComplianceDetails":
            return Optional.ofNullable(clazz.cast(complianceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceTagMapping, T> g) {
        return obj -> g.apply((ResourceTagMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceTagMapping> {
        /**
         * <p>
         * The ARN of the resource.
         * </p>
         * 
         * @param resourceARN
         *        The ARN of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARN(String resourceARN);

        /**
         * <p>
         * The tags that have been applied to one or more Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        The tags that have been applied to one or more Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags that have been applied to one or more Amazon Web Services resources.
         * </p>
         * 
         * @param tags
         *        The tags that have been applied to one or more Amazon Web Services resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags that have been applied to one or more Amazon Web Services resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.Tag.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.Tag.Builder#build()} is called
         * immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Information that shows whether a resource is compliant with the effective tag policy, including details on
         * any noncompliant tag keys.
         * </p>
         * 
         * @param complianceDetails
         *        Information that shows whether a resource is compliant with the effective tag policy, including
         *        details on any noncompliant tag keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceDetails(ComplianceDetails complianceDetails);

        /**
         * <p>
         * Information that shows whether a resource is compliant with the effective tag policy, including details on
         * any noncompliant tag keys.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComplianceDetails.Builder} avoiding the
         * need to create one manually via {@link ComplianceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComplianceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #complianceDetails(ComplianceDetails)}.
         * 
         * @param complianceDetails
         *        a consumer that will call methods on {@link ComplianceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceDetails(ComplianceDetails)
         */
        default Builder complianceDetails(Consumer<ComplianceDetails.Builder> complianceDetails) {
            return complianceDetails(ComplianceDetails.builder().applyMutation(complianceDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resourceARN;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ComplianceDetails complianceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTagMapping model) {
            resourceARN(model.resourceARN);
            tags(model.tags);
            complianceDetails(model.complianceDetails);
        }

        public final String getResourceARN() {
            return resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ComplianceDetails.Builder getComplianceDetails() {
            return complianceDetails != null ? complianceDetails.toBuilder() : null;
        }

        public final void setComplianceDetails(ComplianceDetails.BuilderImpl complianceDetails) {
            this.complianceDetails = complianceDetails != null ? complianceDetails.build() : null;
        }

        @Override
        public final Builder complianceDetails(ComplianceDetails complianceDetails) {
            this.complianceDetails = complianceDetails;
            return this;
        }

        @Override
        public ResourceTagMapping build() {
            return new ResourceTagMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
