/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceARNListForGetCopier;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceGroupsTaggingApiRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceTypeFilterListCopier;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagFilter;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcesRequest
extends ResourceGroupsTaggingApiRequest
implements ToCopyableBuilder<Builder, GetResourcesRequest> {
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaginationToken").getter(GetResourcesRequest.getter(GetResourcesRequest::paginationToken)).setter(GetResourcesRequest.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final SdkField<List<TagFilter>> TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagFilters").getter(GetResourcesRequest.getter(GetResourcesRequest::tagFilters)).setter(GetResourcesRequest.setter(Builder::tagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> RESOURCES_PER_PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResourcesPerPage").getter(GetResourcesRequest.getter(GetResourcesRequest::resourcesPerPage)).setter(GetResourcesRequest.setter(Builder::resourcesPerPage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesPerPage").build()}).build();
    private static final SdkField<Integer> TAGS_PER_PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TagsPerPage").getter(GetResourcesRequest.getter(GetResourcesRequest::tagsPerPage)).setter(GetResourcesRequest.setter(Builder::tagsPerPage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsPerPage").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypeFilters").getter(GetResourcesRequest.getter(GetResourcesRequest::resourceTypeFilters)).setter(GetResourcesRequest.setter(Builder::resourceTypeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_COMPLIANCE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeComplianceDetails").getter(GetResourcesRequest.getter(GetResourcesRequest::includeComplianceDetails)).setter(GetResourcesRequest.setter(Builder::includeComplianceDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeComplianceDetails").build()}).build();
    private static final SdkField<Boolean> EXCLUDE_COMPLIANT_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExcludeCompliantResources").getter(GetResourcesRequest.getter(GetResourcesRequest::excludeCompliantResources)).setter(GetResourcesRequest.setter(Builder::excludeCompliantResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeCompliantResources").build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceARNList").getter(GetResourcesRequest.getter(GetResourcesRequest::resourceARNList)).setter(GetResourcesRequest.setter(Builder::resourceARNList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARNList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGINATION_TOKEN_FIELD, TAG_FILTERS_FIELD, RESOURCES_PER_PAGE_FIELD, TAGS_PER_PAGE_FIELD, RESOURCE_TYPE_FILTERS_FIELD, INCLUDE_COMPLIANCE_DETAILS_FIELD, EXCLUDE_COMPLIANT_RESOURCES_FIELD, RESOURCE_ARN_LIST_FIELD));
    private final String paginationToken;
    private final List<TagFilter> tagFilters;
    private final Integer resourcesPerPage;
    private final Integer tagsPerPage;
    private final List<String> resourceTypeFilters;
    private final Boolean includeComplianceDetails;
    private final Boolean excludeCompliantResources;
    private final List<String> resourceARNList;

    private GetResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.paginationToken = builder.paginationToken;
        this.tagFilters = builder.tagFilters;
        this.resourcesPerPage = builder.resourcesPerPage;
        this.tagsPerPage = builder.tagsPerPage;
        this.resourceTypeFilters = builder.resourceTypeFilters;
        this.includeComplianceDetails = builder.includeComplianceDetails;
        this.excludeCompliantResources = builder.excludeCompliantResources;
        this.resourceARNList = builder.resourceARNList;
    }

    public final String paginationToken() {
        return this.paginationToken;
    }

    public final boolean hasTagFilters() {
        return this.tagFilters != null && !(this.tagFilters instanceof SdkAutoConstructList);
    }

    public final List<TagFilter> tagFilters() {
        return this.tagFilters;
    }

    public final Integer resourcesPerPage() {
        return this.resourcesPerPage;
    }

    public final Integer tagsPerPage() {
        return this.tagsPerPage;
    }

    public final boolean hasResourceTypeFilters() {
        return this.resourceTypeFilters != null && !(this.resourceTypeFilters instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypeFilters() {
        return this.resourceTypeFilters;
    }

    public final Boolean includeComplianceDetails() {
        return this.includeComplianceDetails;
    }

    public final Boolean excludeCompliantResources() {
        return this.excludeCompliantResources;
    }

    public final boolean hasResourceARNList() {
        return this.resourceARNList != null && !(this.resourceARNList instanceof SdkAutoConstructList);
    }

    public final List<String> resourceARNList() {
        return this.resourceARNList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagFilters() ? this.tagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesPerPage());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagsPerPage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypeFilters() ? this.resourceTypeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeComplianceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludeCompliantResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceARNList() ? this.resourceARNList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesRequest)) {
            return false;
        }
        GetResourcesRequest other = (GetResourcesRequest)((Object)obj);
        return Objects.equals(this.paginationToken(), other.paginationToken()) && this.hasTagFilters() == other.hasTagFilters() && Objects.equals(this.tagFilters(), other.tagFilters()) && Objects.equals(this.resourcesPerPage(), other.resourcesPerPage()) && Objects.equals(this.tagsPerPage(), other.tagsPerPage()) && this.hasResourceTypeFilters() == other.hasResourceTypeFilters() && Objects.equals(this.resourceTypeFilters(), other.resourceTypeFilters()) && Objects.equals(this.includeComplianceDetails(), other.includeComplianceDetails()) && Objects.equals(this.excludeCompliantResources(), other.excludeCompliantResources()) && this.hasResourceARNList() == other.hasResourceARNList() && Objects.equals(this.resourceARNList(), other.resourceARNList());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcesRequest").add("PaginationToken", (Object)this.paginationToken()).add("TagFilters", this.hasTagFilters() ? this.tagFilters() : null).add("ResourcesPerPage", (Object)this.resourcesPerPage()).add("TagsPerPage", (Object)this.tagsPerPage()).add("ResourceTypeFilters", this.hasResourceTypeFilters() ? this.resourceTypeFilters() : null).add("IncludeComplianceDetails", (Object)this.includeComplianceDetails()).add("ExcludeCompliantResources", (Object)this.excludeCompliantResources()).add("ResourceARNList", this.hasResourceARNList() ? this.resourceARNList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
            case "TagFilters": {
                return Optional.ofNullable(clazz.cast(this.tagFilters()));
            }
            case "ResourcesPerPage": {
                return Optional.ofNullable(clazz.cast(this.resourcesPerPage()));
            }
            case "TagsPerPage": {
                return Optional.ofNullable(clazz.cast(this.tagsPerPage()));
            }
            case "ResourceTypeFilters": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeFilters()));
            }
            case "IncludeComplianceDetails": {
                return Optional.ofNullable(clazz.cast(this.includeComplianceDetails()));
            }
            case "ExcludeCompliantResources": {
                return Optional.ofNullable(clazz.cast(this.excludeCompliantResources()));
            }
            case "ResourceARNList": {
                return Optional.ofNullable(clazz.cast(this.resourceARNList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesRequest, T> g) {
        return obj -> g.apply((GetResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsTaggingApiRequest.BuilderImpl
    implements Builder {
        private String paginationToken;
        private List<TagFilter> tagFilters = DefaultSdkAutoConstructList.getInstance();
        private Integer resourcesPerPage;
        private Integer tagsPerPage;
        private List<String> resourceTypeFilters = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeComplianceDetails;
        private Boolean excludeCompliantResources;
        private List<String> resourceARNList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesRequest model) {
            super(model);
            this.paginationToken(model.paginationToken);
            this.tagFilters(model.tagFilters);
            this.resourcesPerPage(model.resourcesPerPage);
            this.tagsPerPage(model.tagsPerPage);
            this.resourceTypeFilters(model.resourceTypeFilters);
            this.includeComplianceDetails(model.includeComplianceDetails);
            this.excludeCompliantResources(model.excludeCompliantResources);
            this.resourceARNList(model.resourceARNList);
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final List<TagFilter.Builder> getTagFilters() {
            List<TagFilter.Builder> result = TagFilterListCopier.copyToBuilder(this.tagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagFilters(Collection<TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = TagFilterListCopier.copyFromBuilder(tagFilters);
        }

        @Override
        public final Builder tagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFilterListCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(TagFilter ... tagFilters) {
            this.tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(Consumer<TagFilter.Builder> ... tagFilters) {
            this.tagFilters(Stream.of(tagFilters).map(c -> (TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getResourcesPerPage() {
            return this.resourcesPerPage;
        }

        public final void setResourcesPerPage(Integer resourcesPerPage) {
            this.resourcesPerPage = resourcesPerPage;
        }

        @Override
        public final Builder resourcesPerPage(Integer resourcesPerPage) {
            this.resourcesPerPage = resourcesPerPage;
            return this;
        }

        public final Integer getTagsPerPage() {
            return this.tagsPerPage;
        }

        public final void setTagsPerPage(Integer tagsPerPage) {
            this.tagsPerPage = tagsPerPage;
        }

        @Override
        public final Builder tagsPerPage(Integer tagsPerPage) {
            this.tagsPerPage = tagsPerPage;
            return this;
        }

        public final Collection<String> getResourceTypeFilters() {
            if (this.resourceTypeFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypeFilters;
        }

        public final void setResourceTypeFilters(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFilterListCopier.copy(resourceTypeFilters);
        }

        @Override
        public final Builder resourceTypeFilters(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFilterListCopier.copy(resourceTypeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeFilters(String ... resourceTypeFilters) {
            this.resourceTypeFilters(Arrays.asList(resourceTypeFilters));
            return this;
        }

        public final Boolean getIncludeComplianceDetails() {
            return this.includeComplianceDetails;
        }

        public final void setIncludeComplianceDetails(Boolean includeComplianceDetails) {
            this.includeComplianceDetails = includeComplianceDetails;
        }

        @Override
        public final Builder includeComplianceDetails(Boolean includeComplianceDetails) {
            this.includeComplianceDetails = includeComplianceDetails;
            return this;
        }

        public final Boolean getExcludeCompliantResources() {
            return this.excludeCompliantResources;
        }

        public final void setExcludeCompliantResources(Boolean excludeCompliantResources) {
            this.excludeCompliantResources = excludeCompliantResources;
        }

        @Override
        public final Builder excludeCompliantResources(Boolean excludeCompliantResources) {
            this.excludeCompliantResources = excludeCompliantResources;
            return this;
        }

        public final Collection<String> getResourceARNList() {
            if (this.resourceARNList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceARNList;
        }

        public final void setResourceARNList(Collection<String> resourceARNList) {
            this.resourceARNList = ResourceARNListForGetCopier.copy(resourceARNList);
        }

        @Override
        public final Builder resourceARNList(Collection<String> resourceARNList) {
            this.resourceARNList = ResourceARNListForGetCopier.copy(resourceARNList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceARNList(String ... resourceARNList) {
            this.resourceARNList(Arrays.asList(resourceARNList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourcesRequest build() {
            return new GetResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsTaggingApiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcesRequest> {
        public Builder paginationToken(String var1);

        public Builder tagFilters(Collection<TagFilter> var1);

        public Builder tagFilters(TagFilter ... var1);

        public Builder tagFilters(Consumer<TagFilter.Builder> ... var1);

        public Builder resourcesPerPage(Integer var1);

        public Builder tagsPerPage(Integer var1);

        public Builder resourceTypeFilters(Collection<String> var1);

        public Builder resourceTypeFilters(String ... var1);

        public Builder includeComplianceDetails(Boolean var1);

        public Builder excludeCompliantResources(Boolean var1);

        public Builder resourceARNList(Collection<String> var1);

        public Builder resourceARNList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

