/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.ResourceGroupsTaggingApiClient;
import software.amazon.awssdk.services.resourcegroupstaggingapi.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetComplianceSummaryRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetComplianceSummaryResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.Summary;

public class GetComplianceSummaryIterable
implements SdkIterable<GetComplianceSummaryResponse> {
    private final ResourceGroupsTaggingApiClient client;
    private final GetComplianceSummaryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetComplianceSummaryIterable(ResourceGroupsTaggingApiClient client, GetComplianceSummaryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetComplianceSummaryResponseFetcher();
    }

    public Iterator<GetComplianceSummaryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Summary> summaryList() {
        Function<GetComplianceSummaryResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaryList() != null) {
                return response.summaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetComplianceSummaryResponseFetcher
    implements SyncPageFetcher<GetComplianceSummaryResponse> {
        private GetComplianceSummaryResponseFetcher() {
        }

        public boolean hasNextPage(GetComplianceSummaryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.paginationToken());
        }

        public GetComplianceSummaryResponse nextPage(GetComplianceSummaryResponse previousPage) {
            if (previousPage == null) {
                return GetComplianceSummaryIterable.this.client.getComplianceSummary(GetComplianceSummaryIterable.this.firstRequest);
            }
            return GetComplianceSummaryIterable.this.client.getComplianceSummary((GetComplianceSummaryRequest)((Object)GetComplianceSummaryIterable.this.firstRequest.toBuilder().paginationToken(previousPage.paginationToken()).build()));
        }
    }
}

