/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.ResourceGroupsTaggingApiClient;
import software.amazon.awssdk.services.resourcegroupstaggingapi.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagKeysRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetTagKeysResponse;

public class GetTagKeysIterable
implements SdkIterable<GetTagKeysResponse> {
    private final ResourceGroupsTaggingApiClient client;
    private final GetTagKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTagKeysIterable(ResourceGroupsTaggingApiClient client, GetTagKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetTagKeysResponseFetcher();
    }

    public Iterator<GetTagKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> tagKeys() {
        Function<GetTagKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.tagKeys() != null) {
                return response.tagKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetTagKeysResponseFetcher
    implements SyncPageFetcher<GetTagKeysResponse> {
        private GetTagKeysResponseFetcher() {
        }

        public boolean hasNextPage(GetTagKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.paginationToken());
        }

        public GetTagKeysResponse nextPage(GetTagKeysResponse previousPage) {
            if (previousPage == null) {
                return GetTagKeysIterable.this.client.getTagKeys(GetTagKeysIterable.this.firstRequest);
            }
            return GetTagKeysIterable.this.client.getTagKeys((GetTagKeysRequest)((Object)GetTagKeysIterable.this.firstRequest.toBuilder().paginationToken(previousPage.paginationToken()).build()));
        }
    }
}

