/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReportCreationResponse extends ResourceGroupsTaggingApiResponse implements
        ToCopyableBuilder<DescribeReportCreationResponse.Builder, DescribeReportCreationResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeReportCreationResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Location").getter(getter(DescribeReportCreationResponse::s3Location))
            .setter(setter(Builder::s3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Location").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(DescribeReportCreationResponse::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            S3_LOCATION_FIELD, ERROR_MESSAGE_FIELD));

    private final String status;

    private final String s3Location;

    private final String errorMessage;

    private DescribeReportCreationResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.s3Location = builder.s3Location;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * Reports the status of the operation.
     * </p>
     * <p>
     * The operation status can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RUNNING</code> - Report creation is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code> - Report creation is complete. You can open the report from the Amazon S3 bucket that you
     * specified when you ran <code>StartReportCreation</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Report creation timed out or the Amazon S3 bucket is not accessible.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO REPORT</code> - No report was generated in the last 90 days.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Reports the status of the operation.</p>
     *         <p>
     *         The operation status can be one of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RUNNING</code> - Report creation is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code> - Report creation is complete. You can open the report from the Amazon S3 bucket
     *         that you specified when you ran <code>StartReportCreation</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Report creation timed out or the Amazon S3 bucket is not accessible.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO REPORT</code> - No report was generated in the last 90 days.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The path to the Amazon S3 bucket where the report was stored on creation.
     * </p>
     * 
     * @return The path to the Amazon S3 bucket where the report was stored on creation.
     */
    public final String s3Location() {
        return s3Location;
    }

    /**
     * <p>
     * Details of the common errors that all operations return.
     * </p>
     * 
     * @return Details of the common errors that all operations return.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReportCreationResponse)) {
            return false;
        }
        DescribeReportCreationResponse other = (DescribeReportCreationResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(s3Location(), other.s3Location())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReportCreationResponse").add("Status", status()).add("S3Location", s3Location())
                .add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "S3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReportCreationResponse, T> g) {
        return obj -> g.apply((DescribeReportCreationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsTaggingApiResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReportCreationResponse> {
        /**
         * <p>
         * Reports the status of the operation.
         * </p>
         * <p>
         * The operation status can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RUNNING</code> - Report creation is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code> - Report creation is complete. You can open the report from the Amazon S3 bucket that
         * you specified when you ran <code>StartReportCreation</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - Report creation timed out or the Amazon S3 bucket is not accessible.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO REPORT</code> - No report was generated in the last 90 days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Reports the status of the operation.</p>
         *        <p>
         *        The operation status can be one of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RUNNING</code> - Report creation is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code> - Report creation is complete. You can open the report from the Amazon S3
         *        bucket that you specified when you ran <code>StartReportCreation</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Report creation timed out or the Amazon S3 bucket is not accessible.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO REPORT</code> - No report was generated in the last 90 days.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The path to the Amazon S3 bucket where the report was stored on creation.
         * </p>
         * 
         * @param s3Location
         *        The path to the Amazon S3 bucket where the report was stored on creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(String s3Location);

        /**
         * <p>
         * Details of the common errors that all operations return.
         * </p>
         * 
         * @param errorMessage
         *        Details of the common errors that all operations return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl extends ResourceGroupsTaggingApiResponse.BuilderImpl implements Builder {
        private String status;

        private String s3Location;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReportCreationResponse model) {
            super(model);
            status(model.status);
            s3Location(model.s3Location);
            errorMessage(model.errorMessage);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getS3Location() {
            return s3Location;
        }

        public final void setS3Location(String s3Location) {
            this.s3Location = s3Location;
        }

        @Override
        public final Builder s3Location(String s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public DescribeReportCreationResponse build() {
            return new DescribeReportCreationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
