/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcesRequest extends ResourceGroupsTaggingApiRequest implements
        ToCopyableBuilder<GetResourcesRequest.Builder, GetResourcesRequest> {
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaginationToken").getter(getter(GetResourcesRequest::paginationToken))
            .setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final SdkField<List<TagFilter>> TAG_FILTERS_FIELD = SdkField
            .<List<TagFilter>> builder(MarshallingType.LIST)
            .memberName("TagFilters")
            .getter(getter(GetResourcesRequest::tagFilters))
            .setter(setter(Builder::tagFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RESOURCES_PER_PAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResourcesPerPage").getter(getter(GetResourcesRequest::resourcesPerPage))
            .setter(setter(Builder::resourcesPerPage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesPerPage").build()).build();

    private static final SdkField<Integer> TAGS_PER_PAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TagsPerPage").getter(getter(GetResourcesRequest::tagsPerPage)).setter(setter(Builder::tagsPerPage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsPerPage").build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPE_FILTERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypeFilters")
            .getter(getter(GetResourcesRequest::resourceTypeFilters))
            .setter(setter(Builder::resourceTypeFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INCLUDE_COMPLIANCE_DETAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeComplianceDetails").getter(getter(GetResourcesRequest::includeComplianceDetails))
            .setter(setter(Builder::includeComplianceDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeComplianceDetails").build())
            .build();

    private static final SdkField<Boolean> EXCLUDE_COMPLIANT_RESOURCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ExcludeCompliantResources")
            .getter(getter(GetResourcesRequest::excludeCompliantResources)).setter(setter(Builder::excludeCompliantResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeCompliantResources").build())
            .build();

    private static final SdkField<List<String>> RESOURCE_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceARNList")
            .getter(getter(GetResourcesRequest::resourceARNList))
            .setter(setter(Builder::resourceARNList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARNList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGINATION_TOKEN_FIELD,
            TAG_FILTERS_FIELD, RESOURCES_PER_PAGE_FIELD, TAGS_PER_PAGE_FIELD, RESOURCE_TYPE_FILTERS_FIELD,
            INCLUDE_COMPLIANCE_DETAILS_FIELD, EXCLUDE_COMPLIANT_RESOURCES_FIELD, RESOURCE_ARN_LIST_FIELD));

    private final String paginationToken;

    private final List<TagFilter> tagFilters;

    private final Integer resourcesPerPage;

    private final Integer tagsPerPage;

    private final List<String> resourceTypeFilters;

    private final Boolean includeComplianceDetails;

    private final Boolean excludeCompliantResources;

    private final List<String> resourceARNList;

    private GetResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.paginationToken = builder.paginationToken;
        this.tagFilters = builder.tagFilters;
        this.resourcesPerPage = builder.resourcesPerPage;
        this.tagsPerPage = builder.tagsPerPage;
        this.resourceTypeFilters = builder.resourceTypeFilters;
        this.includeComplianceDetails = builder.includeComplianceDetails;
        this.excludeCompliantResources = builder.excludeCompliantResources;
        this.resourceARNList = builder.resourceARNList;
    }

    /**
     * <p>
     * Specifies a <code>PaginationToken</code> response value from a previous request to indicate that you want the
     * next page of results. Leave this parameter empty in your initial request.
     * </p>
     * 
     * @return Specifies a <code>PaginationToken</code> response value from a previous request to indicate that you want
     *         the next page of results. Leave this parameter empty in your initial request.
     */
    public final String paginationToken() {
        return paginationToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagFilters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagFilters() {
        return tagFilters != null && !(tagFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of TagFilters (keys and values) to restrict the output to only those resources that have tags
     * with the specified keys and, if included, the specified values. Each <code>TagFilter</code> must contain a key
     * with values optional. A request can include up to 50 keys, and each key can include up to 20 values.
     * </p>
     * <p>
     * Note the following when deciding how to use TagFilters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you <i>don't</i> specify a <code>TagFilter</code>, the response includes all resources that are currently
     * tagged or ever had a tag. Resources that currently don't have tags are shown with an empty tag set, like this:
     * <code>"Tags": []</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify more than one filter in a single request, the response returns only those resources that satisfy
     * all filters.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a filter that contains more than one value for a key, the response returns resources that match
     * <i>any</i> of the specified values for that key.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you don't specify a value for a key, the response returns all resources that are tagged with that key, with
     * any or no value.
     * </p>
     * <p>
     * For example, for the following filters: <code>filter1= {keyA,{value1}}</code>,
     * <code>filter2={keyB,{value2,value3,value4}}</code>, <code>filter3= {keyC}</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>GetResources({filter1})</code> returns resources tagged with <code>key1=value1</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GetResources({filter2})</code> returns resources tagged with <code>key2=value2</code> or
     * <code>key2=value3</code> or <code>key2=value4</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GetResources({filter3})</code> returns resources tagged with any tag with the key <code>key3</code>, and
     * with any or no value
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GetResources({filter1,filter2,filter3})</code> returns resources tagged with
     * <code>(key1=value1) and (key2=value2 or key2=value3 or key2=value4) and (key3, any or no value)</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagFilters} method.
     * </p>
     * 
     * @return Specifies a list of TagFilters (keys and values) to restrict the output to only those resources that have
     *         tags with the specified keys and, if included, the specified values. Each <code>TagFilter</code> must
     *         contain a key with values optional. A request can include up to 50 keys, and each key can include up to
     *         20 values. </p>
     *         <p>
     *         Note the following when deciding how to use TagFilters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you <i>don't</i> specify a <code>TagFilter</code>, the response includes all resources that are
     *         currently tagged or ever had a tag. Resources that currently don't have tags are shown with an empty tag
     *         set, like this: <code>"Tags": []</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify more than one filter in a single request, the response returns only those resources that
     *         satisfy all filters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify a filter that contains more than one value for a key, the response returns resources that
     *         match <i>any</i> of the specified values for that key.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you don't specify a value for a key, the response returns all resources that are tagged with that key,
     *         with any or no value.
     *         </p>
     *         <p>
     *         For example, for the following filters: <code>filter1= {keyA,{value1}}</code>,
     *         <code>filter2={keyB,{value2,value3,value4}}</code>, <code>filter3= {keyC}</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>GetResources({filter1})</code> returns resources tagged with <code>key1=value1</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GetResources({filter2})</code> returns resources tagged with <code>key2=value2</code> or
     *         <code>key2=value3</code> or <code>key2=value4</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GetResources({filter3})</code> returns resources tagged with any tag with the key <code>key3</code>
     *         , and with any or no value
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GetResources({filter1,filter2,filter3})</code> returns resources tagged with
     *         <code>(key1=value1) and (key2=value2 or key2=value3 or key2=value4) and (key3, any or no value)</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final List<TagFilter> tagFilters() {
        return tagFilters;
    }

    /**
     * <p>
     * Specifies the maximum number of results to be returned in each page. A query can return fewer than this maximum,
     * even if there are more results still to return. You should always check the <code>PaginationToken</code> response
     * value to see if there are more results. You can specify a minimum of 1 and a maximum value of 100.
     * </p>
     * 
     * @return Specifies the maximum number of results to be returned in each page. A query can return fewer than this
     *         maximum, even if there are more results still to return. You should always check the
     *         <code>PaginationToken</code> response value to see if there are more results. You can specify a minimum
     *         of 1 and a maximum value of 100.
     */
    public final Integer resourcesPerPage() {
        return resourcesPerPage;
    }

    /**
     * <p>
     * Amazon Web Services recommends using <code>ResourcesPerPage</code> instead of this parameter.
     * </p>
     * <p>
     * A limit that restricts the number of tags (key and value pairs) returned by <code>GetResources</code> in
     * paginated output. A resource with no tags is counted as having one tag (one key and value pair).
     * </p>
     * <p>
     * <code>GetResources</code> does not split a resource and its associated tags across pages. If the specified
     * <code>TagsPerPage</code> would cause such a break, a <code>PaginationToken</code> is returned in place of the
     * affected resource and its tags. Use that token in another request to get the remaining data. For example, if you
     * specify a <code>TagsPerPage</code> of <code>100</code> and the account has 22 resources with 10 tags each
     * (meaning that each resource has 10 key and value pairs), the output will consist of three pages. The first page
     * displays the first 10 resources, each with its 10 tags. The second page displays the next 10 resources, each with
     * its 10 tags. The third page displays the remaining 2 resources, each with its 10 tags.
     * </p>
     * <p>
     * You can set <code>TagsPerPage</code> to a minimum of 100 items up to a maximum of 500 items.
     * </p>
     * 
     * @return Amazon Web Services recommends using <code>ResourcesPerPage</code> instead of this parameter.</p>
     *         <p>
     *         A limit that restricts the number of tags (key and value pairs) returned by <code>GetResources</code> in
     *         paginated output. A resource with no tags is counted as having one tag (one key and value pair).
     *         </p>
     *         <p>
     *         <code>GetResources</code> does not split a resource and its associated tags across pages. If the
     *         specified <code>TagsPerPage</code> would cause such a break, a <code>PaginationToken</code> is returned
     *         in place of the affected resource and its tags. Use that token in another request to get the remaining
     *         data. For example, if you specify a <code>TagsPerPage</code> of <code>100</code> and the account has 22
     *         resources with 10 tags each (meaning that each resource has 10 key and value pairs), the output will
     *         consist of three pages. The first page displays the first 10 resources, each with its 10 tags. The second
     *         page displays the next 10 resources, each with its 10 tags. The third page displays the remaining 2
     *         resources, each with its 10 tags.
     *         </p>
     *         <p>
     *         You can set <code>TagsPerPage</code> to a minimum of 100 items up to a maximum of 500 items.
     */
    public final Integer tagsPerPage() {
        return tagsPerPage;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypeFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypeFilters() {
        return resourceTypeFilters != null && !(resourceTypeFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the resource types that you want included in the response. The format of each resource type is
     * <code>service[:resourceType]</code>. For example, specifying a resource type of <code>ec2</code> returns all
     * Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of <code>ec2:instance</code>
     * returns only EC2 instances.
     * </p>
     * <p>
     * The string for each service name and resource type is the same as that embedded in a resource's Amazon Resource
     * Name (ARN). For the list of services whose resources you can use in this parameter, see <a
     * href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html">Services
     * that support the Resource Groups Tagging API</a>.
     * </p>
     * <p>
     * You can specify multiple resource types by using an array. The array can include up to 100 items. Note that the
     * length constraint requirement applies to each resource type filter. For example, the following string would limit
     * the response to only Amazon EC2 instances, Amazon S3 buckets, or any Audit Manager resource:
     * </p>
     * <p>
     * <code>ec2:instance,s3:bucket,auditmanager</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypeFilters} method.
     * </p>
     * 
     * @return Specifies the resource types that you want included in the response. The format of each resource type is
     *         <code>service[:resourceType]</code>. For example, specifying a resource type of <code>ec2</code> returns
     *         all Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of
     *         <code>ec2:instance</code> returns only EC2 instances. </p>
     *         <p>
     *         The string for each service name and resource type is the same as that embedded in a resource's Amazon
     *         Resource Name (ARN). For the list of services whose resources you can use in this parameter, see <a
     *         href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html"
     *         >Services that support the Resource Groups Tagging API</a>.
     *         </p>
     *         <p>
     *         You can specify multiple resource types by using an array. The array can include up to 100 items. Note
     *         that the length constraint requirement applies to each resource type filter. For example, the following
     *         string would limit the response to only Amazon EC2 instances, Amazon S3 buckets, or any Audit Manager
     *         resource:
     *         </p>
     *         <p>
     *         <code>ec2:instance,s3:bucket,auditmanager</code>
     */
    public final List<String> resourceTypeFilters() {
        return resourceTypeFilters;
    }

    /**
     * <p>
     * Specifies whether to include details regarding the compliance with the effective tag policy. Set this to
     * <code>true</code> to determine whether resources are compliant with the tag policy and to get details.
     * </p>
     * 
     * @return Specifies whether to include details regarding the compliance with the effective tag policy. Set this to
     *         <code>true</code> to determine whether resources are compliant with the tag policy and to get details.
     */
    public final Boolean includeComplianceDetails() {
        return includeComplianceDetails;
    }

    /**
     * <p>
     * Specifies whether to exclude resources that are compliant with the tag policy. Set this to <code>true</code> if
     * you are interested in retrieving information on noncompliant resources only.
     * </p>
     * <p>
     * You can use this parameter only if the <code>IncludeComplianceDetails</code> parameter is also set to
     * <code>true</code>.
     * </p>
     * 
     * @return Specifies whether to exclude resources that are compliant with the tag policy. Set this to
     *         <code>true</code> if you are interested in retrieving information on noncompliant resources only.</p>
     *         <p>
     *         You can use this parameter only if the <code>IncludeComplianceDetails</code> parameter is also set to
     *         <code>true</code>.
     */
    public final Boolean excludeCompliantResources() {
        return excludeCompliantResources;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceARNList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceARNList() {
        return resourceARNList != null && !(resourceARNList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of ARNs of resources for which you want to retrieve tag data. You can't specify both this
     * parameter and any of the pagination parameters (<code>ResourcesPerPage</code>, <code>TagsPerPage</code>,
     * <code>PaginationToken</code>) in the same request. If you specify both, you get an <code>Invalid Parameter</code>
     * exception.
     * </p>
     * <p>
     * If a resource specified by this parameter doesn't exist, it doesn't generate an error; it simply isn't included
     * in the response.
     * </p>
     * <p>
     * An ARN (Amazon Resource Name) uniquely identifies a resource. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceARNList} method.
     * </p>
     * 
     * @return Specifies a list of ARNs of resources for which you want to retrieve tag data. You can't specify both
     *         this parameter and any of the pagination parameters (<code>ResourcesPerPage</code>,
     *         <code>TagsPerPage</code>, <code>PaginationToken</code>) in the same request. If you specify both, you get
     *         an <code>Invalid Parameter</code> exception.</p>
     *         <p>
     *         If a resource specified by this parameter doesn't exist, it doesn't generate an error; it simply isn't
     *         included in the response.
     *         </p>
     *         <p>
     *         An ARN (Amazon Resource Name) uniquely identifies a resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General
     *         Reference</i>.
     */
    public final List<String> resourceARNList() {
        return resourceARNList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagFilters() ? tagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourcesPerPage());
        hashCode = 31 * hashCode + Objects.hashCode(tagsPerPage());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypeFilters() ? resourceTypeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeComplianceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(excludeCompliantResources());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceARNList() ? resourceARNList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesRequest)) {
            return false;
        }
        GetResourcesRequest other = (GetResourcesRequest) obj;
        return Objects.equals(paginationToken(), other.paginationToken()) && hasTagFilters() == other.hasTagFilters()
                && Objects.equals(tagFilters(), other.tagFilters())
                && Objects.equals(resourcesPerPage(), other.resourcesPerPage())
                && Objects.equals(tagsPerPage(), other.tagsPerPage())
                && hasResourceTypeFilters() == other.hasResourceTypeFilters()
                && Objects.equals(resourceTypeFilters(), other.resourceTypeFilters())
                && Objects.equals(includeComplianceDetails(), other.includeComplianceDetails())
                && Objects.equals(excludeCompliantResources(), other.excludeCompliantResources())
                && hasResourceARNList() == other.hasResourceARNList()
                && Objects.equals(resourceARNList(), other.resourceARNList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcesRequest").add("PaginationToken", paginationToken())
                .add("TagFilters", hasTagFilters() ? tagFilters() : null).add("ResourcesPerPage", resourcesPerPage())
                .add("TagsPerPage", tagsPerPage())
                .add("ResourceTypeFilters", hasResourceTypeFilters() ? resourceTypeFilters() : null)
                .add("IncludeComplianceDetails", includeComplianceDetails())
                .add("ExcludeCompliantResources", excludeCompliantResources())
                .add("ResourceARNList", hasResourceARNList() ? resourceARNList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        case "TagFilters":
            return Optional.ofNullable(clazz.cast(tagFilters()));
        case "ResourcesPerPage":
            return Optional.ofNullable(clazz.cast(resourcesPerPage()));
        case "TagsPerPage":
            return Optional.ofNullable(clazz.cast(tagsPerPage()));
        case "ResourceTypeFilters":
            return Optional.ofNullable(clazz.cast(resourceTypeFilters()));
        case "IncludeComplianceDetails":
            return Optional.ofNullable(clazz.cast(includeComplianceDetails()));
        case "ExcludeCompliantResources":
            return Optional.ofNullable(clazz.cast(excludeCompliantResources()));
        case "ResourceARNList":
            return Optional.ofNullable(clazz.cast(resourceARNList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesRequest, T> g) {
        return obj -> g.apply((GetResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsTaggingApiRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourcesRequest> {
        /**
         * <p>
         * Specifies a <code>PaginationToken</code> response value from a previous request to indicate that you want the
         * next page of results. Leave this parameter empty in your initial request.
         * </p>
         * 
         * @param paginationToken
         *        Specifies a <code>PaginationToken</code> response value from a previous request to indicate that you
         *        want the next page of results. Leave this parameter empty in your initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);

        /**
         * <p>
         * Specifies a list of TagFilters (keys and values) to restrict the output to only those resources that have
         * tags with the specified keys and, if included, the specified values. Each <code>TagFilter</code> must contain
         * a key with values optional. A request can include up to 50 keys, and each key can include up to 20 values.
         * </p>
         * <p>
         * Note the following when deciding how to use TagFilters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you <i>don't</i> specify a <code>TagFilter</code>, the response includes all resources that are currently
         * tagged or ever had a tag. Resources that currently don't have tags are shown with an empty tag set, like
         * this: <code>"Tags": []</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify more than one filter in a single request, the response returns only those resources that
         * satisfy all filters.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a filter that contains more than one value for a key, the response returns resources that
         * match <i>any</i> of the specified values for that key.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify a value for a key, the response returns all resources that are tagged with that key,
         * with any or no value.
         * </p>
         * <p>
         * For example, for the following filters: <code>filter1= {keyA,{value1}}</code>,
         * <code>filter2={keyB,{value2,value3,value4}}</code>, <code>filter3= {keyC}</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GetResources({filter1})</code> returns resources tagged with <code>key1=value1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetResources({filter2})</code> returns resources tagged with <code>key2=value2</code> or
         * <code>key2=value3</code> or <code>key2=value4</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetResources({filter3})</code> returns resources tagged with any tag with the key <code>key3</code>,
         * and with any or no value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetResources({filter1,filter2,filter3})</code> returns resources tagged with
         * <code>(key1=value1) and (key2=value2 or key2=value3 or key2=value4) and (key3, any or no value)</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param tagFilters
         *        Specifies a list of TagFilters (keys and values) to restrict the output to only those resources that
         *        have tags with the specified keys and, if included, the specified values. Each <code>TagFilter</code>
         *        must contain a key with values optional. A request can include up to 50 keys, and each key can include
         *        up to 20 values. </p>
         *        <p>
         *        Note the following when deciding how to use TagFilters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you <i>don't</i> specify a <code>TagFilter</code>, the response includes all resources that are
         *        currently tagged or ever had a tag. Resources that currently don't have tags are shown with an empty
         *        tag set, like this: <code>"Tags": []</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify more than one filter in a single request, the response returns only those resources
         *        that satisfy all filters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify a filter that contains more than one value for a key, the response returns resources
         *        that match <i>any</i> of the specified values for that key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify a value for a key, the response returns all resources that are tagged with that
         *        key, with any or no value.
         *        </p>
         *        <p>
         *        For example, for the following filters: <code>filter1= {keyA,{value1}}</code>,
         *        <code>filter2={keyB,{value2,value3,value4}}</code>, <code>filter3= {keyC}</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GetResources({filter1})</code> returns resources tagged with <code>key1=value1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetResources({filter2})</code> returns resources tagged with <code>key2=value2</code> or
         *        <code>key2=value3</code> or <code>key2=value4</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetResources({filter3})</code> returns resources tagged with any tag with the key
         *        <code>key3</code>, and with any or no value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetResources({filter1,filter2,filter3})</code> returns resources tagged with
         *        <code>(key1=value1) and (key2=value2 or key2=value3 or key2=value4) and (key3, any or no value)</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(Collection<TagFilter> tagFilters);

        /**
         * <p>
         * Specifies a list of TagFilters (keys and values) to restrict the output to only those resources that have
         * tags with the specified keys and, if included, the specified values. Each <code>TagFilter</code> must contain
         * a key with values optional. A request can include up to 50 keys, and each key can include up to 20 values.
         * </p>
         * <p>
         * Note the following when deciding how to use TagFilters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you <i>don't</i> specify a <code>TagFilter</code>, the response includes all resources that are currently
         * tagged or ever had a tag. Resources that currently don't have tags are shown with an empty tag set, like
         * this: <code>"Tags": []</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify more than one filter in a single request, the response returns only those resources that
         * satisfy all filters.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a filter that contains more than one value for a key, the response returns resources that
         * match <i>any</i> of the specified values for that key.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify a value for a key, the response returns all resources that are tagged with that key,
         * with any or no value.
         * </p>
         * <p>
         * For example, for the following filters: <code>filter1= {keyA,{value1}}</code>,
         * <code>filter2={keyB,{value2,value3,value4}}</code>, <code>filter3= {keyC}</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GetResources({filter1})</code> returns resources tagged with <code>key1=value1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetResources({filter2})</code> returns resources tagged with <code>key2=value2</code> or
         * <code>key2=value3</code> or <code>key2=value4</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetResources({filter3})</code> returns resources tagged with any tag with the key <code>key3</code>,
         * and with any or no value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetResources({filter1,filter2,filter3})</code> returns resources tagged with
         * <code>(key1=value1) and (key2=value2 or key2=value3 or key2=value4) and (key3, any or no value)</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param tagFilters
         *        Specifies a list of TagFilters (keys and values) to restrict the output to only those resources that
         *        have tags with the specified keys and, if included, the specified values. Each <code>TagFilter</code>
         *        must contain a key with values optional. A request can include up to 50 keys, and each key can include
         *        up to 20 values. </p>
         *        <p>
         *        Note the following when deciding how to use TagFilters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you <i>don't</i> specify a <code>TagFilter</code>, the response includes all resources that are
         *        currently tagged or ever had a tag. Resources that currently don't have tags are shown with an empty
         *        tag set, like this: <code>"Tags": []</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify more than one filter in a single request, the response returns only those resources
         *        that satisfy all filters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify a filter that contains more than one value for a key, the response returns resources
         *        that match <i>any</i> of the specified values for that key.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you don't specify a value for a key, the response returns all resources that are tagged with that
         *        key, with any or no value.
         *        </p>
         *        <p>
         *        For example, for the following filters: <code>filter1= {keyA,{value1}}</code>,
         *        <code>filter2={keyB,{value2,value3,value4}}</code>, <code>filter3= {keyC}</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GetResources({filter1})</code> returns resources tagged with <code>key1=value1</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetResources({filter2})</code> returns resources tagged with <code>key2=value2</code> or
         *        <code>key2=value3</code> or <code>key2=value4</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetResources({filter3})</code> returns resources tagged with any tag with the key
         *        <code>key3</code>, and with any or no value
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GetResources({filter1,filter2,filter3})</code> returns resources tagged with
         *        <code>(key1=value1) and (key2=value2 or key2=value3 or key2=value4) and (key3, any or no value)</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilters(TagFilter... tagFilters);

        /**
         * <p>
         * Specifies a list of TagFilters (keys and values) to restrict the output to only those resources that have
         * tags with the specified keys and, if included, the specified values. Each <code>TagFilter</code> must contain
         * a key with values optional. A request can include up to 50 keys, and each key can include up to 20 values.
         * </p>
         * <p>
         * Note the following when deciding how to use TagFilters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you <i>don't</i> specify a <code>TagFilter</code>, the response includes all resources that are currently
         * tagged or ever had a tag. Resources that currently don't have tags are shown with an empty tag set, like
         * this: <code>"Tags": []</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify more than one filter in a single request, the response returns only those resources that
         * satisfy all filters.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a filter that contains more than one value for a key, the response returns resources that
         * match <i>any</i> of the specified values for that key.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you don't specify a value for a key, the response returns all resources that are tagged with that key,
         * with any or no value.
         * </p>
         * <p>
         * For example, for the following filters: <code>filter1= {keyA,{value1}}</code>,
         * <code>filter2={keyB,{value2,value3,value4}}</code>, <code>filter3= {keyC}</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GetResources({filter1})</code> returns resources tagged with <code>key1=value1</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetResources({filter2})</code> returns resources tagged with <code>key2=value2</code> or
         * <code>key2=value3</code> or <code>key2=value4</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetResources({filter3})</code> returns resources tagged with any tag with the key <code>key3</code>,
         * and with any or no value
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GetResources({filter1,filter2,filter3})</code> returns resources tagged with
         * <code>(key1=value1) and (key2=value2 or key2=value3 or key2=value4) and (key3, any or no value)</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #tagFilters(List<TagFilter>)}.
         * 
         * @param tagFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilters(java.util.Collection<TagFilter>)
         */
        Builder tagFilters(Consumer<TagFilter.Builder>... tagFilters);

        /**
         * <p>
         * Specifies the maximum number of results to be returned in each page. A query can return fewer than this
         * maximum, even if there are more results still to return. You should always check the
         * <code>PaginationToken</code> response value to see if there are more results. You can specify a minimum of 1
         * and a maximum value of 100.
         * </p>
         * 
         * @param resourcesPerPage
         *        Specifies the maximum number of results to be returned in each page. A query can return fewer than
         *        this maximum, even if there are more results still to return. You should always check the
         *        <code>PaginationToken</code> response value to see if there are more results. You can specify a
         *        minimum of 1 and a maximum value of 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesPerPage(Integer resourcesPerPage);

        /**
         * <p>
         * Amazon Web Services recommends using <code>ResourcesPerPage</code> instead of this parameter.
         * </p>
         * <p>
         * A limit that restricts the number of tags (key and value pairs) returned by <code>GetResources</code> in
         * paginated output. A resource with no tags is counted as having one tag (one key and value pair).
         * </p>
         * <p>
         * <code>GetResources</code> does not split a resource and its associated tags across pages. If the specified
         * <code>TagsPerPage</code> would cause such a break, a <code>PaginationToken</code> is returned in place of the
         * affected resource and its tags. Use that token in another request to get the remaining data. For example, if
         * you specify a <code>TagsPerPage</code> of <code>100</code> and the account has 22 resources with 10 tags each
         * (meaning that each resource has 10 key and value pairs), the output will consist of three pages. The first
         * page displays the first 10 resources, each with its 10 tags. The second page displays the next 10 resources,
         * each with its 10 tags. The third page displays the remaining 2 resources, each with its 10 tags.
         * </p>
         * <p>
         * You can set <code>TagsPerPage</code> to a minimum of 100 items up to a maximum of 500 items.
         * </p>
         * 
         * @param tagsPerPage
         *        Amazon Web Services recommends using <code>ResourcesPerPage</code> instead of this parameter.</p>
         *        <p>
         *        A limit that restricts the number of tags (key and value pairs) returned by <code>GetResources</code>
         *        in paginated output. A resource with no tags is counted as having one tag (one key and value pair).
         *        </p>
         *        <p>
         *        <code>GetResources</code> does not split a resource and its associated tags across pages. If the
         *        specified <code>TagsPerPage</code> would cause such a break, a <code>PaginationToken</code> is
         *        returned in place of the affected resource and its tags. Use that token in another request to get the
         *        remaining data. For example, if you specify a <code>TagsPerPage</code> of <code>100</code> and the
         *        account has 22 resources with 10 tags each (meaning that each resource has 10 key and value pairs),
         *        the output will consist of three pages. The first page displays the first 10 resources, each with its
         *        10 tags. The second page displays the next 10 resources, each with its 10 tags. The third page
         *        displays the remaining 2 resources, each with its 10 tags.
         *        </p>
         *        <p>
         *        You can set <code>TagsPerPage</code> to a minimum of 100 items up to a maximum of 500 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsPerPage(Integer tagsPerPage);

        /**
         * <p>
         * Specifies the resource types that you want included in the response. The format of each resource type is
         * <code>service[:resourceType]</code>. For example, specifying a resource type of <code>ec2</code> returns all
         * Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of <code>ec2:instance</code>
         * returns only EC2 instances.
         * </p>
         * <p>
         * The string for each service name and resource type is the same as that embedded in a resource's Amazon
         * Resource Name (ARN). For the list of services whose resources you can use in this parameter, see <a
         * href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html">Services
         * that support the Resource Groups Tagging API</a>.
         * </p>
         * <p>
         * You can specify multiple resource types by using an array. The array can include up to 100 items. Note that
         * the length constraint requirement applies to each resource type filter. For example, the following string
         * would limit the response to only Amazon EC2 instances, Amazon S3 buckets, or any Audit Manager resource:
         * </p>
         * <p>
         * <code>ec2:instance,s3:bucket,auditmanager</code>
         * </p>
         * 
         * @param resourceTypeFilters
         *        Specifies the resource types that you want included in the response. The format of each resource type
         *        is <code>service[:resourceType]</code>. For example, specifying a resource type of <code>ec2</code>
         *        returns all Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of
         *        <code>ec2:instance</code> returns only EC2 instances. </p>
         *        <p>
         *        The string for each service name and resource type is the same as that embedded in a resource's Amazon
         *        Resource Name (ARN). For the list of services whose resources you can use in this parameter, see <a
         *        href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html">
         *        Services that support the Resource Groups Tagging API</a>.
         *        </p>
         *        <p>
         *        You can specify multiple resource types by using an array. The array can include up to 100 items. Note
         *        that the length constraint requirement applies to each resource type filter. For example, the
         *        following string would limit the response to only Amazon EC2 instances, Amazon S3 buckets, or any
         *        Audit Manager resource:
         *        </p>
         *        <p>
         *        <code>ec2:instance,s3:bucket,auditmanager</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeFilters(Collection<String> resourceTypeFilters);

        /**
         * <p>
         * Specifies the resource types that you want included in the response. The format of each resource type is
         * <code>service[:resourceType]</code>. For example, specifying a resource type of <code>ec2</code> returns all
         * Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of <code>ec2:instance</code>
         * returns only EC2 instances.
         * </p>
         * <p>
         * The string for each service name and resource type is the same as that embedded in a resource's Amazon
         * Resource Name (ARN). For the list of services whose resources you can use in this parameter, see <a
         * href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html">Services
         * that support the Resource Groups Tagging API</a>.
         * </p>
         * <p>
         * You can specify multiple resource types by using an array. The array can include up to 100 items. Note that
         * the length constraint requirement applies to each resource type filter. For example, the following string
         * would limit the response to only Amazon EC2 instances, Amazon S3 buckets, or any Audit Manager resource:
         * </p>
         * <p>
         * <code>ec2:instance,s3:bucket,auditmanager</code>
         * </p>
         * 
         * @param resourceTypeFilters
         *        Specifies the resource types that you want included in the response. The format of each resource type
         *        is <code>service[:resourceType]</code>. For example, specifying a resource type of <code>ec2</code>
         *        returns all Amazon EC2 resources (which includes EC2 instances). Specifying a resource type of
         *        <code>ec2:instance</code> returns only EC2 instances. </p>
         *        <p>
         *        The string for each service name and resource type is the same as that embedded in a resource's Amazon
         *        Resource Name (ARN). For the list of services whose resources you can use in this parameter, see <a
         *        href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/supported-services.html">
         *        Services that support the Resource Groups Tagging API</a>.
         *        </p>
         *        <p>
         *        You can specify multiple resource types by using an array. The array can include up to 100 items. Note
         *        that the length constraint requirement applies to each resource type filter. For example, the
         *        following string would limit the response to only Amazon EC2 instances, Amazon S3 buckets, or any
         *        Audit Manager resource:
         *        </p>
         *        <p>
         *        <code>ec2:instance,s3:bucket,auditmanager</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeFilters(String... resourceTypeFilters);

        /**
         * <p>
         * Specifies whether to include details regarding the compliance with the effective tag policy. Set this to
         * <code>true</code> to determine whether resources are compliant with the tag policy and to get details.
         * </p>
         * 
         * @param includeComplianceDetails
         *        Specifies whether to include details regarding the compliance with the effective tag policy. Set this
         *        to <code>true</code> to determine whether resources are compliant with the tag policy and to get
         *        details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeComplianceDetails(Boolean includeComplianceDetails);

        /**
         * <p>
         * Specifies whether to exclude resources that are compliant with the tag policy. Set this to <code>true</code>
         * if you are interested in retrieving information on noncompliant resources only.
         * </p>
         * <p>
         * You can use this parameter only if the <code>IncludeComplianceDetails</code> parameter is also set to
         * <code>true</code>.
         * </p>
         * 
         * @param excludeCompliantResources
         *        Specifies whether to exclude resources that are compliant with the tag policy. Set this to
         *        <code>true</code> if you are interested in retrieving information on noncompliant resources only.</p>
         *        <p>
         *        You can use this parameter only if the <code>IncludeComplianceDetails</code> parameter is also set to
         *        <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeCompliantResources(Boolean excludeCompliantResources);

        /**
         * <p>
         * Specifies a list of ARNs of resources for which you want to retrieve tag data. You can't specify both this
         * parameter and any of the pagination parameters (<code>ResourcesPerPage</code>, <code>TagsPerPage</code>,
         * <code>PaginationToken</code>) in the same request. If you specify both, you get an
         * <code>Invalid Parameter</code> exception.
         * </p>
         * <p>
         * If a resource specified by this parameter doesn't exist, it doesn't generate an error; it simply isn't
         * included in the response.
         * </p>
         * <p>
         * An ARN (Amazon Resource Name) uniquely identifies a resource. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param resourceARNList
         *        Specifies a list of ARNs of resources for which you want to retrieve tag data. You can't specify both
         *        this parameter and any of the pagination parameters (<code>ResourcesPerPage</code>,
         *        <code>TagsPerPage</code>, <code>PaginationToken</code>) in the same request. If you specify both, you
         *        get an <code>Invalid Parameter</code> exception.</p>
         *        <p>
         *        If a resource specified by this parameter doesn't exist, it doesn't generate an error; it simply isn't
         *        included in the response.
         *        </p>
         *        <p>
         *        An ARN (Amazon Resource Name) uniquely identifies a resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARNList(Collection<String> resourceARNList);

        /**
         * <p>
         * Specifies a list of ARNs of resources for which you want to retrieve tag data. You can't specify both this
         * parameter and any of the pagination parameters (<code>ResourcesPerPage</code>, <code>TagsPerPage</code>,
         * <code>PaginationToken</code>) in the same request. If you specify both, you get an
         * <code>Invalid Parameter</code> exception.
         * </p>
         * <p>
         * If a resource specified by this parameter doesn't exist, it doesn't generate an error; it simply isn't
         * included in the response.
         * </p>
         * <p>
         * An ARN (Amazon Resource Name) uniquely identifies a resource. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param resourceARNList
         *        Specifies a list of ARNs of resources for which you want to retrieve tag data. You can't specify both
         *        this parameter and any of the pagination parameters (<code>ResourcesPerPage</code>,
         *        <code>TagsPerPage</code>, <code>PaginationToken</code>) in the same request. If you specify both, you
         *        get an <code>Invalid Parameter</code> exception.</p>
         *        <p>
         *        If a resource specified by this parameter doesn't exist, it doesn't generate an error; it simply isn't
         *        included in the response.
         *        </p>
         *        <p>
         *        An ARN (Amazon Resource Name) uniquely identifies a resource. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General
         *        Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARNList(String... resourceARNList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsTaggingApiRequest.BuilderImpl implements Builder {
        private String paginationToken;

        private List<TagFilter> tagFilters = DefaultSdkAutoConstructList.getInstance();

        private Integer resourcesPerPage;

        private Integer tagsPerPage;

        private List<String> resourceTypeFilters = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeComplianceDetails;

        private Boolean excludeCompliantResources;

        private List<String> resourceARNList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesRequest model) {
            super(model);
            paginationToken(model.paginationToken);
            tagFilters(model.tagFilters);
            resourcesPerPage(model.resourcesPerPage);
            tagsPerPage(model.tagsPerPage);
            resourceTypeFilters(model.resourceTypeFilters);
            includeComplianceDetails(model.includeComplianceDetails);
            excludeCompliantResources(model.excludeCompliantResources);
            resourceARNList(model.resourceARNList);
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final List<TagFilter.Builder> getTagFilters() {
            List<TagFilter.Builder> result = TagFilterListCopier.copyToBuilder(this.tagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagFilters(Collection<TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = TagFilterListCopier.copyFromBuilder(tagFilters);
        }

        @Override
        public final Builder tagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFilterListCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(TagFilter... tagFilters) {
            tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(Consumer<TagFilter.Builder>... tagFilters) {
            tagFilters(Stream.of(tagFilters).map(c -> TagFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getResourcesPerPage() {
            return resourcesPerPage;
        }

        public final void setResourcesPerPage(Integer resourcesPerPage) {
            this.resourcesPerPage = resourcesPerPage;
        }

        @Override
        public final Builder resourcesPerPage(Integer resourcesPerPage) {
            this.resourcesPerPage = resourcesPerPage;
            return this;
        }

        public final Integer getTagsPerPage() {
            return tagsPerPage;
        }

        public final void setTagsPerPage(Integer tagsPerPage) {
            this.tagsPerPage = tagsPerPage;
        }

        @Override
        public final Builder tagsPerPage(Integer tagsPerPage) {
            this.tagsPerPage = tagsPerPage;
            return this;
        }

        public final Collection<String> getResourceTypeFilters() {
            if (resourceTypeFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypeFilters;
        }

        public final void setResourceTypeFilters(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFilterListCopier.copy(resourceTypeFilters);
        }

        @Override
        public final Builder resourceTypeFilters(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFilterListCopier.copy(resourceTypeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeFilters(String... resourceTypeFilters) {
            resourceTypeFilters(Arrays.asList(resourceTypeFilters));
            return this;
        }

        public final Boolean getIncludeComplianceDetails() {
            return includeComplianceDetails;
        }

        public final void setIncludeComplianceDetails(Boolean includeComplianceDetails) {
            this.includeComplianceDetails = includeComplianceDetails;
        }

        @Override
        public final Builder includeComplianceDetails(Boolean includeComplianceDetails) {
            this.includeComplianceDetails = includeComplianceDetails;
            return this;
        }

        public final Boolean getExcludeCompliantResources() {
            return excludeCompliantResources;
        }

        public final void setExcludeCompliantResources(Boolean excludeCompliantResources) {
            this.excludeCompliantResources = excludeCompliantResources;
        }

        @Override
        public final Builder excludeCompliantResources(Boolean excludeCompliantResources) {
            this.excludeCompliantResources = excludeCompliantResources;
            return this;
        }

        public final Collection<String> getResourceARNList() {
            if (resourceARNList instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceARNList;
        }

        public final void setResourceARNList(Collection<String> resourceARNList) {
            this.resourceARNList = ResourceARNListForGetCopier.copy(resourceARNList);
        }

        @Override
        public final Builder resourceARNList(Collection<String> resourceARNList) {
            this.resourceARNList = ResourceARNListForGetCopier.copy(resourceARNList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceARNList(String... resourceARNList) {
            resourceARNList(Arrays.asList(resourceARNList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourcesRequest build() {
            return new GetResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
