/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourcesResponse extends ResourceGroupsTaggingApiResponse implements
        ToCopyableBuilder<GetResourcesResponse.Builder, GetResourcesResponse> {
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaginationToken").getter(getter(GetResourcesResponse::paginationToken))
            .setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final SdkField<List<ResourceTagMapping>> RESOURCE_TAG_MAPPING_LIST_FIELD = SdkField
            .<List<ResourceTagMapping>> builder(MarshallingType.LIST)
            .memberName("ResourceTagMappingList")
            .getter(getter(GetResourcesResponse::resourceTagMappingList))
            .setter(setter(Builder::resourceTagMappingList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTagMappingList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTagMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTagMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGINATION_TOKEN_FIELD,
            RESOURCE_TAG_MAPPING_LIST_FIELD));

    private final String paginationToken;

    private final List<ResourceTagMapping> resourceTagMappingList;

    private GetResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.paginationToken = builder.paginationToken;
        this.resourceTagMappingList = builder.resourceTagMappingList;
    }

    /**
     * <p>
     * A string that indicates that there is more data available than this response contains. To receive the next part
     * of the response, specify this response value as the <code>PaginationToken</code> value in the request for the
     * next page.
     * </p>
     * 
     * @return A string that indicates that there is more data available than this response contains. To receive the
     *         next part of the response, specify this response value as the <code>PaginationToken</code> value in the
     *         request for the next page.
     */
    public final String paginationToken() {
        return paginationToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTagMappingList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResourceTagMappingList() {
        return resourceTagMappingList != null && !(resourceTagMappingList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource ARNs and the tags (keys and values) associated with each.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTagMappingList} method.
     * </p>
     * 
     * @return A list of resource ARNs and the tags (keys and values) associated with each.
     */
    public final List<ResourceTagMapping> resourceTagMappingList() {
        return resourceTagMappingList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTagMappingList() ? resourceTagMappingList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesResponse)) {
            return false;
        }
        GetResourcesResponse other = (GetResourcesResponse) obj;
        return Objects.equals(paginationToken(), other.paginationToken())
                && hasResourceTagMappingList() == other.hasResourceTagMappingList()
                && Objects.equals(resourceTagMappingList(), other.resourceTagMappingList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourcesResponse").add("PaginationToken", paginationToken())
                .add("ResourceTagMappingList", hasResourceTagMappingList() ? resourceTagMappingList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        case "ResourceTagMappingList":
            return Optional.ofNullable(clazz.cast(resourceTagMappingList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesResponse, T> g) {
        return obj -> g.apply((GetResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsTaggingApiResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourcesResponse> {
        /**
         * <p>
         * A string that indicates that there is more data available than this response contains. To receive the next
         * part of the response, specify this response value as the <code>PaginationToken</code> value in the request
         * for the next page.
         * </p>
         * 
         * @param paginationToken
         *        A string that indicates that there is more data available than this response contains. To receive the
         *        next part of the response, specify this response value as the <code>PaginationToken</code> value in
         *        the request for the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);

        /**
         * <p>
         * A list of resource ARNs and the tags (keys and values) associated with each.
         * </p>
         * 
         * @param resourceTagMappingList
         *        A list of resource ARNs and the tags (keys and values) associated with each.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagMappingList(Collection<ResourceTagMapping> resourceTagMappingList);

        /**
         * <p>
         * A list of resource ARNs and the tags (keys and values) associated with each.
         * </p>
         * 
         * @param resourceTagMappingList
         *        A list of resource ARNs and the tags (keys and values) associated with each.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTagMappingList(ResourceTagMapping... resourceTagMappingList);

        /**
         * <p>
         * A list of resource ARNs and the tags (keys and values) associated with each.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceTagMapping.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceTagMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceTagMapping.Builder#build()} is
         * called immediately and its result is passed to {@link #resourceTagMappingList(List<ResourceTagMapping>)}.
         * 
         * @param resourceTagMappingList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceTagMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTagMappingList(java.util.Collection<ResourceTagMapping>)
         */
        Builder resourceTagMappingList(Consumer<ResourceTagMapping.Builder>... resourceTagMappingList);
    }

    static final class BuilderImpl extends ResourceGroupsTaggingApiResponse.BuilderImpl implements Builder {
        private String paginationToken;

        private List<ResourceTagMapping> resourceTagMappingList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesResponse model) {
            super(model);
            paginationToken(model.paginationToken);
            resourceTagMappingList(model.resourceTagMappingList);
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final List<ResourceTagMapping.Builder> getResourceTagMappingList() {
            List<ResourceTagMapping.Builder> result = ResourceTagMappingListCopier.copyToBuilder(this.resourceTagMappingList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTagMappingList(Collection<ResourceTagMapping.BuilderImpl> resourceTagMappingList) {
            this.resourceTagMappingList = ResourceTagMappingListCopier.copyFromBuilder(resourceTagMappingList);
        }

        @Override
        public final Builder resourceTagMappingList(Collection<ResourceTagMapping> resourceTagMappingList) {
            this.resourceTagMappingList = ResourceTagMappingListCopier.copy(resourceTagMappingList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagMappingList(ResourceTagMapping... resourceTagMappingList) {
            resourceTagMappingList(Arrays.asList(resourceTagMappingList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagMappingList(Consumer<ResourceTagMapping.Builder>... resourceTagMappingList) {
            resourceTagMappingList(Stream.of(resourceTagMappingList)
                    .map(c -> ResourceTagMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetResourcesResponse build() {
            return new GetResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
