/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTagValuesResponse extends ResourceGroupsTaggingApiResponse implements
        ToCopyableBuilder<GetTagValuesResponse.Builder, GetTagValuesResponse> {
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaginationToken").getter(getter(GetTagValuesResponse::paginationToken))
            .setter(setter(Builder::paginationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()).build();

    private static final SdkField<List<String>> TAG_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagValues")
            .getter(getter(GetTagValuesResponse::tagValues))
            .setter(setter(Builder::tagValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGINATION_TOKEN_FIELD,
            TAG_VALUES_FIELD));

    private final String paginationToken;

    private final List<String> tagValues;

    private GetTagValuesResponse(BuilderImpl builder) {
        super(builder);
        this.paginationToken = builder.paginationToken;
        this.tagValues = builder.tagValues;
    }

    /**
     * <p>
     * A string that indicates that there is more data available than this response contains. To receive the next part
     * of the response, specify this response value as the <code>PaginationToken</code> value in the request for the
     * next page.
     * </p>
     * 
     * @return A string that indicates that there is more data available than this response contains. To receive the
     *         next part of the response, specify this response value as the <code>PaginationToken</code> value in the
     *         request for the next page.
     */
    public final String paginationToken() {
        return paginationToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagValues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagValues() {
        return tagValues != null && !(tagValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all tag values for the specified key currently used in the specified Amazon Web Services Region for the
     * calling account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagValues} method.
     * </p>
     * 
     * @return A list of all tag values for the specified key currently used in the specified Amazon Web Services Region
     *         for the calling account.
     */
    public final List<String> tagValues() {
        return tagValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(paginationToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagValues() ? tagValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTagValuesResponse)) {
            return false;
        }
        GetTagValuesResponse other = (GetTagValuesResponse) obj;
        return Objects.equals(paginationToken(), other.paginationToken()) && hasTagValues() == other.hasTagValues()
                && Objects.equals(tagValues(), other.tagValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTagValuesResponse").add("PaginationToken", paginationToken())
                .add("TagValues", hasTagValues() ? tagValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PaginationToken":
            return Optional.ofNullable(clazz.cast(paginationToken()));
        case "TagValues":
            return Optional.ofNullable(clazz.cast(tagValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTagValuesResponse, T> g) {
        return obj -> g.apply((GetTagValuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsTaggingApiResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTagValuesResponse> {
        /**
         * <p>
         * A string that indicates that there is more data available than this response contains. To receive the next
         * part of the response, specify this response value as the <code>PaginationToken</code> value in the request
         * for the next page.
         * </p>
         * 
         * @param paginationToken
         *        A string that indicates that there is more data available than this response contains. To receive the
         *        next part of the response, specify this response value as the <code>PaginationToken</code> value in
         *        the request for the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationToken(String paginationToken);

        /**
         * <p>
         * A list of all tag values for the specified key currently used in the specified Amazon Web Services Region for
         * the calling account.
         * </p>
         * 
         * @param tagValues
         *        A list of all tag values for the specified key currently used in the specified Amazon Web Services
         *        Region for the calling account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(Collection<String> tagValues);

        /**
         * <p>
         * A list of all tag values for the specified key currently used in the specified Amazon Web Services Region for
         * the calling account.
         * </p>
         * 
         * @param tagValues
         *        A list of all tag values for the specified key currently used in the specified Amazon Web Services
         *        Region for the calling account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(String... tagValues);
    }

    static final class BuilderImpl extends ResourceGroupsTaggingApiResponse.BuilderImpl implements Builder {
        private String paginationToken;

        private List<String> tagValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTagValuesResponse model) {
            super(model);
            paginationToken(model.paginationToken);
            tagValues(model.tagValues);
        }

        public final String getPaginationToken() {
            return paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        public final Collection<String> getTagValues() {
            if (tagValues instanceof SdkAutoConstructList) {
                return null;
            }
            return tagValues;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValuesOutputListCopier.copy(tagValues);
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValuesOutputListCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String... tagValues) {
            tagValues(Arrays.asList(tagValues));
            return this;
        }

        @Override
        public GetTagValuesResponse build() {
            return new GetTagValuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
