/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A count of noncompliant resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Summary implements SdkPojo, Serializable, ToCopyableBuilder<Summary.Builder, Summary> {
    private static final SdkField<String> LAST_UPDATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdated").getter(getter(Summary::lastUpdated)).setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetId").getter(getter(Summary::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();

    private static final SdkField<String> TARGET_ID_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetIdType").getter(getter(Summary::targetIdTypeAsString)).setter(setter(Builder::targetIdType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIdType").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(Summary::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(Summary::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Long> NON_COMPLIANT_RESOURCES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NonCompliantResources").getter(getter(Summary::nonCompliantResources))
            .setter(setter(Builder::nonCompliantResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonCompliantResources").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_UPDATED_FIELD,
            TARGET_ID_FIELD, TARGET_ID_TYPE_FIELD, REGION_FIELD, RESOURCE_TYPE_FIELD, NON_COMPLIANT_RESOURCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lastUpdated;

    private final String targetId;

    private final String targetIdType;

    private final String region;

    private final String resourceType;

    private final Long nonCompliantResources;

    private Summary(BuilderImpl builder) {
        this.lastUpdated = builder.lastUpdated;
        this.targetId = builder.targetId;
        this.targetIdType = builder.targetIdType;
        this.region = builder.region;
        this.resourceType = builder.resourceType;
        this.nonCompliantResources = builder.nonCompliantResources;
    }

    /**
     * <p>
     * The timestamp that shows when this summary was generated in this Region.
     * </p>
     * 
     * @return The timestamp that shows when this summary was generated in this Region.
     */
    public final String lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The account identifier or the root identifier of the organization. If you don't know the root ID, you can call
     * the Organizations <a
     * href="https://docs.aws.amazon.com/organizations/latest/APIReference/API_ListRoots.html">ListRoots</a> API.
     * </p>
     * 
     * @return The account identifier or the root identifier of the organization. If you don't know the root ID, you can
     *         call the Organizations <a
     *         href="https://docs.aws.amazon.com/organizations/latest/APIReference/API_ListRoots.html">ListRoots</a>
     *         API.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * Whether the target is an account, an OU, or the organization root.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetIdType} will
     * return {@link TargetIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetIdTypeAsString}.
     * </p>
     * 
     * @return Whether the target is an account, an OU, or the organization root.
     * @see TargetIdType
     */
    public final TargetIdType targetIdType() {
        return TargetIdType.fromValue(targetIdType);
    }

    /**
     * <p>
     * Whether the target is an account, an OU, or the organization root.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetIdType} will
     * return {@link TargetIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetIdTypeAsString}.
     * </p>
     * 
     * @return Whether the target is an account, an OU, or the organization root.
     * @see TargetIdType
     */
    public final String targetIdTypeAsString() {
        return targetIdType;
    }

    /**
     * <p>
     * The Amazon Web Services Region that the summary applies to.
     * </p>
     * 
     * @return The Amazon Web Services Region that the summary applies to.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The Amazon Web Services resource type.
     * </p>
     * 
     * @return The Amazon Web Services resource type.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The count of noncompliant resources.
     * </p>
     * 
     * @return The count of noncompliant resources.
     */
    public final Long nonCompliantResources() {
        return nonCompliantResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetIdTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Summary)) {
            return false;
        }
        Summary other = (Summary) obj;
        return Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(targetId(), other.targetId())
                && Objects.equals(targetIdTypeAsString(), other.targetIdTypeAsString())
                && Objects.equals(region(), other.region()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(nonCompliantResources(), other.nonCompliantResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Summary").add("LastUpdated", lastUpdated()).add("TargetId", targetId())
                .add("TargetIdType", targetIdTypeAsString()).add("Region", region()).add("ResourceType", resourceType())
                .add("NonCompliantResources", nonCompliantResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "TargetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "TargetIdType":
            return Optional.ofNullable(clazz.cast(targetIdTypeAsString()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "NonCompliantResources":
            return Optional.ofNullable(clazz.cast(nonCompliantResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Summary, T> g) {
        return obj -> g.apply((Summary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Summary> {
        /**
         * <p>
         * The timestamp that shows when this summary was generated in this Region.
         * </p>
         * 
         * @param lastUpdated
         *        The timestamp that shows when this summary was generated in this Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(String lastUpdated);

        /**
         * <p>
         * The account identifier or the root identifier of the organization. If you don't know the root ID, you can
         * call the Organizations <a
         * href="https://docs.aws.amazon.com/organizations/latest/APIReference/API_ListRoots.html">ListRoots</a> API.
         * </p>
         * 
         * @param targetId
         *        The account identifier or the root identifier of the organization. If you don't know the root ID, you
         *        can call the Organizations <a
         *        href="https://docs.aws.amazon.com/organizations/latest/APIReference/API_ListRoots.html">ListRoots</a>
         *        API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * Whether the target is an account, an OU, or the organization root.
         * </p>
         * 
         * @param targetIdType
         *        Whether the target is an account, an OU, or the organization root.
         * @see TargetIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetIdType
         */
        Builder targetIdType(String targetIdType);

        /**
         * <p>
         * Whether the target is an account, an OU, or the organization root.
         * </p>
         * 
         * @param targetIdType
         *        Whether the target is an account, an OU, or the organization root.
         * @see TargetIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetIdType
         */
        Builder targetIdType(TargetIdType targetIdType);

        /**
         * <p>
         * The Amazon Web Services Region that the summary applies to.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region that the summary applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The Amazon Web Services resource type.
         * </p>
         * 
         * @param resourceType
         *        The Amazon Web Services resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The count of noncompliant resources.
         * </p>
         * 
         * @param nonCompliantResources
         *        The count of noncompliant resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantResources(Long nonCompliantResources);
    }

    static final class BuilderImpl implements Builder {
        private String lastUpdated;

        private String targetId;

        private String targetIdType;

        private String region;

        private String resourceType;

        private Long nonCompliantResources;

        private BuilderImpl() {
        }

        private BuilderImpl(Summary model) {
            lastUpdated(model.lastUpdated);
            targetId(model.targetId);
            targetIdType(model.targetIdType);
            region(model.region);
            resourceType(model.resourceType);
            nonCompliantResources(model.nonCompliantResources);
        }

        public final String getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(String lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(String lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetIdType() {
            return targetIdType;
        }

        public final void setTargetIdType(String targetIdType) {
            this.targetIdType = targetIdType;
        }

        @Override
        public final Builder targetIdType(String targetIdType) {
            this.targetIdType = targetIdType;
            return this;
        }

        @Override
        public final Builder targetIdType(TargetIdType targetIdType) {
            this.targetIdType(targetIdType == null ? null : targetIdType.toString());
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Long getNonCompliantResources() {
            return nonCompliantResources;
        }

        public final void setNonCompliantResources(Long nonCompliantResources) {
            this.nonCompliantResources = nonCompliantResources;
        }

        @Override
        public final Builder nonCompliantResources(Long nonCompliantResources) {
            this.nonCompliantResources = nonCompliantResources;
            return this;
        }

        @Override
        public Summary build() {
            return new Summary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
