/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UntagResourcesResponse extends ResourceGroupsTaggingApiResponse implements
        ToCopyableBuilder<UntagResourcesResponse.Builder, UntagResourcesResponse> {
    private static final SdkField<Map<String, FailureInfo>> FAILED_RESOURCES_MAP_FIELD = SdkField
            .<Map<String, FailureInfo>> builder(MarshallingType.MAP)
            .memberName("FailedResourcesMap")
            .getter(getter(UntagResourcesResponse::failedResourcesMap))
            .setter(setter(Builder::failedResourcesMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedResourcesMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FailureInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailureInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_RESOURCES_MAP_FIELD));

    private final Map<String, FailureInfo> failedResourcesMap;

    private UntagResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.failedResourcesMap = builder.failedResourcesMap;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedResourcesMap property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedResourcesMap() {
        return failedResourcesMap != null && !(failedResourcesMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map containing a key-value pair for each failed item that couldn't be untagged. The key is the ARN of the
     * failed resource. The value is a <code>FailureInfo</code> object that contains an error code, a status code, and
     * an error message. If there are no errors, the <code>FailedResourcesMap</code> is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedResourcesMap} method.
     * </p>
     * 
     * @return A map containing a key-value pair for each failed item that couldn't be untagged. The key is the ARN of
     *         the failed resource. The value is a <code>FailureInfo</code> object that contains an error code, a status
     *         code, and an error message. If there are no errors, the <code>FailedResourcesMap</code> is empty.
     */
    public final Map<String, FailureInfo> failedResourcesMap() {
        return failedResourcesMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedResourcesMap() ? failedResourcesMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourcesResponse)) {
            return false;
        }
        UntagResourcesResponse other = (UntagResourcesResponse) obj;
        return hasFailedResourcesMap() == other.hasFailedResourcesMap()
                && Objects.equals(failedResourcesMap(), other.failedResourcesMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UntagResourcesResponse")
                .add("FailedResourcesMap", hasFailedResourcesMap() ? failedResourcesMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedResourcesMap":
            return Optional.ofNullable(clazz.cast(failedResourcesMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UntagResourcesResponse, T> g) {
        return obj -> g.apply((UntagResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsTaggingApiResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UntagResourcesResponse> {
        /**
         * <p>
         * A map containing a key-value pair for each failed item that couldn't be untagged. The key is the ARN of the
         * failed resource. The value is a <code>FailureInfo</code> object that contains an error code, a status code,
         * and an error message. If there are no errors, the <code>FailedResourcesMap</code> is empty.
         * </p>
         * 
         * @param failedResourcesMap
         *        A map containing a key-value pair for each failed item that couldn't be untagged. The key is the ARN
         *        of the failed resource. The value is a <code>FailureInfo</code> object that contains an error code, a
         *        status code, and an error message. If there are no errors, the <code>FailedResourcesMap</code> is
         *        empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedResourcesMap(Map<String, FailureInfo> failedResourcesMap);
    }

    static final class BuilderImpl extends ResourceGroupsTaggingApiResponse.BuilderImpl implements Builder {
        private Map<String, FailureInfo> failedResourcesMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResourcesResponse model) {
            super(model);
            failedResourcesMap(model.failedResourcesMap);
        }

        public final Map<String, FailureInfo.Builder> getFailedResourcesMap() {
            Map<String, FailureInfo.Builder> result = FailedResourcesMapCopier.copyToBuilder(this.failedResourcesMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFailedResourcesMap(Map<String, FailureInfo.BuilderImpl> failedResourcesMap) {
            this.failedResourcesMap = FailedResourcesMapCopier.copyFromBuilder(failedResourcesMap);
        }

        @Override
        public final Builder failedResourcesMap(Map<String, FailureInfo> failedResourcesMap) {
            this.failedResourcesMap = FailedResourcesMapCopier.copy(failedResourcesMap);
            return this;
        }

        @Override
        public UntagResourcesResponse build() {
            return new UntagResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
