/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GroupByAttribute;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GroupByCopier;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.RegionFilterListCopier;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceGroupsTaggingApiRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceTypeFilterListCopier;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.TagKeyFilterListCopier;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.TargetIdFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetComplianceSummaryRequest
extends ResourceGroupsTaggingApiRequest
implements ToCopyableBuilder<Builder, GetComplianceSummaryRequest> {
    private static final SdkField<List<String>> TARGET_ID_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetIdFilters").getter(GetComplianceSummaryRequest.getter(GetComplianceSummaryRequest::targetIdFilters)).setter(GetComplianceSummaryRequest.setter(Builder::targetIdFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetIdFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REGION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionFilters").getter(GetComplianceSummaryRequest.getter(GetComplianceSummaryRequest::regionFilters)).setter(GetComplianceSummaryRequest.setter(Builder::regionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypeFilters").getter(GetComplianceSummaryRequest.getter(GetComplianceSummaryRequest::resourceTypeFilters)).setter(GetComplianceSummaryRequest.setter(Builder::resourceTypeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAG_KEY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagKeyFilters").getter(GetComplianceSummaryRequest.getter(GetComplianceSummaryRequest::tagKeyFilters)).setter(GetComplianceSummaryRequest.setter(Builder::tagKeyFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeyFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupBy").getter(GetComplianceSummaryRequest.getter(GetComplianceSummaryRequest::groupByAsStrings)).setter(GetComplianceSummaryRequest.setter(Builder::groupByWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetComplianceSummaryRequest.getter(GetComplianceSummaryRequest::maxResults)).setter(GetComplianceSummaryRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> PAGINATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PaginationToken").getter(GetComplianceSummaryRequest.getter(GetComplianceSummaryRequest::paginationToken)).setter(GetComplianceSummaryRequest.setter(Builder::paginationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ID_FILTERS_FIELD, REGION_FILTERS_FIELD, RESOURCE_TYPE_FILTERS_FIELD, TAG_KEY_FILTERS_FIELD, GROUP_BY_FIELD, MAX_RESULTS_FIELD, PAGINATION_TOKEN_FIELD));
    private final List<String> targetIdFilters;
    private final List<String> regionFilters;
    private final List<String> resourceTypeFilters;
    private final List<String> tagKeyFilters;
    private final List<String> groupBy;
    private final Integer maxResults;
    private final String paginationToken;

    private GetComplianceSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.targetIdFilters = builder.targetIdFilters;
        this.regionFilters = builder.regionFilters;
        this.resourceTypeFilters = builder.resourceTypeFilters;
        this.tagKeyFilters = builder.tagKeyFilters;
        this.groupBy = builder.groupBy;
        this.maxResults = builder.maxResults;
        this.paginationToken = builder.paginationToken;
    }

    public final boolean hasTargetIdFilters() {
        return this.targetIdFilters != null && !(this.targetIdFilters instanceof SdkAutoConstructList);
    }

    public final List<String> targetIdFilters() {
        return this.targetIdFilters;
    }

    public final boolean hasRegionFilters() {
        return this.regionFilters != null && !(this.regionFilters instanceof SdkAutoConstructList);
    }

    public final List<String> regionFilters() {
        return this.regionFilters;
    }

    public final boolean hasResourceTypeFilters() {
        return this.resourceTypeFilters != null && !(this.resourceTypeFilters instanceof SdkAutoConstructList);
    }

    public final List<String> resourceTypeFilters() {
        return this.resourceTypeFilters;
    }

    public final boolean hasTagKeyFilters() {
        return this.tagKeyFilters != null && !(this.tagKeyFilters instanceof SdkAutoConstructList);
    }

    public final List<String> tagKeyFilters() {
        return this.tagKeyFilters;
    }

    public final List<GroupByAttribute> groupBy() {
        return GroupByCopier.copyStringToEnum(this.groupBy);
    }

    public final boolean hasGroupBy() {
        return this.groupBy != null && !(this.groupBy instanceof SdkAutoConstructList);
    }

    public final List<String> groupByAsStrings() {
        return this.groupBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String paginationToken() {
        return this.paginationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetIdFilters() ? this.targetIdFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionFilters() ? this.regionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTypeFilters() ? this.resourceTypeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagKeyFilters() ? this.tagKeyFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupBy() ? this.groupByAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.paginationToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetComplianceSummaryRequest)) {
            return false;
        }
        GetComplianceSummaryRequest other = (GetComplianceSummaryRequest)((Object)obj);
        return this.hasTargetIdFilters() == other.hasTargetIdFilters() && Objects.equals(this.targetIdFilters(), other.targetIdFilters()) && this.hasRegionFilters() == other.hasRegionFilters() && Objects.equals(this.regionFilters(), other.regionFilters()) && this.hasResourceTypeFilters() == other.hasResourceTypeFilters() && Objects.equals(this.resourceTypeFilters(), other.resourceTypeFilters()) && this.hasTagKeyFilters() == other.hasTagKeyFilters() && Objects.equals(this.tagKeyFilters(), other.tagKeyFilters()) && this.hasGroupBy() == other.hasGroupBy() && Objects.equals(this.groupByAsStrings(), other.groupByAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.paginationToken(), other.paginationToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetComplianceSummaryRequest").add("TargetIdFilters", this.hasTargetIdFilters() ? this.targetIdFilters() : null).add("RegionFilters", this.hasRegionFilters() ? this.regionFilters() : null).add("ResourceTypeFilters", this.hasResourceTypeFilters() ? this.resourceTypeFilters() : null).add("TagKeyFilters", this.hasTagKeyFilters() ? this.tagKeyFilters() : null).add("GroupBy", this.hasGroupBy() ? this.groupByAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("PaginationToken", (Object)this.paginationToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetIdFilters": {
                return Optional.ofNullable(clazz.cast(this.targetIdFilters()));
            }
            case "RegionFilters": {
                return Optional.ofNullable(clazz.cast(this.regionFilters()));
            }
            case "ResourceTypeFilters": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeFilters()));
            }
            case "TagKeyFilters": {
                return Optional.ofNullable(clazz.cast(this.tagKeyFilters()));
            }
            case "GroupBy": {
                return Optional.ofNullable(clazz.cast(this.groupByAsStrings()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "PaginationToken": {
                return Optional.ofNullable(clazz.cast(this.paginationToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetComplianceSummaryRequest, T> g) {
        return obj -> g.apply((GetComplianceSummaryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsTaggingApiRequest.BuilderImpl
    implements Builder {
        private List<String> targetIdFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> regionFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceTypeFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> tagKeyFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> groupBy = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String paginationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetComplianceSummaryRequest model) {
            super(model);
            this.targetIdFilters(model.targetIdFilters);
            this.regionFilters(model.regionFilters);
            this.resourceTypeFilters(model.resourceTypeFilters);
            this.tagKeyFilters(model.tagKeyFilters);
            this.groupByWithStrings(model.groupBy);
            this.maxResults(model.maxResults);
            this.paginationToken(model.paginationToken);
        }

        public final Collection<String> getTargetIdFilters() {
            if (this.targetIdFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetIdFilters;
        }

        public final void setTargetIdFilters(Collection<String> targetIdFilters) {
            this.targetIdFilters = TargetIdFilterListCopier.copy(targetIdFilters);
        }

        @Override
        public final Builder targetIdFilters(Collection<String> targetIdFilters) {
            this.targetIdFilters = TargetIdFilterListCopier.copy(targetIdFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIdFilters(String ... targetIdFilters) {
            this.targetIdFilters(Arrays.asList(targetIdFilters));
            return this;
        }

        public final Collection<String> getRegionFilters() {
            if (this.regionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionFilters;
        }

        public final void setRegionFilters(Collection<String> regionFilters) {
            this.regionFilters = RegionFilterListCopier.copy(regionFilters);
        }

        @Override
        public final Builder regionFilters(Collection<String> regionFilters) {
            this.regionFilters = RegionFilterListCopier.copy(regionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionFilters(String ... regionFilters) {
            this.regionFilters(Arrays.asList(regionFilters));
            return this;
        }

        public final Collection<String> getResourceTypeFilters() {
            if (this.resourceTypeFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTypeFilters;
        }

        public final void setResourceTypeFilters(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFilterListCopier.copy(resourceTypeFilters);
        }

        @Override
        public final Builder resourceTypeFilters(Collection<String> resourceTypeFilters) {
            this.resourceTypeFilters = ResourceTypeFilterListCopier.copy(resourceTypeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypeFilters(String ... resourceTypeFilters) {
            this.resourceTypeFilters(Arrays.asList(resourceTypeFilters));
            return this;
        }

        public final Collection<String> getTagKeyFilters() {
            if (this.tagKeyFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagKeyFilters;
        }

        public final void setTagKeyFilters(Collection<String> tagKeyFilters) {
            this.tagKeyFilters = TagKeyFilterListCopier.copy(tagKeyFilters);
        }

        @Override
        public final Builder tagKeyFilters(Collection<String> tagKeyFilters) {
            this.tagKeyFilters = TagKeyFilterListCopier.copy(tagKeyFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyFilters(String ... tagKeyFilters) {
            this.tagKeyFilters(Arrays.asList(tagKeyFilters));
            return this;
        }

        public final Collection<String> getGroupBy() {
            if (this.groupBy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupBy;
        }

        public final void setGroupBy(Collection<String> groupBy) {
            this.groupBy = GroupByCopier.copy(groupBy);
        }

        @Override
        public final Builder groupByWithStrings(Collection<String> groupBy) {
            this.groupBy = GroupByCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByWithStrings(String ... groupBy) {
            this.groupByWithStrings(Arrays.asList(groupBy));
            return this;
        }

        @Override
        public final Builder groupBy(Collection<GroupByAttribute> groupBy) {
            this.groupBy = GroupByCopier.copyEnumToString(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupByAttribute ... groupBy) {
            this.groupBy(Arrays.asList(groupBy));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getPaginationToken() {
            return this.paginationToken;
        }

        public final void setPaginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
        }

        @Override
        public final Builder paginationToken(String paginationToken) {
            this.paginationToken = paginationToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetComplianceSummaryRequest build() {
            return new GetComplianceSummaryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsTaggingApiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetComplianceSummaryRequest> {
        public Builder targetIdFilters(Collection<String> var1);

        public Builder targetIdFilters(String ... var1);

        public Builder regionFilters(Collection<String> var1);

        public Builder regionFilters(String ... var1);

        public Builder resourceTypeFilters(Collection<String> var1);

        public Builder resourceTypeFilters(String ... var1);

        public Builder tagKeyFilters(Collection<String> var1);

        public Builder tagKeyFilters(String ... var1);

        public Builder groupByWithStrings(Collection<String> var1);

        public Builder groupByWithStrings(String ... var1);

        public Builder groupBy(Collection<GroupByAttribute> var1);

        public Builder groupBy(GroupByAttribute ... var1);

        public Builder maxResults(Integer var1);

        public Builder paginationToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

