/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.ResourceGroupsTaggingApiAsyncClient;
import software.amazon.awssdk.services.resourcegroupstaggingapi.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetComplianceSummaryRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetComplianceSummaryResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.Summary;

public class GetComplianceSummaryPublisher
implements SdkPublisher<GetComplianceSummaryResponse> {
    private final ResourceGroupsTaggingApiAsyncClient client;
    private final GetComplianceSummaryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetComplianceSummaryPublisher(ResourceGroupsTaggingApiAsyncClient client, GetComplianceSummaryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetComplianceSummaryPublisher(ResourceGroupsTaggingApiAsyncClient client, GetComplianceSummaryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetComplianceSummaryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetComplianceSummaryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Summary> summaryList() {
        Function<GetComplianceSummaryResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaryList() != null) {
                return response.summaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetComplianceSummaryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetComplianceSummaryResponseFetcher
    implements AsyncPageFetcher<GetComplianceSummaryResponse> {
        private GetComplianceSummaryResponseFetcher() {
        }

        public boolean hasNextPage(GetComplianceSummaryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.paginationToken());
        }

        public CompletableFuture<GetComplianceSummaryResponse> nextPage(GetComplianceSummaryResponse previousPage) {
            if (previousPage == null) {
                return GetComplianceSummaryPublisher.this.client.getComplianceSummary(GetComplianceSummaryPublisher.this.firstRequest);
            }
            return GetComplianceSummaryPublisher.this.client.getComplianceSummary((GetComplianceSummaryRequest)((Object)GetComplianceSummaryPublisher.this.firstRequest.toBuilder().paginationToken(previousPage.paginationToken()).build()));
        }
    }
}

