/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroupstaggingapi.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.ResourceGroupsTaggingApiAsyncClient;
import software.amazon.awssdk.services.resourcegroupstaggingapi.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetResourcesRequest;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.GetResourcesResponse;
import software.amazon.awssdk.services.resourcegroupstaggingapi.model.ResourceTagMapping;

public class GetResourcesPublisher
implements SdkPublisher<GetResourcesResponse> {
    private final ResourceGroupsTaggingApiAsyncClient client;
    private final GetResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourcesPublisher(ResourceGroupsTaggingApiAsyncClient client, GetResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourcesPublisher(ResourceGroupsTaggingApiAsyncClient client, GetResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceTagMapping> resourceTagMappingList() {
        Function<GetResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceTagMappingList() != null) {
                return response.resourceTagMappingList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetResourcesResponseFetcher
    implements AsyncPageFetcher<GetResourcesResponse> {
        private GetResourcesResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.paginationToken());
        }

        public CompletableFuture<GetResourcesResponse> nextPage(GetResourcesResponse previousPage) {
            if (previousPage == null) {
                return GetResourcesPublisher.this.client.getResources(GetResourcesPublisher.this.firstRequest);
            }
            return GetResourcesPublisher.this.client.getResources((GetResourcesRequest)((Object)GetResourcesPublisher.this.firstRequest.toBuilder().paginationToken(previousPage.paginationToken()).build()));
        }
    }
}

