/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The AcceptDomainTransferFromAnotherAwsAccount request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptDomainTransferFromAnotherAwsAccountRequest extends Route53DomainsRequest
        implements
        ToCopyableBuilder<AcceptDomainTransferFromAnotherAwsAccountRequest.Builder, AcceptDomainTransferFromAnotherAwsAccountRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AcceptDomainTransferFromAnotherAwsAccountRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(AcceptDomainTransferFromAnotherAwsAccountRequest::password))
            .setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            PASSWORD_FIELD));

    private final String domainName;

    private final String password;

    private AcceptDomainTransferFromAnotherAwsAccountRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.password = builder.password;
    }

    /**
     * <p>
     * The name of the domain that was specified when another Amazon Web Services account submitted a <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     * >TransferDomainToAnotherAwsAccount</a> request.
     * </p>
     * 
     * @return The name of the domain that was specified when another Amazon Web Services account submitted a <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     *         >TransferDomainToAnotherAwsAccount</a> request.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The password that was returned by the <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     * >TransferDomainToAnotherAwsAccount</a> request.
     * </p>
     * 
     * @return The password that was returned by the <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
     *         >TransferDomainToAnotherAwsAccount</a> request.
     */
    public final String password() {
        return password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptDomainTransferFromAnotherAwsAccountRequest)) {
            return false;
        }
        AcceptDomainTransferFromAnotherAwsAccountRequest other = (AcceptDomainTransferFromAnotherAwsAccountRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(password(), other.password());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptDomainTransferFromAnotherAwsAccountRequest").add("DomainName", domainName())
                .add("Password", password()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptDomainTransferFromAnotherAwsAccountRequest, T> g) {
        return obj -> g.apply((AcceptDomainTransferFromAnotherAwsAccountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AcceptDomainTransferFromAnotherAwsAccountRequest> {
        /**
         * <p>
         * The name of the domain that was specified when another Amazon Web Services account submitted a <a href=
         * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
         * >TransferDomainToAnotherAwsAccount</a> request.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that was specified when another Amazon Web Services account submitted a <a
         *        href=
         *        "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
         *        >TransferDomainToAnotherAwsAccount</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The password that was returned by the <a href=
         * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
         * >TransferDomainToAnotherAwsAccount</a> request.
         * </p>
         * 
         * @param password
         *        The password that was returned by the <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html"
         *        >TransferDomainToAnotherAwsAccount</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptDomainTransferFromAnotherAwsAccountRequest model) {
            super(model);
            domainName(model.domainName);
            password(model.password);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptDomainTransferFromAnotherAwsAccountRequest build() {
            return new AcceptDomainTransferFromAnotherAwsAccountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
