/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CheckDomainTransferability request contains the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckDomainTransferabilityRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<CheckDomainTransferabilityRequest.Builder, CheckDomainTransferabilityRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(CheckDomainTransferabilityRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> AUTH_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthCode").getter(getter(CheckDomainTransferabilityRequest::authCode)).setter(setter(Builder::authCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            AUTH_CODE_FIELD));

    private final String domainName;

    private final String authCode;

    private CheckDomainTransferabilityRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.authCode = builder.authCode;
    }

    /**
     * <p>
     * The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a
     * TLD that Route 53 supports. For a list of supported TLDs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
     * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * The domain name can contain only the following characters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Letters a through z. Domain names are not case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Numbers 0 through 9.
     * </p>
     * </li>
     * <li>
     * <p>
     * Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
     * </p>
     * </li>
     * <li>
     * <p>
     * Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com,
     *         must be a TLD that Route 53 supports. For a list of supported TLDs, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You
     *         Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
     *         <p>
     *         The domain name can contain only the following characters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Letters a through z. Domain names are not case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Numbers 0 through 9.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.
     *         </p>
     *         </li>
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the code
     * that you got from the current registrar for the domain.
     * </p>
     * 
     * @return If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain,
     *         the code that you got from the current registrar for the domain.
     */
    public final String authCode() {
        return authCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(authCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckDomainTransferabilityRequest)) {
            return false;
        }
        CheckDomainTransferabilityRequest other = (CheckDomainTransferabilityRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(authCode(), other.authCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckDomainTransferabilityRequest").add("DomainName", domainName())
                .add("AuthCode", authCode() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "AuthCode":
            return Optional.ofNullable(clazz.cast(authCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckDomainTransferabilityRequest, T> g) {
        return obj -> g.apply((CheckDomainTransferabilityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CheckDomainTransferabilityRequest> {
        /**
         * <p>
         * The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must
         * be a TLD that Route 53 supports. For a list of supported TLDs, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
         * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * <p>
         * The domain name can contain only the following characters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Letters a through z. Domain names are not case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Numbers 0 through 9.
         * </p>
         * </li>
         * <li>
         * <p>
         * Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
         * </p>
         * </li>
         * <li>
         * <p>
         * Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param domainName
         *        The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as
         *        .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that
         *        You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
         *        <p>
         *        The domain name can contain only the following characters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Letters a through z. Domain names are not case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Numbers 0 through 9.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain, the
         * code that you got from the current registrar for the domain.
         * </p>
         * 
         * @param authCode
         *        If the registrar for the top-level domain (TLD) requires an authorization code to transfer the domain,
         *        the code that you got from the current registrar for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authCode(String authCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private String authCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckDomainTransferabilityRequest model) {
            super(model);
            domainName(model.domainName);
            authCode(model.authCode);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getAuthCode() {
            return authCode;
        }

        public final void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        @Override
        public final Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckDomainTransferabilityRequest build() {
            return new CheckDomainTransferabilityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
