/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GetOperationDetail response includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOperationDetailResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<GetOperationDetailResponse.Builder, GetOperationDetailResponse> {
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationId").getter(getter(GetOperationDetailResponse::operationId))
            .setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetOperationDetailResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(GetOperationDetailResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(GetOperationDetailResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(GetOperationDetailResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> SUBMITTED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmittedDate").getter(getter(GetOperationDetailResponse::submittedDate))
            .setter(setter(Builder::submittedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_ID_FIELD,
            STATUS_FIELD, MESSAGE_FIELD, DOMAIN_NAME_FIELD, TYPE_FIELD, SUBMITTED_DATE_FIELD));

    private final String operationId;

    private final String status;

    private final String message;

    private final String domainName;

    private final String type;

    private final Instant submittedDate;

    private GetOperationDetailResponse(BuilderImpl builder) {
        super(builder);
        this.operationId = builder.operationId;
        this.status = builder.status;
        this.message = builder.message;
        this.domainName = builder.domainName;
        this.type = builder.type;
        this.submittedDate = builder.submittedDate;
    }

    /**
     * <p>
     * The identifier for the operation.
     * </p>
     * 
     * @return The identifier for the operation.
     */
    public final String operationId() {
        return operationId;
    }

    /**
     * <p>
     * The current status of the requested operation in the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the requested operation in the system.
     * @see OperationStatus
     */
    public final OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the requested operation in the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the requested operation in the system.
     * @see OperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Detailed information on the status including possible errors.
     * </p>
     * 
     * @return Detailed information on the status including possible errors.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The name of a domain.
     * </p>
     * 
     * @return The name of a domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The type of operation that was requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of operation that was requested.
     * @see OperationType
     */
    public final OperationType type() {
        return OperationType.fromValue(type);
    }

    /**
     * <p>
     * The type of operation that was requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of operation that was requested.
     * @see OperationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The date when the request was submitted.
     * </p>
     * 
     * @return The date when the request was submitted.
     */
    public final Instant submittedDate() {
        return submittedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submittedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOperationDetailResponse)) {
            return false;
        }
        GetOperationDetailResponse other = (GetOperationDetailResponse) obj;
        return Objects.equals(operationId(), other.operationId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(message(), other.message()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(submittedDate(), other.submittedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOperationDetailResponse").add("OperationId", operationId()).add("Status", statusAsString())
                .add("Message", message()).add("DomainName", domainName()).add("Type", typeAsString())
                .add("SubmittedDate", submittedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SubmittedDate":
            return Optional.ofNullable(clazz.cast(submittedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOperationDetailResponse, T> g) {
        return obj -> g.apply((GetOperationDetailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOperationDetailResponse> {
        /**
         * <p>
         * The identifier for the operation.
         * </p>
         * 
         * @param operationId
         *        The identifier for the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * Detailed information on the status including possible errors.
         * </p>
         * 
         * @param message
         *        Detailed information on the status including possible errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The name of a domain.
         * </p>
         * 
         * @param domainName
         *        The name of a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The type of operation that was requested.
         * </p>
         * 
         * @param type
         *        The type of operation that was requested.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of operation that was requested.
         * </p>
         * 
         * @param type
         *        The type of operation that was requested.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(OperationType type);

        /**
         * <p>
         * The date when the request was submitted.
         * </p>
         * 
         * @param submittedDate
         *        The date when the request was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedDate(Instant submittedDate);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private String operationId;

        private String status;

        private String message;

        private String domainName;

        private String type;

        private Instant submittedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOperationDetailResponse model) {
            super(model);
            operationId(model.operationId);
            status(model.status);
            message(model.message);
            domainName(model.domainName);
            type(model.type);
            submittedDate(model.submittedDate);
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getSubmittedDate() {
            return submittedDate;
        }

        public final void setSubmittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
        }

        @Override
        public final Builder submittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
            return this;
        }

        @Override
        public GetOperationDetailResponse build() {
            return new GetOperationDetailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
