/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum OperationType {
    REGISTER_DOMAIN("REGISTER_DOMAIN"),

    DELETE_DOMAIN("DELETE_DOMAIN"),

    TRANSFER_IN_DOMAIN("TRANSFER_IN_DOMAIN"),

    UPDATE_DOMAIN_CONTACT("UPDATE_DOMAIN_CONTACT"),

    UPDATE_NAMESERVER("UPDATE_NAMESERVER"),

    CHANGE_PRIVACY_PROTECTION("CHANGE_PRIVACY_PROTECTION"),

    DOMAIN_LOCK("DOMAIN_LOCK"),

    ENABLE_AUTORENEW("ENABLE_AUTORENEW"),

    DISABLE_AUTORENEW("DISABLE_AUTORENEW"),

    ADD_DNSSEC("ADD_DNSSEC"),

    REMOVE_DNSSEC("REMOVE_DNSSEC"),

    EXPIRE_DOMAIN("EXPIRE_DOMAIN"),

    TRANSFER_OUT_DOMAIN("TRANSFER_OUT_DOMAIN"),

    CHANGE_DOMAIN_OWNER("CHANGE_DOMAIN_OWNER"),

    RENEW_DOMAIN("RENEW_DOMAIN"),

    PUSH_DOMAIN("PUSH_DOMAIN"),

    INTERNAL_TRANSFER_OUT_DOMAIN("INTERNAL_TRANSFER_OUT_DOMAIN"),

    INTERNAL_TRANSFER_IN_DOMAIN("INTERNAL_TRANSFER_IN_DOMAIN"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperationType> VALUE_MAP = EnumUtils.uniqueIndex(OperationType.class,
            OperationType::toString);

    private final String value;

    private OperationType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return OperationType corresponding to the value
     */
    public static OperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link OperationType}s
     */
    public static Set<OperationType> knownValues() {
        Set<OperationType> knownValues = EnumSet.allOf(OperationType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
