/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The RegisterDomain request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterDomainRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<RegisterDomainRequest.Builder, RegisterDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(RegisterDomainRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> IDN_LANG_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdnLangCode").getter(getter(RegisterDomainRequest::idnLangCode)).setter(setter(Builder::idnLangCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdnLangCode").build()).build();

    private static final SdkField<Integer> DURATION_IN_YEARS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationInYears").getter(getter(RegisterDomainRequest::durationInYears))
            .setter(setter(Builder::durationInYears))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInYears").build()).build();

    private static final SdkField<Boolean> AUTO_RENEW_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoRenew").getter(getter(RegisterDomainRequest::autoRenew)).setter(setter(Builder::autoRenew))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRenew").build()).build();

    private static final SdkField<ContactDetail> ADMIN_CONTACT_FIELD = SdkField.<ContactDetail> builder(MarshallingType.SDK_POJO)
            .memberName("AdminContact").getter(getter(RegisterDomainRequest::adminContact)).setter(setter(Builder::adminContact))
            .constructor(ContactDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminContact").build()).build();

    private static final SdkField<ContactDetail> REGISTRANT_CONTACT_FIELD = SdkField
            .<ContactDetail> builder(MarshallingType.SDK_POJO).memberName("RegistrantContact")
            .getter(getter(RegisterDomainRequest::registrantContact)).setter(setter(Builder::registrantContact))
            .constructor(ContactDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrantContact").build()).build();

    private static final SdkField<ContactDetail> TECH_CONTACT_FIELD = SdkField.<ContactDetail> builder(MarshallingType.SDK_POJO)
            .memberName("TechContact").getter(getter(RegisterDomainRequest::techContact)).setter(setter(Builder::techContact))
            .constructor(ContactDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechContact").build()).build();

    private static final SdkField<Boolean> PRIVACY_PROTECT_ADMIN_CONTACT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PrivacyProtectAdminContact")
            .getter(getter(RegisterDomainRequest::privacyProtectAdminContact))
            .setter(setter(Builder::privacyProtectAdminContact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyProtectAdminContact").build())
            .build();

    private static final SdkField<Boolean> PRIVACY_PROTECT_REGISTRANT_CONTACT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PrivacyProtectRegistrantContact")
            .getter(getter(RegisterDomainRequest::privacyProtectRegistrantContact))
            .setter(setter(Builder::privacyProtectRegistrantContact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyProtectRegistrantContact")
                    .build()).build();

    private static final SdkField<Boolean> PRIVACY_PROTECT_TECH_CONTACT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("PrivacyProtectTechContact")
            .getter(getter(RegisterDomainRequest::privacyProtectTechContact)).setter(setter(Builder::privacyProtectTechContact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivacyProtectTechContact").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            IDN_LANG_CODE_FIELD, DURATION_IN_YEARS_FIELD, AUTO_RENEW_FIELD, ADMIN_CONTACT_FIELD, REGISTRANT_CONTACT_FIELD,
            TECH_CONTACT_FIELD, PRIVACY_PROTECT_ADMIN_CONTACT_FIELD, PRIVACY_PROTECT_REGISTRANT_CONTACT_FIELD,
            PRIVACY_PROTECT_TECH_CONTACT_FIELD));

    private final String domainName;

    private final String idnLangCode;

    private final Integer durationInYears;

    private final Boolean autoRenew;

    private final ContactDetail adminContact;

    private final ContactDetail registrantContact;

    private final ContactDetail techContact;

    private final Boolean privacyProtectAdminContact;

    private final Boolean privacyProtectRegistrantContact;

    private final Boolean privacyProtectTechContact;

    private RegisterDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.idnLangCode = builder.idnLangCode;
        this.durationInYears = builder.durationInYears;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.privacyProtectAdminContact = builder.privacyProtectAdminContact;
        this.privacyProtectRegistrantContact = builder.privacyProtectRegistrantContact;
        this.privacyProtectTechContact = builder.privacyProtectTechContact;
    }

    /**
     * <p>
     * The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route 53
     * supports. For a list of supported TLDs, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
     * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * The domain name can contain only the following characters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Letters a through z. Domain names are not case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Numbers 0 through 9.
     * </p>
     * </li>
     * <li>
     * <p>
     * Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
     * </p>
     * </li>
     * <li>
     * <p>
     * Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that
     * you want to use supports internationalized domain names, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
     * Register with Amazon Route 53</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns"
     * >Formatting Internationalized Domain Names</a>.
     * </p>
     * 
     * @return The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that
     *         Route 53 supports. For a list of supported TLDs, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You
     *         Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
     *         <p>
     *         The domain name can contain only the following characters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Letters a through z. Domain names are not case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Numbers 0 through 9.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Internationalized domain names are not supported for some top-level domains. To determine whether the TLD
     *         that you want to use supports internationalized domain names, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You
     *         Can Register with Amazon Route 53</a>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns"
     *         >Formatting Internationalized Domain Names</a>.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String idnLangCode() {
        return idnLangCode;
    }

    /**
     * <p>
     * The number of years that you want to register the domain for. Domains are registered for a minimum of one year.
     * The maximum period depends on the top-level domain. For the range of valid values for your domain, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
     * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return The number of years that you want to register the domain for. Domains are registered for a minimum of one
     *         year. The maximum period depends on the top-level domain. For the range of valid values for your domain,
     *         see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains
     *         that You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
     *         <p>
     *         Default: 1
     */
    public final Integer durationInYears() {
        return durationInYears;
    }

    /**
     * <p>
     * Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>).
     * Autorenewal only takes effect after the account is charged.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>
     *         ). Autorenewal only takes effect after the account is charged.</p>
     *         <p>
     *         Default: <code>true</code>
     */
    public final Boolean autoRenew() {
        return autoRenew;
    }

    /**
     * <p>
     * Provides detailed contact information. For information about the values that you specify for each element, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.
     * </p>
     * 
     * @return Provides detailed contact information. For information about the values that you specify for each
     *         element, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html"
     *         >ContactDetail</a>.
     */
    public final ContactDetail adminContact() {
        return adminContact;
    }

    /**
     * <p>
     * Provides detailed contact information. For information about the values that you specify for each element, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.
     * </p>
     * 
     * @return Provides detailed contact information. For information about the values that you specify for each
     *         element, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html"
     *         >ContactDetail</a>.
     */
    public final ContactDetail registrantContact() {
        return registrantContact;
    }

    /**
     * <p>
     * Provides detailed contact information. For information about the values that you specify for each element, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail</a>.
     * </p>
     * 
     * @return Provides detailed contact information. For information about the values that you specify for each
     *         element, see <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html"
     *         >ContactDetail</a>.
     */
    public final ContactDetail techContact() {
        return techContact;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or
     * for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return
     * the information that you entered for the admin contact.
     * </p>
     * <note>
     * <p>
     * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     * </p>
     * </note>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
     *         domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
     *         WHOIS queries return the information that you entered for the admin contact.</p> <note>
     *         <p>
     *         You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     *         </p>
     *         </note>
     *         <p>
     *         Default: <code>true</code>
     */
    public final Boolean privacyProtectAdminContact() {
        return privacyProtectAdminContact;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or
     * for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return
     * the information that you entered for the registrant contact (the domain owner).
     * </p>
     * <note>
     * <p>
     * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     * </p>
     * </note>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
     *         domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
     *         WHOIS queries return the information that you entered for the registrant contact (the domain owner).</p>
     *         <note>
     *         <p>
     *         You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     *         </p>
     *         </note>
     *         <p>
     *         Default: <code>true</code>
     */
    public final Boolean privacyProtectRegistrantContact() {
        return privacyProtectRegistrantContact;
    }

    /**
     * <p>
     * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
     * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or
     * for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries return
     * the information that you entered for the technical contact.
     * </p>
     * <note>
     * <p>
     * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     * </p>
     * </note>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
     *         WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org
     *         domains) or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>,
     *         WHOIS queries return the information that you entered for the technical contact.</p> <note>
     *         <p>
     *         You must specify the same privacy setting for the administrative, registrant, and technical contacts.
     *         </p>
     *         </note>
     *         <p>
     *         Default: <code>true</code>
     */
    public final Boolean privacyProtectTechContact() {
        return privacyProtectTechContact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(idnLangCode());
        hashCode = 31 * hashCode + Objects.hashCode(durationInYears());
        hashCode = 31 * hashCode + Objects.hashCode(autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(adminContact());
        hashCode = 31 * hashCode + Objects.hashCode(registrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(techContact());
        hashCode = 31 * hashCode + Objects.hashCode(privacyProtectAdminContact());
        hashCode = 31 * hashCode + Objects.hashCode(privacyProtectRegistrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(privacyProtectTechContact());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterDomainRequest)) {
            return false;
        }
        RegisterDomainRequest other = (RegisterDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(idnLangCode(), other.idnLangCode())
                && Objects.equals(durationInYears(), other.durationInYears()) && Objects.equals(autoRenew(), other.autoRenew())
                && Objects.equals(adminContact(), other.adminContact())
                && Objects.equals(registrantContact(), other.registrantContact())
                && Objects.equals(techContact(), other.techContact())
                && Objects.equals(privacyProtectAdminContact(), other.privacyProtectAdminContact())
                && Objects.equals(privacyProtectRegistrantContact(), other.privacyProtectRegistrantContact())
                && Objects.equals(privacyProtectTechContact(), other.privacyProtectTechContact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterDomainRequest").add("DomainName", domainName()).add("IdnLangCode", idnLangCode())
                .add("DurationInYears", durationInYears()).add("AutoRenew", autoRenew())
                .add("AdminContact", adminContact() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RegistrantContact", registrantContact() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TechContact", techContact() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PrivacyProtectAdminContact", privacyProtectAdminContact())
                .add("PrivacyProtectRegistrantContact", privacyProtectRegistrantContact())
                .add("PrivacyProtectTechContact", privacyProtectTechContact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "IdnLangCode":
            return Optional.ofNullable(clazz.cast(idnLangCode()));
        case "DurationInYears":
            return Optional.ofNullable(clazz.cast(durationInYears()));
        case "AutoRenew":
            return Optional.ofNullable(clazz.cast(autoRenew()));
        case "AdminContact":
            return Optional.ofNullable(clazz.cast(adminContact()));
        case "RegistrantContact":
            return Optional.ofNullable(clazz.cast(registrantContact()));
        case "TechContact":
            return Optional.ofNullable(clazz.cast(techContact()));
        case "PrivacyProtectAdminContact":
            return Optional.ofNullable(clazz.cast(privacyProtectAdminContact()));
        case "PrivacyProtectRegistrantContact":
            return Optional.ofNullable(clazz.cast(privacyProtectRegistrantContact()));
        case "PrivacyProtectTechContact":
            return Optional.ofNullable(clazz.cast(privacyProtectTechContact()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterDomainRequest, T> g) {
        return obj -> g.apply((RegisterDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterDomainRequest> {
        /**
         * <p>
         * The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route
         * 53 supports. For a list of supported TLDs, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
         * Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * <p>
         * The domain name can contain only the following characters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Letters a through z. Domain names are not case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Numbers 0 through 9.
         * </p>
         * </li>
         * <li>
         * <p>
         * Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
         * </p>
         * </li>
         * <li>
         * <p>
         * Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Internationalized domain names are not supported for some top-level domains. To determine whether the TLD
         * that you want to use supports internationalized domain names, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You Can
         * Register with Amazon Route 53</a>. For more information, see <a href=
         * "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns"
         * >Formatting Internationalized Domain Names</a>.
         * </p>
         * 
         * @param domainName
         *        The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD
         *        that Route 53 supports. For a list of supported TLDs, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that
         *        You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
         *        <p>
         *        The domain name can contain only the following characters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Letters a through z. Domain names are not case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Numbers 0 through 9.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Hyphen (-). You can't specify a hyphen at the beginning or end of a label.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Period (.) to separate the labels in the name, such as the <code>.</code> in <code>example.com</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Internationalized domain names are not supported for some top-level domains. To determine whether the
         *        TLD that you want to use supports internationalized domain names, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that
         *        You Can Register with Amazon Route 53</a>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html#domain-name-format-idns"
         *        >Formatting Internationalized Domain Names</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param idnLangCode
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idnLangCode(String idnLangCode);

        /**
         * <p>
         * The number of years that you want to register the domain for. Domains are registered for a minimum of one
         * year. The maximum period depends on the top-level domain. For the range of valid values for your domain, see
         * <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that You
         * Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param durationInYears
         *        The number of years that you want to register the domain for. Domains are registered for a minimum of
         *        one year. The maximum period depends on the top-level domain. For the range of valid values for your
         *        domain, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html">Domains that
         *        You Can Register with Amazon Route 53</a> in the <i>Amazon Route 53 Developer Guide</i>.</p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationInYears(Integer durationInYears);

        /**
         * <p>
         * Indicates whether the domain will be automatically renewed (<code>true</code>) or not (<code>false</code>).
         * Autorenewal only takes effect after the account is charged.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param autoRenew
         *        Indicates whether the domain will be automatically renewed (<code>true</code>) or not (
         *        <code>false</code>). Autorenewal only takes effect after the account is charged.</p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRenew(Boolean autoRenew);

        /**
         * <p>
         * Provides detailed contact information. For information about the values that you specify for each element,
         * see <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail
         * </a>.
         * </p>
         * 
         * @param adminContact
         *        Provides detailed contact information. For information about the values that you specify for each
         *        element, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html"
         *        >ContactDetail</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminContact(ContactDetail adminContact);

        /**
         * <p>
         * Provides detailed contact information. For information about the values that you specify for each element,
         * see <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail
         * </a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactDetail.Builder} avoiding the need
         * to create one manually via {@link ContactDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #adminContact(ContactDetail)}.
         * 
         * @param adminContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adminContact(ContactDetail)
         */
        default Builder adminContact(Consumer<ContactDetail.Builder> adminContact) {
            return adminContact(ContactDetail.builder().applyMutation(adminContact).build());
        }

        /**
         * <p>
         * Provides detailed contact information. For information about the values that you specify for each element,
         * see <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail
         * </a>.
         * </p>
         * 
         * @param registrantContact
         *        Provides detailed contact information. For information about the values that you specify for each
         *        element, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html"
         *        >ContactDetail</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrantContact(ContactDetail registrantContact);

        /**
         * <p>
         * Provides detailed contact information. For information about the values that you specify for each element,
         * see <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail
         * </a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactDetail.Builder} avoiding the need
         * to create one manually via {@link ContactDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #registrantContact(ContactDetail)}.
         * 
         * @param registrantContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registrantContact(ContactDetail)
         */
        default Builder registrantContact(Consumer<ContactDetail.Builder> registrantContact) {
            return registrantContact(ContactDetail.builder().applyMutation(registrantContact).build());
        }

        /**
         * <p>
         * Provides detailed contact information. For information about the values that you specify for each element,
         * see <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail
         * </a>.
         * </p>
         * 
         * @param techContact
         *        Provides detailed contact information. For information about the values that you specify for each
         *        element, see <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html"
         *        >ContactDetail</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder techContact(ContactDetail techContact);

        /**
         * <p>
         * Provides detailed contact information. For information about the values that you specify for each element,
         * see <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ContactDetail.html">ContactDetail
         * </a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactDetail.Builder} avoiding the need
         * to create one manually via {@link ContactDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #techContact(ContactDetail)}.
         * 
         * @param techContact
         *        a consumer that will call methods on {@link ContactDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #techContact(ContactDetail)
         */
        default Builder techContact(Consumer<ContactDetail.Builder> techContact) {
            return techContact(ContactDetail.builder().applyMutation(techContact).build());
        }

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
         * or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries
         * return the information that you entered for the admin contact.
         * </p>
         * <note>
         * <p>
         * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
         * </p>
         * </note>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param privacyProtectAdminContact
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and
         *        .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify
         *        <code>false</code>, WHOIS queries return the information that you entered for the admin contact.</p>
         *        <note>
         *        <p>
         *        You must specify the same privacy setting for the administrative, registrant, and technical contacts.
         *        </p>
         *        </note>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyProtectAdminContact(Boolean privacyProtectAdminContact);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
         * or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries
         * return the information that you entered for the registrant contact (the domain owner).
         * </p>
         * <note>
         * <p>
         * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
         * </p>
         * </note>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param privacyProtectRegistrantContact
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and
         *        .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify
         *        <code>false</code>, WHOIS queries return the information that you entered for the registrant contact
         *        (the domain owner).</p> <note>
         *        <p>
         *        You must specify the same privacy setting for the administrative, registrant, and technical contacts.
         *        </p>
         *        </note>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact);

        /**
         * <p>
         * Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>, WHOIS
         * ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains)
         * or for our registrar associate, Gandi (for all other TLDs). If you specify <code>false</code>, WHOIS queries
         * return the information that you entered for the technical contact.
         * </p>
         * <note>
         * <p>
         * You must specify the same privacy setting for the administrative, registrant, and technical contacts.
         * </p>
         * </note>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param privacyProtectTechContact
         *        Whether you want to conceal contact information from WHOIS queries. If you specify <code>true</code>,
         *        WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and
         *        .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify
         *        <code>false</code>, WHOIS queries return the information that you entered for the technical
         *        contact.</p> <note>
         *        <p>
         *        You must specify the same privacy setting for the administrative, registrant, and technical contacts.
         *        </p>
         *        </note>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyProtectTechContact(Boolean privacyProtectTechContact);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private String domainName;

        private String idnLangCode;

        private Integer durationInYears;

        private Boolean autoRenew;

        private ContactDetail adminContact;

        private ContactDetail registrantContact;

        private ContactDetail techContact;

        private Boolean privacyProtectAdminContact;

        private Boolean privacyProtectRegistrantContact;

        private Boolean privacyProtectTechContact;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterDomainRequest model) {
            super(model);
            domainName(model.domainName);
            idnLangCode(model.idnLangCode);
            durationInYears(model.durationInYears);
            autoRenew(model.autoRenew);
            adminContact(model.adminContact);
            registrantContact(model.registrantContact);
            techContact(model.techContact);
            privacyProtectAdminContact(model.privacyProtectAdminContact);
            privacyProtectRegistrantContact(model.privacyProtectRegistrantContact);
            privacyProtectTechContact(model.privacyProtectTechContact);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getIdnLangCode() {
            return idnLangCode;
        }

        public final void setIdnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
        }

        @Override
        public final Builder idnLangCode(String idnLangCode) {
            this.idnLangCode = idnLangCode;
            return this;
        }

        public final Integer getDurationInYears() {
            return durationInYears;
        }

        public final void setDurationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
        }

        @Override
        public final Builder durationInYears(Integer durationInYears) {
            this.durationInYears = durationInYears;
            return this;
        }

        public final Boolean getAutoRenew() {
            return autoRenew;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final ContactDetail.Builder getAdminContact() {
            return adminContact != null ? adminContact.toBuilder() : null;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return registrantContact != null ? registrantContact.toBuilder() : null;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final ContactDetail.Builder getTechContact() {
            return techContact != null ? techContact.toBuilder() : null;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final Boolean getPrivacyProtectAdminContact() {
            return privacyProtectAdminContact;
        }

        public final void setPrivacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
        }

        @Override
        public final Builder privacyProtectAdminContact(Boolean privacyProtectAdminContact) {
            this.privacyProtectAdminContact = privacyProtectAdminContact;
            return this;
        }

        public final Boolean getPrivacyProtectRegistrantContact() {
            return privacyProtectRegistrantContact;
        }

        public final void setPrivacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
        }

        @Override
        public final Builder privacyProtectRegistrantContact(Boolean privacyProtectRegistrantContact) {
            this.privacyProtectRegistrantContact = privacyProtectRegistrantContact;
            return this;
        }

        public final Boolean getPrivacyProtectTechContact() {
            return privacyProtectTechContact;
        }

        public final void setPrivacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
        }

        @Override
        public final Builder privacyProtectTechContact(Boolean privacyProtectTechContact) {
            this.privacyProtectTechContact = privacyProtectTechContact;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterDomainRequest build() {
            return new RegisterDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
