/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the DNSSEC key.
 * </p>
 * <p>
 * You get this from your DNS provider and then give it to Route 53 (by using <a
 * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AssociateDelegationSignerToDomain.html"
 * >AssociateDelegationSignerToDomain</a>) to pass it to the registry to establish the chain of trust.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnssecKey implements SdkPojo, Serializable, ToCopyableBuilder<DnssecKey.Builder, DnssecKey> {
    private static final SdkField<Integer> ALGORITHM_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Algorithm").getter(getter(DnssecKey::algorithm)).setter(setter(Builder::algorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Algorithm").build()).build();

    private static final SdkField<Integer> FLAGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Flags")
            .getter(getter(DnssecKey::flags)).setter(setter(Builder::flags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flags").build()).build();

    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicKey").getter(getter(DnssecKey::publicKey)).setter(setter(Builder::publicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()).build();

    private static final SdkField<Integer> DIGEST_TYPE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DigestType").getter(getter(DnssecKey::digestType)).setter(setter(Builder::digestType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigestType").build()).build();

    private static final SdkField<String> DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Digest")
            .getter(getter(DnssecKey::digest)).setter(setter(Builder::digest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Digest").build()).build();

    private static final SdkField<Integer> KEY_TAG_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("KeyTag").getter(getter(DnssecKey::keyTag)).setter(setter(Builder::keyTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyTag").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DnssecKey::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, FLAGS_FIELD,
            PUBLIC_KEY_FIELD, DIGEST_TYPE_FIELD, DIGEST_FIELD, KEY_TAG_FIELD, ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer algorithm;

    private final Integer flags;

    private final String publicKey;

    private final Integer digestType;

    private final String digest;

    private final Integer keyTag;

    private final String id;

    private DnssecKey(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.flags = builder.flags;
        this.publicKey = builder.publicKey;
        this.digestType = builder.digestType;
        this.digest = builder.digest;
        this.keyTag = builder.keyTag;
        this.id = builder.id;
    }

    /**
     * <p>
     * The number of the public key’s cryptographic algorithm according to an <a
     * href="https://www.iana.org/assignments/dns-sec-alg-numbers/dns-sec-alg-numbers.xml">IANA</a> assignment.
     * </p>
     * <p>
     * If Route 53 is your DNS service, set this to 13.
     * </p>
     * <p>
     * For more information about enabling DNSSEC signing, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-enable-signing.html"
     * >Enabling DNSSEC signing and establishing a chain of trust</a>.
     * </p>
     * 
     * @return The number of the public key’s cryptographic algorithm according to an <a
     *         href="https://www.iana.org/assignments/dns-sec-alg-numbers/dns-sec-alg-numbers.xml">IANA</a> assignment.
     *         </p>
     *         <p>
     *         If Route 53 is your DNS service, set this to 13.
     *         </p>
     *         <p>
     *         For more information about enabling DNSSEC signing, see <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-enable-signing.html"
     *         >Enabling DNSSEC signing and establishing a chain of trust</a>.
     */
    public final Integer algorithm() {
        return algorithm;
    }

    /**
     * <p>
     * Defines the type of key. It can be either a KSK (key-signing-key, value 257) or ZSK (zone-signing-key, value
     * 256). Using KSK is always encouraged. Only use ZSK if your DNS provider isn't Route 53 and you don’t have KSK
     * available.
     * </p>
     * <p>
     * If you have KSK and ZSK keys, always use KSK to create a delegations signer (DS) record. If you have ZSK keys
     * only – use ZSK to create a DS record.
     * </p>
     * 
     * @return Defines the type of key. It can be either a KSK (key-signing-key, value 257) or ZSK (zone-signing-key,
     *         value 256). Using KSK is always encouraged. Only use ZSK if your DNS provider isn't Route 53 and you
     *         don’t have KSK available.</p>
     *         <p>
     *         If you have KSK and ZSK keys, always use KSK to create a delegations signer (DS) record. If you have ZSK
     *         keys only – use ZSK to create a DS record.
     */
    public final Integer flags() {
        return flags;
    }

    /**
     * <p>
     * The base64-encoded public key part of the key pair that is passed to the registry .
     * </p>
     * 
     * @return The base64-encoded public key part of the key pair that is passed to the registry .
     */
    public final String publicKey() {
        return publicKey;
    }

    /**
     * <p>
     * The number of the DS digest algorithm according to an IANA assignment.
     * </p>
     * <p>
     * For more information, see <a href="https://www.iana.org/assignments/ds-rr-types/ds-rr-types.xhtml">IANA</a> for
     * DNSSEC Delegation Signer (DS) Resource Record (RR) Type Digest Algorithms.
     * </p>
     * 
     * @return The number of the DS digest algorithm according to an IANA assignment.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://www.iana.org/assignments/ds-rr-types/ds-rr-types.xhtml">IANA</a> for DNSSEC Delegation
     *         Signer (DS) Resource Record (RR) Type Digest Algorithms.
     */
    public final Integer digestType() {
        return digestType;
    }

    /**
     * <p>
     * The delegation signer digest.
     * </p>
     * <p>
     * Digest is calculated from the public key provided using specified digest algorithm and this digest is the actual
     * value returned from the registry nameservers as the value of DS records.
     * </p>
     * 
     * @return The delegation signer digest.</p>
     *         <p>
     *         Digest is calculated from the public key provided using specified digest algorithm and this digest is the
     *         actual value returned from the registry nameservers as the value of DS records.
     */
    public final String digest() {
        return digest;
    }

    /**
     * <p>
     * A numeric identification of the DNSKEY record referred to by this DS record.
     * </p>
     * 
     * @return A numeric identification of the DNSKEY record referred to by this DS record.
     */
    public final Integer keyTag() {
        return keyTag;
    }

    /**
     * <p>
     * An ID assigned to each DS record created by <a href=
     * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AssociateDelegationSignerToDomain.html"
     * >AssociateDelegationSignerToDomain</a>.
     * </p>
     * 
     * @return An ID assigned to each DS record created by <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AssociateDelegationSignerToDomain.html"
     *         >AssociateDelegationSignerToDomain</a>.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(algorithm());
        hashCode = 31 * hashCode + Objects.hashCode(flags());
        hashCode = 31 * hashCode + Objects.hashCode(publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(digestType());
        hashCode = 31 * hashCode + Objects.hashCode(digest());
        hashCode = 31 * hashCode + Objects.hashCode(keyTag());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnssecKey)) {
            return false;
        }
        DnssecKey other = (DnssecKey) obj;
        return Objects.equals(algorithm(), other.algorithm()) && Objects.equals(flags(), other.flags())
                && Objects.equals(publicKey(), other.publicKey()) && Objects.equals(digestType(), other.digestType())
                && Objects.equals(digest(), other.digest()) && Objects.equals(keyTag(), other.keyTag())
                && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnssecKey").add("Algorithm", algorithm()).add("Flags", flags()).add("PublicKey", publicKey())
                .add("DigestType", digestType()).add("Digest", digest()).add("KeyTag", keyTag()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Algorithm":
            return Optional.ofNullable(clazz.cast(algorithm()));
        case "Flags":
            return Optional.ofNullable(clazz.cast(flags()));
        case "PublicKey":
            return Optional.ofNullable(clazz.cast(publicKey()));
        case "DigestType":
            return Optional.ofNullable(clazz.cast(digestType()));
        case "Digest":
            return Optional.ofNullable(clazz.cast(digest()));
        case "KeyTag":
            return Optional.ofNullable(clazz.cast(keyTag()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnssecKey, T> g) {
        return obj -> g.apply((DnssecKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnssecKey> {
        /**
         * <p>
         * The number of the public key’s cryptographic algorithm according to an <a
         * href="https://www.iana.org/assignments/dns-sec-alg-numbers/dns-sec-alg-numbers.xml">IANA</a> assignment.
         * </p>
         * <p>
         * If Route 53 is your DNS service, set this to 13.
         * </p>
         * <p>
         * For more information about enabling DNSSEC signing, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-enable-signing.html"
         * >Enabling DNSSEC signing and establishing a chain of trust</a>.
         * </p>
         * 
         * @param algorithm
         *        The number of the public key’s cryptographic algorithm according to an <a
         *        href="https://www.iana.org/assignments/dns-sec-alg-numbers/dns-sec-alg-numbers.xml">IANA</a>
         *        assignment. </p>
         *        <p>
         *        If Route 53 is your DNS service, set this to 13.
         *        </p>
         *        <p>
         *        For more information about enabling DNSSEC signing, see <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-enable-signing.html"
         *        >Enabling DNSSEC signing and establishing a chain of trust</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithm(Integer algorithm);

        /**
         * <p>
         * Defines the type of key. It can be either a KSK (key-signing-key, value 257) or ZSK (zone-signing-key, value
         * 256). Using KSK is always encouraged. Only use ZSK if your DNS provider isn't Route 53 and you don’t have KSK
         * available.
         * </p>
         * <p>
         * If you have KSK and ZSK keys, always use KSK to create a delegations signer (DS) record. If you have ZSK keys
         * only – use ZSK to create a DS record.
         * </p>
         * 
         * @param flags
         *        Defines the type of key. It can be either a KSK (key-signing-key, value 257) or ZSK (zone-signing-key,
         *        value 256). Using KSK is always encouraged. Only use ZSK if your DNS provider isn't Route 53 and you
         *        don’t have KSK available.</p>
         *        <p>
         *        If you have KSK and ZSK keys, always use KSK to create a delegations signer (DS) record. If you have
         *        ZSK keys only – use ZSK to create a DS record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flags(Integer flags);

        /**
         * <p>
         * The base64-encoded public key part of the key pair that is passed to the registry .
         * </p>
         * 
         * @param publicKey
         *        The base64-encoded public key part of the key pair that is passed to the registry .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(String publicKey);

        /**
         * <p>
         * The number of the DS digest algorithm according to an IANA assignment.
         * </p>
         * <p>
         * For more information, see <a href="https://www.iana.org/assignments/ds-rr-types/ds-rr-types.xhtml">IANA</a>
         * for DNSSEC Delegation Signer (DS) Resource Record (RR) Type Digest Algorithms.
         * </p>
         * 
         * @param digestType
         *        The number of the DS digest algorithm according to an IANA assignment.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://www.iana.org/assignments/ds-rr-types/ds-rr-types.xhtml">IANA</a> for DNSSEC Delegation
         *        Signer (DS) Resource Record (RR) Type Digest Algorithms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digestType(Integer digestType);

        /**
         * <p>
         * The delegation signer digest.
         * </p>
         * <p>
         * Digest is calculated from the public key provided using specified digest algorithm and this digest is the
         * actual value returned from the registry nameservers as the value of DS records.
         * </p>
         * 
         * @param digest
         *        The delegation signer digest.</p>
         *        <p>
         *        Digest is calculated from the public key provided using specified digest algorithm and this digest is
         *        the actual value returned from the registry nameservers as the value of DS records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digest(String digest);

        /**
         * <p>
         * A numeric identification of the DNSKEY record referred to by this DS record.
         * </p>
         * 
         * @param keyTag
         *        A numeric identification of the DNSKEY record referred to by this DS record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyTag(Integer keyTag);

        /**
         * <p>
         * An ID assigned to each DS record created by <a href=
         * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AssociateDelegationSignerToDomain.html"
         * >AssociateDelegationSignerToDomain</a>.
         * </p>
         * 
         * @param id
         *        An ID assigned to each DS record created by <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AssociateDelegationSignerToDomain.html"
         *        >AssociateDelegationSignerToDomain</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private Integer algorithm;

        private Integer flags;

        private String publicKey;

        private Integer digestType;

        private String digest;

        private Integer keyTag;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(DnssecKey model) {
            algorithm(model.algorithm);
            flags(model.flags);
            publicKey(model.publicKey);
            digestType(model.digestType);
            digest(model.digest);
            keyTag(model.keyTag);
            id(model.id);
        }

        public final Integer getAlgorithm() {
            return algorithm;
        }

        public final void setAlgorithm(Integer algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(Integer algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public final Integer getFlags() {
            return flags;
        }

        public final void setFlags(Integer flags) {
            this.flags = flags;
        }

        @Override
        public final Builder flags(Integer flags) {
            this.flags = flags;
            return this;
        }

        public final String getPublicKey() {
            return publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final Integer getDigestType() {
            return digestType;
        }

        public final void setDigestType(Integer digestType) {
            this.digestType = digestType;
        }

        @Override
        public final Builder digestType(Integer digestType) {
            this.digestType = digestType;
            return this;
        }

        public final String getDigest() {
            return digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final Integer getKeyTag() {
            return keyTag;
        }

        public final void setKeyTag(Integer keyTag) {
            this.keyTag = keyTag;
        }

        @Override
        public final Builder keyTag(Integer keyTag) {
            this.keyTag = keyTag;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public DnssecKey build() {
            return new DnssecKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
