/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ListDomains request includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainsRequest extends Route53DomainsRequest implements
        ToCopyableBuilder<ListDomainsRequest.Builder, ListDomainsRequest> {
    private static final SdkField<List<FilterCondition>> FILTER_CONDITIONS_FIELD = SdkField
            .<List<FilterCondition>> builder(MarshallingType.LIST)
            .memberName("FilterConditions")
            .getter(getter(ListDomainsRequest::filterConditions))
            .setter(setter(Builder::filterConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SortCondition> SORT_CONDITION_FIELD = SdkField
            .<SortCondition> builder(MarshallingType.SDK_POJO).memberName("SortCondition")
            .getter(getter(ListDomainsRequest::sortCondition)).setter(setter(Builder::sortCondition))
            .constructor(SortCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortCondition").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListDomainsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(ListDomainsRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CONDITIONS_FIELD,
            SORT_CONDITION_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));

    private final List<FilterCondition> filterConditions;

    private final SortCondition sortCondition;

    private final String marker;

    private final Integer maxItems;

    private ListDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.filterConditions = builder.filterConditions;
        this.sortCondition = builder.sortCondition;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterConditions() {
        return filterConditions != null && !(filterConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A complex type that contains information about the filters applied during the <code>ListDomains</code> request.
     * The filter conditions can include domain name and domain expiration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterConditions} method.
     * </p>
     * 
     * @return A complex type that contains information about the filters applied during the <code>ListDomains</code>
     *         request. The filter conditions can include domain name and domain expiration.
     */
    public final List<FilterCondition> filterConditions() {
        return filterConditions;
    }

    /**
     * <p>
     * A complex type that contains information about the requested ordering of domains in the returned list.
     * </p>
     * 
     * @return A complex type that contains information about the requested ordering of domains in the returned list.
     */
    public final SortCondition sortCondition() {
        return sortCondition;
    }

    /**
     * <p>
     * For an initial request for a list of domains, omit this element. If the number of domains that are associated
     * with the current Amazon Web Services account is greater than the value that you specified for
     * <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of
     * <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of
     * <code>NextPageMarker</code> in the <code>Marker</code> element.
     * </p>
     * <p>
     * Constraints: The marker must match the value specified in the previous request.
     * </p>
     * 
     * @return For an initial request for a list of domains, omit this element. If the number of domains that are
     *         associated with the current Amazon Web Services account is greater than the value that you specified for
     *         <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of
     *         <code>NextPageMarker</code> from the previous response, and submit another request that includes the
     *         value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
     *         <p>
     *         Constraints: The marker must match the value specified in the previous request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * Number of domains to be returned.
     * </p>
     * <p>
     * Default: 20
     * </p>
     * 
     * @return Number of domains to be returned.</p>
     *         <p>
     *         Default: 20
     */
    public final Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterConditions() ? filterConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sortCondition());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsRequest)) {
            return false;
        }
        ListDomainsRequest other = (ListDomainsRequest) obj;
        return hasFilterConditions() == other.hasFilterConditions()
                && Objects.equals(filterConditions(), other.filterConditions())
                && Objects.equals(sortCondition(), other.sortCondition()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDomainsRequest").add("FilterConditions", hasFilterConditions() ? filterConditions() : null)
                .add("SortCondition", sortCondition()).add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterConditions":
            return Optional.ofNullable(clazz.cast(filterConditions()));
        case "SortCondition":
            return Optional.ofNullable(clazz.cast(sortCondition()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainsRequest, T> g) {
        return obj -> g.apply((ListDomainsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDomainsRequest> {
        /**
         * <p>
         * A complex type that contains information about the filters applied during the <code>ListDomains</code>
         * request. The filter conditions can include domain name and domain expiration.
         * </p>
         * 
         * @param filterConditions
         *        A complex type that contains information about the filters applied during the <code>ListDomains</code>
         *        request. The filter conditions can include domain name and domain expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterConditions(Collection<FilterCondition> filterConditions);

        /**
         * <p>
         * A complex type that contains information about the filters applied during the <code>ListDomains</code>
         * request. The filter conditions can include domain name and domain expiration.
         * </p>
         * 
         * @param filterConditions
         *        A complex type that contains information about the filters applied during the <code>ListDomains</code>
         *        request. The filter conditions can include domain name and domain expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterConditions(FilterCondition... filterConditions);

        /**
         * <p>
         * A complex type that contains information about the filters applied during the <code>ListDomains</code>
         * request. The filter conditions can include domain name and domain expiration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53domains.model.FilterCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.route53domains.model.FilterCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53domains.model.FilterCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #filterConditions(List<FilterCondition>)}.
         * 
         * @param filterConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53domains.model.FilterCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterConditions(java.util.Collection<FilterCondition>)
         */
        Builder filterConditions(Consumer<FilterCondition.Builder>... filterConditions);

        /**
         * <p>
         * A complex type that contains information about the requested ordering of domains in the returned list.
         * </p>
         * 
         * @param sortCondition
         *        A complex type that contains information about the requested ordering of domains in the returned list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCondition(SortCondition sortCondition);

        /**
         * <p>
         * A complex type that contains information about the requested ordering of domains in the returned list.
         * </p>
         * This is a convenience method that creates an instance of the {@link SortCondition.Builder} avoiding the need
         * to create one manually via {@link SortCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SortCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #sortCondition(SortCondition)}.
         * 
         * @param sortCondition
         *        a consumer that will call methods on {@link SortCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCondition(SortCondition)
         */
        default Builder sortCondition(Consumer<SortCondition.Builder> sortCondition) {
            return sortCondition(SortCondition.builder().applyMutation(sortCondition).build());
        }

        /**
         * <p>
         * For an initial request for a list of domains, omit this element. If the number of domains that are associated
         * with the current Amazon Web Services account is greater than the value that you specified for
         * <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value of
         * <code>NextPageMarker</code> from the previous response, and submit another request that includes the value of
         * <code>NextPageMarker</code> in the <code>Marker</code> element.
         * </p>
         * <p>
         * Constraints: The marker must match the value specified in the previous request.
         * </p>
         * 
         * @param marker
         *        For an initial request for a list of domains, omit this element. If the number of domains that are
         *        associated with the current Amazon Web Services account is greater than the value that you specified
         *        for <code>MaxItems</code>, you can use <code>Marker</code> to return additional domains. Get the value
         *        of <code>NextPageMarker</code> from the previous response, and submit another request that includes
         *        the value of <code>NextPageMarker</code> in the <code>Marker</code> element.</p>
         *        <p>
         *        Constraints: The marker must match the value specified in the previous request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Number of domains to be returned.
         * </p>
         * <p>
         * Default: 20
         * </p>
         * 
         * @param maxItems
         *        Number of domains to be returned.</p>
         *        <p>
         *        Default: 20
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53DomainsRequest.BuilderImpl implements Builder {
        private List<FilterCondition> filterConditions = DefaultSdkAutoConstructList.getInstance();

        private SortCondition sortCondition;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsRequest model) {
            super(model);
            filterConditions(model.filterConditions);
            sortCondition(model.sortCondition);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final List<FilterCondition.Builder> getFilterConditions() {
            List<FilterCondition.Builder> result = FilterConditionsCopier.copyToBuilder(this.filterConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterConditions(Collection<FilterCondition.BuilderImpl> filterConditions) {
            this.filterConditions = FilterConditionsCopier.copyFromBuilder(filterConditions);
        }

        @Override
        public final Builder filterConditions(Collection<FilterCondition> filterConditions) {
            this.filterConditions = FilterConditionsCopier.copy(filterConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConditions(FilterCondition... filterConditions) {
            filterConditions(Arrays.asList(filterConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConditions(Consumer<FilterCondition.Builder>... filterConditions) {
            filterConditions(Stream.of(filterConditions).map(c -> FilterCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SortCondition.Builder getSortCondition() {
            return sortCondition != null ? sortCondition.toBuilder() : null;
        }

        public final void setSortCondition(SortCondition.BuilderImpl sortCondition) {
            this.sortCondition = sortCondition != null ? sortCondition.build() : null;
        }

        @Override
        public final Builder sortCondition(SortCondition sortCondition) {
            this.sortCondition = sortCondition;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDomainsRequest build() {
            return new ListDomainsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
