/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * OperationSummary includes the following elements.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OperationSummary.Builder, OperationSummary> {
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationId").getter(getter(OperationSummary::operationId)).setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(OperationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(OperationSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> SUBMITTED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmittedDate").getter(getter(OperationSummary::submittedDate)).setter(setter(Builder::submittedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedDate").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(OperationSummary::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(OperationSummary::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> STATUS_FLAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusFlag").getter(getter(OperationSummary::statusFlagAsString)).setter(setter(Builder::statusFlag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusFlag").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedDate").getter(getter(OperationSummary::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_ID_FIELD,
            STATUS_FIELD, TYPE_FIELD, SUBMITTED_DATE_FIELD, DOMAIN_NAME_FIELD, MESSAGE_FIELD, STATUS_FLAG_FIELD,
            LAST_UPDATED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String operationId;

    private final String status;

    private final String type;

    private final Instant submittedDate;

    private final String domainName;

    private final String message;

    private final String statusFlag;

    private final Instant lastUpdatedDate;

    private OperationSummary(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.status = builder.status;
        this.type = builder.type;
        this.submittedDate = builder.submittedDate;
        this.domainName = builder.domainName;
        this.message = builder.message;
        this.statusFlag = builder.statusFlag;
        this.lastUpdatedDate = builder.lastUpdatedDate;
    }

    /**
     * <p>
     * Identifier returned to track the requested action.
     * </p>
     * 
     * @return Identifier returned to track the requested action.
     */
    public final String operationId() {
        return operationId;
    }

    /**
     * <p>
     * The current status of the requested operation in the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the requested operation in the system.
     * @see OperationStatus
     */
    public final OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the requested operation in the system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the requested operation in the system.
     * @see OperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Type of the action requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the action requested.
     * @see OperationType
     */
    public final OperationType type() {
        return OperationType.fromValue(type);
    }

    /**
     * <p>
     * Type of the action requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link OperationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the action requested.
     * @see OperationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The date when the request was submitted.
     * </p>
     * 
     * @return The date when the request was submitted.
     */
    public final Instant submittedDate() {
        return submittedDate;
    }

    /**
     * <p>
     * Name of the domain.
     * </p>
     * 
     * @return Name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Message about the operation.
     * </p>
     * 
     * @return Message about the operation.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * Automatically checks whether there are no outstanding operations on domains that need customer attention.
     * </p>
     * <p>
     * Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING_ACCEPTANCE</code>: The operation is waiting for acceptance from the account that is receiving the
     * domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_CUSTOMER_ACTION</code>: The operation is waiting for customer action, for example, returning an
     * email.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_AUTHORIZATION</code>: The operation is waiting for the form of authorization. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendOperationAuthorization.html"
     * >ResendOperationAuthorization</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_PAYMENT_VERIFICATION</code>: The operation is waiting for the payment method to validate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_SUPPORT_CASE</code>: The operation includes a support case and is waiting for its resolution.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFlag} will
     * return {@link StatusFlag#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusFlagAsString}.
     * </p>
     * 
     * @return Automatically checks whether there are no outstanding operations on domains that need customer attention.
     *         </p>
     *         <p>
     *         Valid values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING_ACCEPTANCE</code>: The operation is waiting for acceptance from the account that is
     *         receiving the domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_CUSTOMER_ACTION</code>: The operation is waiting for customer action, for example,
     *         returning an email.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_AUTHORIZATION</code>: The operation is waiting for the form of authorization. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendOperationAuthorization.html"
     *         >ResendOperationAuthorization</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_PAYMENT_VERIFICATION</code>: The operation is waiting for the payment method to validate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_SUPPORT_CASE</code>: The operation includes a support case and is waiting for its
     *         resolution.
     *         </p>
     *         </li>
     * @see StatusFlag
     */
    public final StatusFlag statusFlag() {
        return StatusFlag.fromValue(statusFlag);
    }

    /**
     * <p>
     * Automatically checks whether there are no outstanding operations on domains that need customer attention.
     * </p>
     * <p>
     * Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING_ACCEPTANCE</code>: The operation is waiting for acceptance from the account that is receiving the
     * domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_CUSTOMER_ACTION</code>: The operation is waiting for customer action, for example, returning an
     * email.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_AUTHORIZATION</code>: The operation is waiting for the form of authorization. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendOperationAuthorization.html"
     * >ResendOperationAuthorization</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_PAYMENT_VERIFICATION</code>: The operation is waiting for the payment method to validate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_SUPPORT_CASE</code>: The operation includes a support case and is waiting for its resolution.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusFlag} will
     * return {@link StatusFlag#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusFlagAsString}.
     * </p>
     * 
     * @return Automatically checks whether there are no outstanding operations on domains that need customer attention.
     *         </p>
     *         <p>
     *         Valid values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING_ACCEPTANCE</code>: The operation is waiting for acceptance from the account that is
     *         receiving the domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_CUSTOMER_ACTION</code>: The operation is waiting for customer action, for example,
     *         returning an email.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_AUTHORIZATION</code>: The operation is waiting for the form of authorization. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendOperationAuthorization.html"
     *         >ResendOperationAuthorization</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_PAYMENT_VERIFICATION</code>: The operation is waiting for the payment method to validate.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_SUPPORT_CASE</code>: The operation includes a support case and is waiting for its
     *         resolution.
     *         </p>
     *         </li>
     * @see StatusFlag
     */
    public final String statusFlagAsString() {
        return statusFlag;
    }

    /**
     * <p>
     * The date when the last change was made in Unix time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date when the last change was made in Unix time format and Coordinated Universal Time (UTC).
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submittedDate());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(statusFlagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationSummary)) {
            return false;
        }
        OperationSummary other = (OperationSummary) obj;
        return Objects.equals(operationId(), other.operationId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(submittedDate(), other.submittedDate())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(message(), other.message())
                && Objects.equals(statusFlagAsString(), other.statusFlagAsString())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OperationSummary").add("OperationId", operationId()).add("Status", statusAsString())
                .add("Type", typeAsString()).add("SubmittedDate", submittedDate()).add("DomainName", domainName())
                .add("Message", message()).add("StatusFlag", statusFlagAsString()).add("LastUpdatedDate", lastUpdatedDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SubmittedDate":
            return Optional.ofNullable(clazz.cast(submittedDate()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "StatusFlag":
            return Optional.ofNullable(clazz.cast(statusFlagAsString()));
        case "LastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OperationSummary, T> g) {
        return obj -> g.apply((OperationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OperationSummary> {
        /**
         * <p>
         * Identifier returned to track the requested action.
         * </p>
         * 
         * @param operationId
         *        Identifier returned to track the requested action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the requested operation in the system.
         * </p>
         * 
         * @param status
         *        The current status of the requested operation in the system.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * <p>
         * Type of the action requested.
         * </p>
         * 
         * @param type
         *        Type of the action requested.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the action requested.
         * </p>
         * 
         * @param type
         *        Type of the action requested.
         * @see OperationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationType
         */
        Builder type(OperationType type);

        /**
         * <p>
         * The date when the request was submitted.
         * </p>
         * 
         * @param submittedDate
         *        The date when the request was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedDate(Instant submittedDate);

        /**
         * <p>
         * Name of the domain.
         * </p>
         * 
         * @param domainName
         *        Name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Message about the operation.
         * </p>
         * 
         * @param message
         *        Message about the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Automatically checks whether there are no outstanding operations on domains that need customer attention.
         * </p>
         * <p>
         * Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING_ACCEPTANCE</code>: The operation is waiting for acceptance from the account that is receiving
         * the domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_CUSTOMER_ACTION</code>: The operation is waiting for customer action, for example, returning an
         * email.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_AUTHORIZATION</code>: The operation is waiting for the form of authorization. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendOperationAuthorization.html"
         * >ResendOperationAuthorization</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_PAYMENT_VERIFICATION</code>: The operation is waiting for the payment method to validate.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_SUPPORT_CASE</code>: The operation includes a support case and is waiting for its resolution.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusFlag
         *        Automatically checks whether there are no outstanding operations on domains that need customer
         *        attention. </p>
         *        <p>
         *        Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING_ACCEPTANCE</code>: The operation is waiting for acceptance from the account that is
         *        receiving the domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_CUSTOMER_ACTION</code>: The operation is waiting for customer action, for example,
         *        returning an email.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_AUTHORIZATION</code>: The operation is waiting for the form of authorization. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendOperationAuthorization.html"
         *        >ResendOperationAuthorization</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_PAYMENT_VERIFICATION</code>: The operation is waiting for the payment method to
         *        validate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_SUPPORT_CASE</code>: The operation includes a support case and is waiting for its
         *        resolution.
         *        </p>
         *        </li>
         * @see StatusFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusFlag
         */
        Builder statusFlag(String statusFlag);

        /**
         * <p>
         * Automatically checks whether there are no outstanding operations on domains that need customer attention.
         * </p>
         * <p>
         * Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING_ACCEPTANCE</code>: The operation is waiting for acceptance from the account that is receiving
         * the domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_CUSTOMER_ACTION</code>: The operation is waiting for customer action, for example, returning an
         * email.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_AUTHORIZATION</code>: The operation is waiting for the form of authorization. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendOperationAuthorization.html"
         * >ResendOperationAuthorization</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_PAYMENT_VERIFICATION</code>: The operation is waiting for the payment method to validate.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_SUPPORT_CASE</code>: The operation includes a support case and is waiting for its resolution.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusFlag
         *        Automatically checks whether there are no outstanding operations on domains that need customer
         *        attention. </p>
         *        <p>
         *        Valid values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING_ACCEPTANCE</code>: The operation is waiting for acceptance from the account that is
         *        receiving the domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_CUSTOMER_ACTION</code>: The operation is waiting for customer action, for example,
         *        returning an email.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_AUTHORIZATION</code>: The operation is waiting for the form of authorization. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendOperationAuthorization.html"
         *        >ResendOperationAuthorization</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_PAYMENT_VERIFICATION</code>: The operation is waiting for the payment method to
         *        validate.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_SUPPORT_CASE</code>: The operation includes a support case and is waiting for its
         *        resolution.
         *        </p>
         *        </li>
         * @see StatusFlag
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusFlag
         */
        Builder statusFlag(StatusFlag statusFlag);

        /**
         * <p>
         * The date when the last change was made in Unix time format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date when the last change was made in Unix time format and Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);
    }

    static final class BuilderImpl implements Builder {
        private String operationId;

        private String status;

        private String type;

        private Instant submittedDate;

        private String domainName;

        private String message;

        private String statusFlag;

        private Instant lastUpdatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationSummary model) {
            operationId(model.operationId);
            status(model.status);
            type(model.type);
            submittedDate(model.submittedDate);
            domainName(model.domainName);
            message(model.message);
            statusFlag(model.statusFlag);
            lastUpdatedDate(model.lastUpdatedDate);
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OperationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getSubmittedDate() {
            return submittedDate;
        }

        public final void setSubmittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
        }

        @Override
        public final Builder submittedDate(Instant submittedDate) {
            this.submittedDate = submittedDate;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getStatusFlag() {
            return statusFlag;
        }

        public final void setStatusFlag(String statusFlag) {
            this.statusFlag = statusFlag;
        }

        @Override
        public final Builder statusFlag(String statusFlag) {
            this.statusFlag = statusFlag;
            return this;
        }

        @Override
        public final Builder statusFlag(StatusFlag statusFlag) {
            this.statusFlag(statusFlag == null ? null : statusFlag.toString());
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        @Override
        public OperationSummary build() {
            return new OperationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
