/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResendContactReachabilityEmailResponse extends Route53DomainsResponse implements
        ToCopyableBuilder<ResendContactReachabilityEmailResponse.Builder, ResendContactReachabilityEmailResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(ResendContactReachabilityEmailResponse::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("emailAddress").getter(getter(ResendContactReachabilityEmailResponse::emailAddress))
            .setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()).build();

    private static final SdkField<Boolean> IS_ALREADY_VERIFIED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isAlreadyVerified").getter(getter(ResendContactReachabilityEmailResponse::isAlreadyVerified))
            .setter(setter(Builder::isAlreadyVerified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAlreadyVerified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            EMAIL_ADDRESS_FIELD, IS_ALREADY_VERIFIED_FIELD));

    private final String domainName;

    private final String emailAddress;

    private final Boolean isAlreadyVerified;

    private ResendContactReachabilityEmailResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.emailAddress = builder.emailAddress;
        this.isAlreadyVerified = builder.isAlreadyVerified;
    }

    /**
     * <p>
     * The domain name for which you requested a confirmation email.
     * </p>
     * 
     * @return The domain name for which you requested a confirmation email.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The email address for the registrant contact at the time that we sent the verification email.
     * </p>
     * 
     * @return The email address for the registrant contact at the time that we sent the verification email.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * <code>True</code> if the email address for the registrant contact has already been verified, and
     * <code>false</code> otherwise. If the email address has already been verified, we don't send another confirmation
     * email.
     * </p>
     * 
     * @return <code>True</code> if the email address for the registrant contact has already been verified, and
     *         <code>false</code> otherwise. If the email address has already been verified, we don't send another
     *         confirmation email.
     */
    public final Boolean isAlreadyVerified() {
        return isAlreadyVerified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(isAlreadyVerified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResendContactReachabilityEmailResponse)) {
            return false;
        }
        ResendContactReachabilityEmailResponse other = (ResendContactReachabilityEmailResponse) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(emailAddress(), other.emailAddress())
                && Objects.equals(isAlreadyVerified(), other.isAlreadyVerified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResendContactReachabilityEmailResponse").add("DomainName", domainName())
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IsAlreadyVerified", isAlreadyVerified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "emailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "isAlreadyVerified":
            return Optional.ofNullable(clazz.cast(isAlreadyVerified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResendContactReachabilityEmailResponse, T> g) {
        return obj -> g.apply((ResendContactReachabilityEmailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53DomainsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ResendContactReachabilityEmailResponse> {
        /**
         * <p>
         * The domain name for which you requested a confirmation email.
         * </p>
         * 
         * @param domainName
         *        The domain name for which you requested a confirmation email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The email address for the registrant contact at the time that we sent the verification email.
         * </p>
         * 
         * @param emailAddress
         *        The email address for the registrant contact at the time that we sent the verification email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * <code>True</code> if the email address for the registrant contact has already been verified, and
         * <code>false</code> otherwise. If the email address has already been verified, we don't send another
         * confirmation email.
         * </p>
         * 
         * @param isAlreadyVerified
         *        <code>True</code> if the email address for the registrant contact has already been verified, and
         *        <code>false</code> otherwise. If the email address has already been verified, we don't send another
         *        confirmation email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAlreadyVerified(Boolean isAlreadyVerified);
    }

    static final class BuilderImpl extends Route53DomainsResponse.BuilderImpl implements Builder {
        private String domainName;

        private String emailAddress;

        private Boolean isAlreadyVerified;

        private BuilderImpl() {
        }

        private BuilderImpl(ResendContactReachabilityEmailResponse model) {
            super(model);
            domainName(model.domainName);
            emailAddress(model.emailAddress);
            isAlreadyVerified(model.isAlreadyVerified);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final Boolean getIsAlreadyVerified() {
            return isAlreadyVerified;
        }

        public final void setIsAlreadyVerified(Boolean isAlreadyVerified) {
            this.isAlreadyVerified = isAlreadyVerified;
        }

        @Override
        public final Builder isAlreadyVerified(Boolean isAlreadyVerified) {
            this.isAlreadyVerified = isAlreadyVerified;
            return this;
        }

        @Override
        public ResendContactReachabilityEmailResponse build() {
            return new ResendContactReachabilityEmailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
