/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information for sorting a list of domains.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SortCondition implements SdkPojo, Serializable, ToCopyableBuilder<SortCondition.Builder, SortCondition> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SortCondition::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(SortCondition::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SORT_ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String sortOrder;

    private SortCondition(BuilderImpl builder) {
        this.name = builder.name;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * Field to be used for sorting the list of domains. It can be either the name or the expiration for a domain. Note
     * that if <code>filterCondition</code> is used in the same <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains__ListDomains.html">ListDomains</a>
     * call, the field used for sorting has to be the same as the field used for filtering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ListDomainsAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Field to be used for sorting the list of domains. It can be either the name or the expiration for a
     *         domain. Note that if <code>filterCondition</code> is used in the same <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains__ListDomains.html"
     *         >ListDomains</a> call, the field used for sorting has to be the same as the field used for filtering.
     * @see ListDomainsAttributeName
     */
    public final ListDomainsAttributeName name() {
        return ListDomainsAttributeName.fromValue(name);
    }

    /**
     * <p>
     * Field to be used for sorting the list of domains. It can be either the name or the expiration for a domain. Note
     * that if <code>filterCondition</code> is used in the same <a
     * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains__ListDomains.html">ListDomains</a>
     * call, the field used for sorting has to be the same as the field used for filtering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ListDomainsAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return Field to be used for sorting the list of domains. It can be either the name or the expiration for a
     *         domain. Note that if <code>filterCondition</code> is used in the same <a
     *         href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains__ListDomains.html"
     *         >ListDomains</a> call, the field used for sorting has to be the same as the field used for filtering.
     * @see ListDomainsAttributeName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The sort order for a list of domains. Either ascending (ASC) or descending (DES).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for a list of domains. Either ascending (ASC) or descending (DES).
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for a list of domains. Either ascending (ASC) or descending (DES).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for a list of domains. Either ascending (ASC) or descending (DES).
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SortCondition)) {
            return false;
        }
        SortCondition other = (SortCondition) obj;
        return Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SortCondition").add("Name", nameAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SortCondition, T> g) {
        return obj -> g.apply((SortCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SortCondition> {
        /**
         * <p>
         * Field to be used for sorting the list of domains. It can be either the name or the expiration for a domain.
         * Note that if <code>filterCondition</code> is used in the same <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains__ListDomains.html">ListDomains</a>
         * call, the field used for sorting has to be the same as the field used for filtering.
         * </p>
         * 
         * @param name
         *        Field to be used for sorting the list of domains. It can be either the name or the expiration for a
         *        domain. Note that if <code>filterCondition</code> is used in the same <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains__ListDomains.html"
         *        >ListDomains</a> call, the field used for sorting has to be the same as the field used for filtering.
         * @see ListDomainsAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListDomainsAttributeName
         */
        Builder name(String name);

        /**
         * <p>
         * Field to be used for sorting the list of domains. It can be either the name or the expiration for a domain.
         * Note that if <code>filterCondition</code> is used in the same <a
         * href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains__ListDomains.html">ListDomains</a>
         * call, the field used for sorting has to be the same as the field used for filtering.
         * </p>
         * 
         * @param name
         *        Field to be used for sorting the list of domains. It can be either the name or the expiration for a
         *        domain. Note that if <code>filterCondition</code> is used in the same <a
         *        href="https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains__ListDomains.html"
         *        >ListDomains</a> call, the field used for sorting has to be the same as the field used for filtering.
         * @see ListDomainsAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListDomainsAttributeName
         */
        Builder name(ListDomainsAttributeName name);

        /**
         * <p>
         * The sort order for a list of domains. Either ascending (ASC) or descending (DES).
         * </p>
         * 
         * @param sortOrder
         *        The sort order for a list of domains. Either ascending (ASC) or descending (DES).
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for a list of domains. Either ascending (ASC) or descending (DES).
         * </p>
         * 
         * @param sortOrder
         *        The sort order for a list of domains. Either ascending (ASC) or descending (DES).
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(SortCondition model) {
            name(model.name);
            sortOrder(model.sortOrder);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ListDomainsAttributeName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public SortCondition build() {
            return new SortCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
