/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.FilterCondition;
import software.amazon.awssdk.services.route53domains.model.FilterConditionsCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.services.route53domains.model.SortCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainsRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, ListDomainsRequest> {
    private static final SdkField<List<FilterCondition>> FILTER_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterConditions").getter(ListDomainsRequest.getter(ListDomainsRequest::filterConditions)).setter(ListDomainsRequest.setter(Builder::filterConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SortCondition> SORT_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortCondition").getter(ListDomainsRequest.getter(ListDomainsRequest::sortCondition)).setter(ListDomainsRequest.setter(Builder::sortCondition)).constructor(SortCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortCondition").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListDomainsRequest.getter(ListDomainsRequest::marker)).setter(ListDomainsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListDomainsRequest.getter(ListDomainsRequest::maxItems)).setter(ListDomainsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_CONDITIONS_FIELD, SORT_CONDITION_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));
    private final List<FilterCondition> filterConditions;
    private final SortCondition sortCondition;
    private final String marker;
    private final Integer maxItems;

    private ListDomainsRequest(BuilderImpl builder) {
        super(builder);
        this.filterConditions = builder.filterConditions;
        this.sortCondition = builder.sortCondition;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public final boolean hasFilterConditions() {
        return this.filterConditions != null && !(this.filterConditions instanceof SdkAutoConstructList);
    }

    public final List<FilterCondition> filterConditions() {
        return this.filterConditions;
    }

    public final SortCondition sortCondition() {
        return this.sortCondition;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterConditions() ? this.filterConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sortCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsRequest)) {
            return false;
        }
        ListDomainsRequest other = (ListDomainsRequest)((Object)obj);
        return this.hasFilterConditions() == other.hasFilterConditions() && Objects.equals(this.filterConditions(), other.filterConditions()) && Objects.equals(this.sortCondition(), other.sortCondition()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListDomainsRequest").add("FilterConditions", this.hasFilterConditions() ? this.filterConditions() : null).add("SortCondition", (Object)this.sortCondition()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterConditions": {
                return Optional.ofNullable(clazz.cast(this.filterConditions()));
            }
            case "SortCondition": {
                return Optional.ofNullable(clazz.cast(this.sortCondition()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainsRequest, T> g) {
        return obj -> g.apply((ListDomainsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private List<FilterCondition> filterConditions = DefaultSdkAutoConstructList.getInstance();
        private SortCondition sortCondition;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsRequest model) {
            super(model);
            this.filterConditions(model.filterConditions);
            this.sortCondition(model.sortCondition);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final List<FilterCondition.Builder> getFilterConditions() {
            List<FilterCondition.Builder> result = FilterConditionsCopier.copyToBuilder(this.filterConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterConditions(Collection<FilterCondition.BuilderImpl> filterConditions) {
            this.filterConditions = FilterConditionsCopier.copyFromBuilder(filterConditions);
        }

        @Override
        public final Builder filterConditions(Collection<FilterCondition> filterConditions) {
            this.filterConditions = FilterConditionsCopier.copy(filterConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConditions(FilterCondition ... filterConditions) {
            this.filterConditions(Arrays.asList(filterConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterConditions(Consumer<FilterCondition.Builder> ... filterConditions) {
            this.filterConditions(Stream.of(filterConditions).map(c -> (FilterCondition)((FilterCondition.Builder)FilterCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SortCondition.Builder getSortCondition() {
            return this.sortCondition != null ? this.sortCondition.toBuilder() : null;
        }

        public final void setSortCondition(SortCondition.BuilderImpl sortCondition) {
            this.sortCondition = sortCondition != null ? sortCondition.build() : null;
        }

        @Override
        public final Builder sortCondition(SortCondition sortCondition) {
            this.sortCondition = sortCondition;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDomainsRequest build() {
            return new ListDomainsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainsRequest> {
        public Builder filterConditions(Collection<FilterCondition> var1);

        public Builder filterConditions(FilterCondition ... var1);

        public Builder filterConditions(Consumer<FilterCondition.Builder> ... var1);

        public Builder sortCondition(SortCondition var1);

        default public Builder sortCondition(Consumer<SortCondition.Builder> sortCondition) {
            return this.sortCondition((SortCondition)((SortCondition.Builder)SortCondition.builder().applyMutation(sortCondition)).build());
        }

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

